	SUBROUTINE SETINFO(running_user, cmd_type, options)
	IMPLICIT INTEGER(A-Z)
C
C	SYS$SYSTEM:VMSMAIL.DAT record layout.
C
	CHARACTER  username*31	   !1:31   keyid=0
	BYTE	   mail_flags(2)   !32:33
	BYTE	   mail_count(2)   !34:35
	BYTE	   mail_spare(28)  !36:63
	BYTE	   mail_spare1(2)  !64:65
	BYTE	   dir_length	   !66:66
	BYTE	   per_length	   !67:67
	BYTE	   fwd_length	   !68:68
	CHARACTER  mail_data*639   !See below...
	CHARACTER  forward*256	   !69:69+fwd_length
	CHARACTER  personal*127	   !69:69+fwd_length+per_length
	CHARACTER  directory*256   !69:69+fwd_length+per_length+dir_length
C
C	End of VMSMAIL.DAT record layout.
C
	INTEGER*4 for_len, per_len, dir_len, name_len, mail_len, ios
	INTEGER*4 str$position, str$trim, str$match_wild, option_len
	INTEGER*4 number_nodes, data_len
	CHARACTER local_node*31, mail_node(127)*31, mail_file*40, name*256
	CHARACTER cmd_type*6, running_user*31, hold_node*31
	CHARACTER*256 options(4)
	LOGICAL record_found, mail_search, answer, displayed_record
	LOGICAL modified, new_record
C
	INCLUDE '($LIBDEF)'
        PARAMETER (FOR$_NORECORD = 36)
        PARAMETER (STR$_MATCH    = 2393113)
        PARAMETER (STR$_NOMATCH  = 2392584)
	EXTERNAL netmail_norecord, netmail_decnet, netmail_update
	EXTERNAL netmail_delete, netmail_mailfile, netmail_nopriv
C
C	Set strings and logicals.
C
	forward   = ' '
	personal  = ' '
	directory = ' '
	name      = ' '
	hold_node = ' '
	answer       = .false.
	mail_search  = .true.
	new_record   = .false.
	open	     = .false.
	open_write   = .true.
	privl        = .false.
	record_found = .false.
C
C	Check to see if the user is priveleged if /USER was specified.
C
	icode = STR$TRIM(options(1), options(1), option_len)
	if (option_len.ne.0) then
	CALL CHKPRIVS(cmd_type,privl)
	if(.not.privl) CALL LIB$SIGNAL(netmail_nopriv)
	running_user = options(1)(1:31)
	Endif
C
C	Get MAIL node and local node.
C
	CALL GET_MAIL_NODE(mail_node, local_node, number_nodes, search)
C
C	Open the mail file for update.
C
	mail_index = 1
	DO WHILE (mail_search)
	CALL OPENMAIL(mail_node(mail_index),local_node, open_write, opened)
	if (.not.opened) then
	CALL LIB$SIGNAL(netmail_mailfile,
     +                  mail_node(mail_index)(1:mail_len-2))
	goto 600
	Endif !Skip to index mail_node because file was not opened.
C
C	Get record.
C
100	read(unit=1,iostat=ios,err=200,key=running_user,keyid=0)
     +  username, (mail_flags(I),I=1,2), (mail_count(I),I=1,2),
     +  (mail_spare(I),I=1,28), (mail_spare1(I),I=1,2),
     +  dir_length, per_length, fwd_length, mail_data
C
200	CONTINUE
	if(ios.eq.FOR$_NORECORD) then
	CALL LIB$SIGNAL(netmail_norecord)
	record_found = .false.
	new_record = .true.
	Else
	record_found = .true.
	Endif !Record check.
C
C	Output record.
C
	if((record_found).and.(mail_index.eq.1))
     +  CALL DISPLAYREC(cmd_type, options, username, running_user,
     +             mail_data, fwd_length, per_length, modified,
     +             displayed_record, record_found, new_record, privl)
C
C	Make/change new record and display it.
C
	hold_node = mail_node(mail_index)
	if(cmd_type(1:3).eq.'SET') then
	CALL UPDATE(options, username, mail_data, fwd_length, per_length,
     +              dir_length, privl, hold_node, local_node)
	modified   = .true.
	If (mail_index.eq.1)
     +  CALL DISPLAYREC(cmd_type, options, username, running_user,
     +             mail_data, fwd_length, per_length, modified,
     +             displayed_record, record_found, new_record, privl)
	Endif !Set/DELETE check.
C
C	Go ask if the changes are ok to make.
C
	If (mail_index.eq.1)
     +     CALL VERIFYUPD(cmd_type, record_found, answer)
C
C	Go update the record.
C
	  icode = STR$TRIM(mail_node(mail_index),
     +                     mail_node(mail_index), mail_len)
	  If (cmd_type.eq.'SET') then
	   icode = STR$TRIM(mail_data, mail_data, data_len)
	   If (record_found) then
	   rewrite(1)
     +        username, (mail_flags(I),I=1,2), (mail_count(I),I=1,2),
     +        (mail_spare(I),I=1,28), (mail_spare1(I),I=1,2),
     +        dir_length, per_length, fwd_length, mail_data(1:data_len)
	   CALL LIB$SIGNAL(netmail_update,%val(1),hold_node(1:mail_len-2))
	   close(unit=1)
	   Else !It is a new record.
	   write(1)
     +        username, (mail_flags(I),I=1,2), (mail_count(I),I=1,2),
     +        (mail_spare(I),I=1,28), (mail_spare1(I),I=1,2),
     +        dir_length, per_length, fwd_length, mail_data(1:data_len)
	   CALL LIB$SIGNAL(netmail_update,%val(1),hold_node(1:mail_len-2))
	   close(unit=1)
	   Endif !Update record.
	  Else !The request is to DELETE the record.
	   DELETE(1)
	   CALL LIB$SIGNAL(netmail_delete,%val(1),hold_node(1:mail_len-2))
	  close(unit=1)
	  Endif !SET/DELETE record.
C
600	continue
	mail_index = mail_index + 1
	if (mail_index.gt.number_nodes+1) mail_search = .false.
	Enddo !Update of nodes.
	CALL LIB$PUT_OUTPUT(' ')
C
	return
	end
