$   ver = 'F$VERIFY(0)
$   GOTO LET
$!
$!  PROCEDURE 'LET'
$!
$!  Shorthand method of logical name definition.
$!
$!  Called as:
$!
$!	$ LET lname = sd_operand(s)
$!
$!	$ LET lname = sd_operand(s) + filename
$!
$!	$ LET lname = + filename
$!
$!  Process logical name 'lname' is defined to point to the directory
$!  specified by one or more SD-type operands.  For example:
$!
$!		$ LET LN1 = < ^^
$!
$!  This defines logical name LN1 to point to the top level of the pre-
$!  vious default directory.
$!
$!  Optionally, you can specify a file name, preceded by a plus sign.  In
$!  this case, the logical name is defined to point to this file.  If no
$!  SD operands are present, or if '*' is used as an operand, the current
$!  default directory is assumed.  For example:
$!
$!		$ LET LN2 = 
$!		$ LET LN3 = +ZZZ.FOR
$!		$ LET LN4 = *
$!		$ LET LN5 = .SUBDIR + ZZZ.FOR
$!
$!  Blanks are optional around the equal sign and the plus sign.
$!
$!  A diagnostic message will be displayed, and the definition not made, if
$!  the specified device, directory, or file does not exist or if the caller
$!  has no privilege to be in the specified directory.
$!
$!  If the filename does not have a file type with it, then the logical name
$!  is not given a file type either.  However, some file with this name must
$!  still exist.  Example:
$!
$!		$ LET LN6=+ZZZ	defines LN6 as DEV:[DIR]ZZZ
$!
$!  If two adjacent equal signs are used instead of a single equal sign,
$!  the value of the logical name is not displayed; otherwise it is.
$!
$!
$!  Alan L. Zirkle     N41     4 October 1984
$!
$!
$ LET:
$   ON ERROR THEN  GOTO EXIT
$!
$   IF F$TYPE(sd_sp) .NES. "" THEN  GOTO START
$!
$! First time SD or LET called in this process; initialize.  Any changes
$! in this area must be duplicated in LET.COM.
$!
$   sd_sp == 0
$   sd_slot0 == F$ENVIRONMENT("DEFAULT")
$   sd_slot1 == sd_slot0
$   sd_slot2 == sd_slot0
$   sd_slot3 == sd_slot0
$   sd_slot4 == sd_slot0
$   sd_slot5 == sd_slot0
$   sd_slot6 == sd_slot0
$   sd_slot7 == sd_slot0
$!
$   IF F$TYPE(sd__0) .EQS. "" THEN sd__0 == "SYS$SYSDEVICE:"	! LOCAL1 ******
$   IF F$TYPE(sd__1) .EQS. "" THEN sd__1 == "USERDISK1:"	! LOCAL2 ******
$!
$   IF F$TRNLNM("SD_TRANS") .EQS. "" THEN  DEFINE SD_TRANS -
      "SYS$SYSDEVICE USERDISK1"					! LOCAL3 ******
$!
$ START:
$   IF p1 .EQS. "$"    THEN  GOTO VERSION			! LOCAL8 ******
$!
$   param := 'p1 'p2 'p3 'p4 'p5 'p6 'p7 'p8
$!
$   RUN SYS$DISK:[VAX86C.NSWC]LET				! LOCAL4 ******
$!
$   WRITE SYS$OUTPUT "
  ",name," = ",F$TRNLNM(name),"
"
$!
$   GOTO EXIT
$!
$ VERSION:
$   sgs_version = "3.1"
$   WRITE SYS$OUTPUT "
	[7m LET.COM Version ",-
						SGS_VERSION," [m
"
$   param = "$"
$   RUN SYS$DISK:[VAX86C.NSWC]LET				! LOCAL5 ******
$!
$ EXIT:
$   IF ver THEN  SET VERIFY
