$   GOTO REMINDERS
$!
$!  Procedure 'REMINDERS'
$!
$!  This procedure should be started as a batch process or as a
$!  detached process by SYSTARTUP.COM or soon after; the REMINDER
$!  command will not work unless this is in the system.  Note that
$!  this process will spend almost all of its time hibernating, and
$!  thus should not cause a resource problem.
$!
$!  It is started up by a statement like one of the following:
$!
$!	$ @REMINDERS BATCH
$!
$!	$ @REMINDERS DETACHED
$!
$!  If the Reminder Event File does not exist, it is created.
$!  If in batch mode or a detached process, the REMINDERS program
$!  is executed.  If in interactive mode, the choice is given of run-
$!  ning REMINDERS interactively, in batch mode, or as a detached
$!  process.
$!
$!  The Reminder Event File is (on our VAX):
$!
$!	SYS$DISK:[VAX86C.NSWC]REMINDERS.DAT
$!
$!  This is an indexed sequential file, with variable-length
$!  formatted records up to 100 characters long.
$!
$!  If you change the name (or location) of the file, you must
$!  change the CLD file for the REMINDER command, and also you
$!  you must change this procedure in three places.
$!
$!  The first record on the Reminder Event File MUST BE BLANK.
$!  Two types of records may follow; first come REMINDER records
$!  (if any), then come ACCESS records (if any).
$!
$!  The format of REMINDER records is:
$!
$!     Col  1-25  --  Username (blank on first record)
$!
$!     Col 27-51  --  Event time, in format '25-DEC-83 12:00'
$!
$!			(note '83', not '1983' as in regular VAX dates)
$!
$!     Col 52     --  Blank, or flag used by the REMINDERS program.
$!
$!     Col 53-100 --  Reason for event (optional)
$!
$!  The format of ACCESS records is:
$!
$!     Col 1      --  Backslash ('\')
$!
$!     Col 2-13   --  Username of user GIVING access to his/her
$!		      reminders.
$!
$!     Col 14-25  --  Username of user RECEIVING access to the
$!		      above user's reminders.
$!
$!
$!  Alan L. Zirkle      K105     23 November 1983
$!
$!
$ REMINDERS:
$   int = F$MODE() .EQS. "INTERACTIVE
$!
$   IF p1 .NES. "" THEN  GOTO MODE
$   IF .NOT.int    THEN  GOTO START
$!
$ INQUIRE:
$   WRITE SYS$OUTPUT -
"
Do you want to run REMINDERS interactively, as a batch job, or as a"
$   WRITE SYS$OUTPUT "detached process?
"
$!
$   INQUIRE p1 "Enter INT, BAT, OR DET"
$!
$ MODE:
$   WRITE SYS$OUTPUT " "
$   p1 = F$EXTRACT(0,1,p1)
$!
$   IF p1 .EQS. "I" THEN  GOTO START
$   IF p1 .EQS. "B" THEN  GOTO BATCH
$   IF p1 .EQS. "D" THEN  GOTO DETACH
$   IF int GOTO INQUIRE
$   WRITE SYS$OUTPUT "----- Invalid Parameter Passed to REMINDERS.COM -----
"
$   EXIT
$!
$ BATCH:
$   queue = F$EXTRACT(0,2,F$GETSYI("NODENAME")) + "_QUEUE"	        !**LOCAL
$!
$   SUBMIT /QUEUE='queue' /USER=SYSTEM -				!**LOCAL
				SYS$DISK:[VAX86C.NSWC]REMINDERS.COM	!**LOCAL
$   WRITE SYS$OUTPUT " "
$   EXIT
$!
$ DETACH:
$   RUN /PRIO=5 /DETACH /UIC=[SYSTEM] SYS$SYSTEM:LOGINOUT /PROC=REMINDERS -
			/INPUT=SYS$DISK:[VAX86C.NSWC]REMINDERS.COM -	!**LOCAL
			/OUTPUT=SYS$DISK:[VAX86C.NSWC]REMINDERS.LOG	!**LOCAL
$   WRITE SYS$OUTPUT " "
$   EXIT
$!
$ START:
$   file = "SYS$DISK:[VAX86C.NSWC]REMINDERS.DAT"			!**LOCAL
$!
$   IF F$SEARCH(file) .NES. "" THEN  GOTO RUN
$!
$   WRITE SYS$OUTPUT "
Creating Reminder Event File
"
$!
$   ON CONTROL_Y THEN  GOTO ERROR
$   ON ERROR     THEN  GOTO ERROR
$!
$   fdl  = "SYS$DISK:[VAX86C.NSWC]REMINDERS.FDL"			!**LOCAL
$!
$   CREATE /FDL='fdl' 'file'
$!
$   OPEN /APPEND CAL 'file'
$   WRITE        CAL "                              "
$   CLOSE        CAL
$!
$   GOTO RUN
$!
$ ERROR:
$   SET NOON
$   IF F$LOGICAL("CAL") .NES. "" THEN  CLOSE CAL
$   WRITE SYS$OUTPUT "
Reminder Event File Creation Failed.
"
$   EXIT %X10000004
$!
$ RUN:
$   IF F$MODE() .EQS. "BATCH" THEN  SET PROCESS /NAME=REMINDERS
$   IF F$MODE() .EQS. "BATCH" THEN  SET PROCESS /PRIV=ALTPRI
$   IF F$MODE() .EQS. "BATCH" THEN  SET PROCESS /PRIORITY=5
$!
$   OPEN /ERR=OPEN XXX 'file'	! See if rest of cluster has file open already
$   CLOSE XXX
$!
$   CONVERT 'file' 'file'	! Rebuild file to prevent possible corruption
$   PURGE 'file'
$   SET PROT=(S:REWD,O:REW,G:REW,W:REW) 'file'
$!
$ OPEN:
    log = "SYS$DISK:[VAX86C.NSWC]REMINDERS.LOG"				!**LOCAL
$   IF F$SEARCH(log+";-4") .NES. "" THEN  PURGE /KEEP=4 'log'
$!
$   RUN SYS$DISK:[VAX86C.NSWC]REMINDERS					!**LOCAL
/
SYS$DISK:[VAX86C.NSWC]REMINDERS.DAT

$!
