/*
/*      TITLE:                  ALLOCATE - ALLOCATE DEVICE ROUTINE
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		ALLOCATE
/*	SOURCE FILE:		ALLOCATE.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   July 18, 1984
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     07/18/84	W. E. Baisley	Original release.
/*
/*	   1)	     08/15/84	W. E. Baisley	Phylen argument to SYS$ALLOC is a
/*						short int (word).  Added check for
/*						NULL buffer when terminating string.
/*
/*	   2)	     08/14/85	W. E. Baisley	Add (unused) flags argument to the 
/*						SYS$ALLOC call, for VMS V4.0, and 
/*						document each argument.
/*
/*	   3)	     09/10/85	W. E. Baisley	Use the new check_status routine 
/*						to check for a successful call.
/*						Make better use of registers.
/*
/*      NOTES:		Allocate attempts to allocate a device for exclusive use
/*			by the calling program and its process.  If successful, 
/*			allocate provides the name of the physical device in the
/*			buffer argument, if provided (it can be specified as NULL),
/*			which must be 64 bytes long.  Success is indicated if the
/*			SYS$ALLOC routine returns a successful status (SS$_NORMAL,
/*			SS$_BUFFEROVF, or SS$_DEVALRALLOC).
/*
/*      USAGE:          device_name_length = allocate ("device:", &buffer);
/*
/*			If provided, "buffer" must be at least 64 bytes long.
/*
/*      RETURNS:        Number of characters in the physical device name, excluding
/*			the terminating NUL; or 0 if the allocation attempt failed.
/* */
	
#include <stdio>
#include <descrip>

#define $DESCRIPTOR_S(name, string) struct dsc$descriptor_s name = { strlen(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }
#define	LOGICAL_NAME_SIZE 63

allocate (device, buffer)

char *device;
register char *buffer;

{

	register int status;
	short int length;
	$DESCRIPTOR_S (device_desc, device);
	struct dsc$descriptor_s buffer_desc;
	register struct dsc$descriptor_s *buffer_desc_p = &buffer_desc;

/*	Set up the buffer string descriptor	*/

	if (buffer != NULL)	{

		buffer_desc_p->dsc$w_length = LOGICAL_NAME_SIZE;
		buffer_desc_p->dsc$b_dtype = DSC$K_DTYPE_T;
		buffer_desc_p->dsc$b_class = DSC$K_CLASS_S;
		buffer_desc_p->dsc$a_pointer = buffer;

	}

	else
		buffer_desc_p = NULL;

	status = sys$alloc (	&device_desc, 		/* devnam -- could be a logical name */
				&length, 		/* phylen -- how many chars put into ... */
				buffer_desc_p, 		/* phybuf -- the allocated physical device */
				NULL,			/* acmode -- access mode, unused by us */
				NULL			/* flags  -- device type, unused by us */
						);

	if (check_status (&status, NULL))	{

		if (buffer != NULL)
			buffer [length] = '\0';

	}

	else
		length = 0;

	return (length);

}
