/*
/*	TITLE:                  CHAIN - ISSUE A COMMAND AND TRANSFER CONTROL 
/*					TO THE CLI ROUTINE
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		CHAIN
/*	SOURCE FILE:		CHAIN.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*	DATE:			October 29, 1985
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     10/29/85	W. E. Baisley	Original release.
/*
/*	NOTES:
/*
/*		This routine operates in the following fashion:
/*
/*		The given command line is prefixed with the DCL command string token 
/*		"$ ", and then passed to the LIB$DO_COMMAND.  If successful, chain 
/*		will not return to the caller.  If not successful, an error message 
/*		is issued via the complain routine, and chain returns the error status
/*		to the calling routine.
/* */
	
#include <ctype.h>
#include <descrip.h>
#include <ssdef.h>
#include <stdio.h>

#define	COMMAND_LEN	(255)		/* Command line length */
#define	ERROR_LEN	(192)		/* Complaint buffer length */

chain (line)

char *line;

{

	register char *cp;
	int status = SS$_NORMAL;

/*		Buffers And Associated String Descriptors		*/

	char command_line [COMMAND_LEN + 1];		/* Command line buffer */
	$DESCRIPTOR (cmd_desc, command_line);		/* Command line descriptor */
	register struct dsc$descriptor_s *cmd_desc_p = &cmd_desc;
	static char error_buf [ERROR_LEN + 1] = "%";	/* Complaint buffer */

/*		Issue the command 	*/
	
	cp = strxcpy (strzcpy (command_line, "$ "), line, COMMAND_LEN - 2);
	cmd_desc_p->dsc$w_length = cp - command_line;
	status = lib$do_command (cmd_desc_p);

/*	if (status == SS$_NORMAL)	{
*/
/*		Complain -- we aren't supposed to be here		*/

		cp = strzcpy (strzcpy (&error_buf [1], cimageid (NULL)), 
				"-F-SYSERROR, CHAIN routine internal error\n");
		strzcpy (cp, "-CHAIN-F-NOCHAIN, Unable to execute command");
		complain (status, error_buf);

/*	}
*/
	return (status);

}
