/*
/*      TITLE:                  check_status - CHECK THE STATUS OF A SYSTEM SERVICE CALL
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		check_status
/*	SOURCE FILE:		CHECKSTAT.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   September 9, 1985
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     09/09/85	W. E. Baisley	Original release.
/*
/*	NOTES:	check_status is typically used as follows.  
/*
/*			if (check_status (&status, &iosb))	/* Okay ? */
/*				...
/*			else					/* Not ? */
/*				...
/*
/*		Returns YES or NO, depending on whether the system service call was successful.
/*		If the call's status was successful and an IOSB provided, check_status inserts 
/*		the IOSB status into "status" (hence the need to pass status by reference).  
/*
/* */

#include <iostr.h>
#include <stsdef.h>

check_status (status, iosb)

register int *status;
struct io$iosb *iosb;

{

	register struct io$iosb *iosb_p;

	if (*status & STS$M_SUCCESS)
		if (iosb_p = iosb)
			*status = iosb_p->sb$w_status;

	return (*status & STS$M_SUCCESS);

}
