/*
/*	TITLE:                  CIMAGEID -- OBTAIN THE CALLING IMAGE'S NAME
/*	SYSTEM:			COMMON DEC
/*	SUBSYSTEM:		C INTERNAL SUPPORT ROUTINES
/*	ENTRY POINT:		CIMAGEID
/*	SOURCE FILE:		CIMAGEID.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   October 30, 1985
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     10/30/85	W. E. Baisley	Original release.  This routine
/*						is similar to the cuserid routine
/*						and is called in the same manner.
/*	NOTES:
/*
/*		image_p = cimageid (buffer);
/*
/*		If buffer is NULL, then the image name is stored in an internal 
/*		buffer, and the address of that buffer is returned.  Otherwise, 
/*		the image name is stored in the buffer provided, which must be 
/*		L_cimageid (defined in stdio.h) bytes long.  If an error occurs
/*		while trying to obtain the image name, an error message is 
/*		printed, and the string "NO_NAME" is placed in the buffer.
/*
/* */

#include <iostr.h>
#include <jpidef.h>
#include <nam.h>
#include <ssdef.h>
#include <stdio.h>

#define FLAG		(1)		/* Event Flag Number for various wait operations */
#define NO_NAME		"NO_NAME"	/* Our id when our ego is destroyed, Freud */

static char image_name [L_cimageid] = "";

char *cimageid (str)

char *str;

{

	int i;
	int status = SS$_NORMAL;
	char event_flag = FLAG;
	register char *image_p;
	register char *cp;
	struct io$iosb iosb;
	register struct io$iosb *iosb_p = &iosb;

/*		Get Process Information Items		*/

	char full_image_spec [NAM$C_MAXRSS + 1];
	struct itl$item_list get_image_list [] = {
		{NAM$C_MAXRSS, JPI$_IMAGNAME, &full_image_spec, NULL},
		{NULL, NULL, NULL, NULL}
	};

	if (!(image_p = str))
		image_p = image_name;

	*image_p = '\0';

	status = sys$getjpiw (	event_flag,		/* efn    - event flag number */
				NULL,	 		/* pidadr - address of longword containing PID */
				NULL,			/* prcnam - process name descriptor */
				&get_image_list,	/* itmlst - list of item descriptors */
				iosb_p,			/* iosb   - I/O Status Block address */
				NULL, 			/* astadr - AST service routine address */
				NULL);			/* astprm - AST parameter */

	if (!check_status (&status, iosb_p))
		complain (status, "%CIMAGEID-F-SYSERROR, CIMAGEID routine unable to get process information");

/*		Isolate the calling image's filename		*/

	else	{

		cp = full_image_spec;

		while (cp [(i = strcspn (cp, "]>"))] )		/* Skip past the rightmost right bracket */
			cp += (++i);
		cp [strcspn (cp, ".; \t")] = '\0';		/* Take only the image's filename portion */

		strxcpy (image_p, cp, L_cimageid);

	}

	return (image_p);

}
