/*
/*      TITLE:                  COMPLAIN - PRINT AN ERROR MESSAGE ON SYS$OUTPUT
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		COMPLAIN
/*	SOURCE FILE:		COMPLAIN.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   September 9, 1985
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     09/09/85	W. E. Baisley	Original release.
/*
/*	   1)	     09/20/85	W. E. Baisley	Modified to add flexibility in 
/*						the output formatting.
/*
/*	NOTES:
/*
/*		Usage is 	complain (msg_no, user_text);
/*
/*				int msg_no;			/* VMS Message Number */
/*				char *user_text;		/* Optional text line */
/*
/*		Output is to stdout (SYS$OUTPUT)
/*
/*		Output format for the msg_no text is standard VMS (%FACILITY-S-ERROR, Text)
/*
/*		Three format variations exist, illustrated as follows :
/*
/*			complain (status, NULL)
/*				->	%FACILITY-S-ERROR, Text
/*
/*			complain (status, "Arbitrary user text")
/*				->	Arbitrary user text (usually starts with %)
/*				->	-FACILITY-S-ERROR, Text
/*
/*			complain (status, "-User text")
/*				->	%FACILITY-S-ERROR, Text
/*				->	-User text
/* */

#include <descrip.h>
#include <stdio.h>

#define	MESSAGE_LEN	(256)		/* Message line length */
	
complain (msg_no, user_text)

int  msg_no;
register char *user_text;

{

	char message_line [MESSAGE_LEN + 1];
	register char *message_p = message_line;
	$DESCRIPTOR (msg_desc, message_line);
	register struct dsc$descriptor_s *desc_p = &msg_desc;
	short int length = 0;
	static char continuation [] = "\n-";

	sys$getmsg (	msg_no,			/* msgid  - message number */
			&length,		/* msglen - length of the message */
			desc_p,			/* bufadr - message buffer descriptor */
			0XF,			/* flags  - message components to be returned */
			NULL);			/* outadr - unused */

	message_p [length] = '\0';

	if (!user_text)
		user_text = "";

	else 	{

		if (*user_text != '-')	{

			fputs (user_text, stdout);

			if (length)	{

				fputs ("\n", stdout);
				*message_p = '-';

			}

		}

	}

	fputs (message_p, stdout);

	if ((*user_text == '-') && (length))	{

		fputs ("\n", stdout);
		fputs (user_text, stdout);

	}

	fputs ("\n", stdout);

	return;

}
