/*
/*      TITLE:                  CREMBX - CREATE TEMPORARY MAILBOX ROUTINE
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		CREMBX
/*	SOURCE FILE:		CREMBX.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   July 25, 1984
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     07/25/84	W. E. Baisley	Original release.
/*
/*	   1)	     08/14/85	W. E. Baisley	Update for VMS V4.1: use the 
/*						new "Wait" form of SYS$GETDVI;
/*						needn't check for SS$_CONCEALED 
/*						anymore; the chan argument is 
/*						now a longword, and is passed 
/*						to SYS$GETDVIW by reference.  
/*						Pass a NULL to SYS$CREMBX for 
/*						the lognam argument if log_name
/*						is NULL.
/*
/*	   2)	     09/10/85	W. E. Baisley	Use the new check_status routine 
/*						to check both the status word and 
/*						the iosb (from $GETDVIW).
/*
/*	   3)	     09/13/85	W. E. Baisley	Reduce to 4 the number of messages 
/*						that the mailbox can handle, since 
/*						most mailbox I/O is done without 
/*						specifying the IO$M_NOW qualifier.
/*
/*	USAGE:
/*
/*		status = crembx (log_name, &unit, &channel);
/*
/*		long status;	/* status from $CREMBX or $GETDVIW */
/*		char *log_name;	/* logical name to be assigned to mailbox */
/*		long unit;	/* unit number of created mailbox */
/*		long channel;	/* assigned channel number */
/*
/*		The log_name, unit and/or channel arguments may be NULL.
/*
/*	NOTES:
/*
/*	This routine creates a mailbox with the following characteristics :
/*
/*		1)	It is temporary.
/*		2)	It can handle messages up to 132 bytes long.
/*		3)	It can buffer up to 4 messages.
/*		4)	It has no protection bits set.
/*		5)	It has an access mode of "USER".
/*
/* */
	
#include <descrip.h>
#include <dvidef.h>
#include <iostr.h>
#include <psldef.h>
#include <stdio.h>

#define BUFFER_LEN	(132)		/* Message buffer length */
#define MAILBOX_LEN	(BUFFER_LEN*4)	/* Total mailbox capacity */
#define FLAG		(0)		/* Event Flag number */
#define TEMPORARY	(0)		/* Mailbox life indicator */

crembx (log_name, unit_number, channel)

char *log_name;
long *unit_number;
long *channel;

{

	int status;
	struct io$iosb iosb;
	register struct io$iosb *iosb_p = &iosb;

/*		Communications Mailbox Items		*/

	long mbx_chan = 0;
	struct dsc$descriptor_s mbx_desc = {
		0, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL
	};
	register struct dsc$descriptor_s *mbx_desc_p = &mbx_desc;

/*		Get Device Information Items		*/

	long unit;
	struct itl$item_list unit_list [] = {
		{sizeof (unit), DVI$_UNIT, &unit, 0},
		{0, 0, 0, 0}
	};

	if (log_name != NULL)	{

		mbx_desc_p->dsc$w_length = strlen (log_name);
		mbx_desc_p->dsc$a_pointer = log_name;

	}

	else
		mbx_desc_p = NULL;

	status = sys$crembx (	TEMPORARY,	/* prmflg - permanent indicator */
				&mbx_chan, 	/* chan   - word to receive channel number */
				BUFFER_LEN,	/* maxmsg - message size limit */
				MAILBOX_LEN,	/* bufquo - system dynamic memory quota */
				0, 		/* promsk - protection mask */
				PSL$C_USER,	/* acmode - access mode */
				mbx_desc_p);	/* lognam - logical name descriptor */

	if (check_status (&status, NULL))	{

		if (channel != NULL)
			*channel = mbx_chan;

		if (unit_number != NULL)	{

			status = sys$getdviw (	FLAG, 		/* efn    - event flag number */
						&mbx_chan, 	/* chan   - I/O channel assigned to the device */
						0, 		/* devnam - device name descriptor */
						&unit_list, 	/* itmlst - list of item descriptors */
						iosb_p,		/* iosb   - I/O Status Block address */
						0, 		/* astadr - AST service routine address */
						0, 		/* astprm - AST parameter */
						0); 		/* future - unused but must be present */

			if (check_status (&status, iosb_p))
				*unit_number = unit;

		}

	}

	return (status);

}
