/*
/*      TITLE:                  DEALLOCATE - DEALLOCATE DEVICE ROUTINE
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		DEALLOCATE
/*	SOURCE FILE:		DEALLOCATE.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   August 11, 1986
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     08/11/86	W. E. Baisley	Original release.
/*
/*
/*      NOTES:		DEALLOCATE deallocates a device previously allocated
/*			(usually by means of the ALLOCATE function) for exclusive
/*			use by the calling program and its process.  Success is 
/*			indicated if the SYS$DALLOC routine returns a successful 
/*			status (SS$_NORMAL, or SS$_DEVNOTALLOC).
/*
/*      USAGE:          status = deallocate ("device:");
/*
/*      RETURNS:        1 if we're happy; 0 if the deallocation attempt failed.
/* */
	
#include <stdio>
#include <descrip>
#include <ssdef>

#define $DESCRIPTOR_S(name, string) struct dsc$descriptor_s name = { strlen(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }

deallocate (device)

register char *device;

{

	int status;
	register int *stat_p = &status;
	$DESCRIPTOR_S (device_desc, device);

	*stat_p = sys$dalloc (	&device_desc, 		/* devnam -- could be a logical name */
				NULL,			/* acmode -- access mode, unused by us */
						);

	if (*stat_p == SS$_DEVNOTALLOC)			/* ignore this warning */
		*stat_p = SS$_NORMAL;

	return (check_status (stat_p, NULL));

}
