/*
/*      TITLE:                  FILL - FILL A BUFFER WITH A CHARACTER
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		FILL
/*	SOURCE FILE:		FILL.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   December 21, 1984
/*
/*	REVISIONS      DATE	  PROGRAMMER		DESCRIPTION
/*	---------    --------	--------------	-----------------------------
/*
/*	   0)	     12/21/84	W. E. Baisley	Original release.
/*
/*	   1)	     09/17/85	W. E. Baisley	Add a proper header, and add ".h" 
/*						to the "descrip" include file.  
/*						Add the count_p variable.
/*
/*	NOTES :
/*
/*		fill (&buffer, count, character);
/*
/*		Where:
/*			buffer		- Pointer to the buffer to be filled
/*			count		- Number of bytes
/*			character	- Character to be put into the buffer
/*
/*		Returns:
/*
/*			count;
/*
/*  */

#include <descrip.h>

fill (buffer, count, character)

char	*buffer;		/* Pointer to the buffer */
int	count;			/* Number of elements to do */
char	character;		/* Character to put into the buffer */

{

	register int			 *count_p = &count;
	         struct dsc$descriptor_s str_desc;
	register struct dsc$descriptor_s *str_desc_p = &str_desc;

	str_desc_p->dsc$a_pointer = buffer;
	str_desc_p->dsc$b_dtype = DSC$K_DTYPE_T;
	str_desc_p->dsc$b_class = DSC$K_CLASS_S;
	str_desc_p->dsc$w_length = *count_p;

	str$dupl_char (str_desc_p, count_p, &character);

	return (*count_p);

}	
