/*
/*      TITLE:                  GETTIME - FORMAT CURRENT TIME AND DATE ROUTINE
/*	SYSTEM:			COMMON DEC
/*	SUBSYSTEM:		SYSTEM LIBRARY
/*	ENTRY POINT:		GETTIME
/*	SOURCE FILE:		GETTIME.C
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   July 18, 1984
/*
/*	REVISIONS:	DATE	PROGRAMMER		DESCRIPTION
/*			----	--------------	-----------------------------
/*
/*         1)         07/18/84  W. E. Baisley   Original release.
/*
/*	   2)	      07/25/84	W. E. Baisley	Put the month and date items into
/*						fixed-length fields so everything 
/*						lines up in columns.
/*
/*      NOTES:		Gettime returns the address of a string containing the 
/*			current time and date formatted in the following manner:
/*
/*			"10:27:12 AM  Wednesday  September 19, 1984"
/*			"04:32:45 PM  Monday     May        6, 1984"
/*
/*      USAGE:          char_pointer = gettime ();
/*
/*      RETURNS:        Address of a static time format string.  This string is
/*			always 42 characters long, plus a NUL terminator.
/* */
	
#include <ctype.h>
#include <time.h>
#include <types.h>

extern time_t time ();

#define LENGTH 42

static char time_string [LENGTH+1] = {""};

static time_t _time = 0;

static char *da[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
		     "Friday", "Saturday"};

static char *mo[] = {"January", "February", "March", "April", "May", "June", "July",
		     "August", "September", "October", "November", "December"};

char *gettime ()
	
{
	
	register char *cp;
	register struct tm *timp;
	register int hour;
	
/*	Find out what time it is	*/

	_time = time ((time_t *) 0L);
	timp = localtime (&_time);

/*	Adjust the time for AM/PM	*/

	hour = timp->tm_hour;
	cp = ((hour < 12) ? "AM" : "PM");
	if (hour > 12)
		hour -= 12;
	else if (!hour)
		hour += 12;

/*	Format the time string		*/

	sprintf (time_string, "%02d:%02d:%02d %s  %-9s  %-9s %2d, %d",
		 hour, timp->tm_min, timp->tm_sec, cp, da[timp->tm_wday], 
		 mo[timp->tm_mon], timp->tm_mday, timp->tm_year + 1900);
	time_string [LENGTH] = '\0';

	return (&time_string);
	
}
