/*
 *	IOSTR.H - VMS I/O-Related Descriptor Structure Definitions
 *	(Based on the VAX-11 Procedure Calling and Condition Handling Standard, Revision 9.0 [7-Dec-81])
 */

/*
 *	io$iosb		General Purpose I/O Status Block structure definition
 */
struct io$iosb	{
	unsigned short	sb$w_status;		/* I/O status code */
	unsigned short	sb$w_count;		/* I/O transfer byte count */
	long		sb$l_2nd;		/* device-dependent information */
};

/*
 *	itl$item_list	Get Device Information List structure definition
 */
struct itl$item_list	{
	unsigned short	itl$w_length;		/* length of buffer in bytes (4 minimum) */
	unsigned short	itl$w_code;		/* item code */
	char		*itl$a_address;		/* buffer address */
	unsigned short	*itl$a_return;		/* address of word to receive number of bytes returned */
};
