/*****
**      TITLE:                  PRCDEF - PROCESS CREATION DEFINITIONS
**	SYSTEM:			COMMON DEC
**	ENTRY POINT:		<NONE>
**	SOURCE FILE:		PRCDEF.H
**	PROGRAMMER:		Wayne E. Baisley
**	SOFTWARE TREE:		CCLIB.STS
**      DATE:                   September 16, 1985
**
**	REVISIONS:	DATE	PROGRAMMER		DESCRIPTION
**			----	--------------	-----------------------------
**
**	   1)	      09/16/85	W. E. Baisley	Copied this file from the VAX-11C V1.5 
**						files and added definitions consistent 
**						with VAX/VMS V4.2 and VAXC V2.0.
**
******
*****/

/*
 *	PRCDEF.H - VMS Process Status Bit Definitions
 */

#ifndef PRC$S_PRCDEF

#define PRC$M_SSRWAIT	0x0001		/* Disable resource wait mode */
#define PRC$V_SSRWAIT	0
#define PRC$M_SSFEXCU	0x0002		/* Enable system service failure exception mode */
#define PRC$V_SSFEXCU	1
#define PRC$M_PSWAPM	0x0004		/* Inhibit process swapping (PSWAPM privilege required) */
#define PRC$V_PSWAPM	2
#define PRC$M_NOACNT	0x0008		/* Do not perform accounting (NOACNT privilege required) */
#define PRC$V_NOACNT	3
#define PRC$M_BATCH	0x0010		/* Batch process (DETACH privilege required) */
#define PRC$V_BATCH	4
#define PRC$M_HIBER	0x0020		/* Force process to hibernate initially */
#define PRC$V_HIBER	5
#define PRC$M_NOUAF	0x0040		/* Bypass authorization check for detached LOGINOUT.EXE */
#define PRC$V_NOUAF	6
#define PRC$M_LOGIN	PRC$M_NOUAF	/* Old name for PRC$M_NOUAF */
#define PRC$V_LOGIN	PRC$V_NOUAF
#define PRC$M_NETWRK	0x0080		/* Create a network connect object (DETACH privilege required) */
#define PRC$V_NETWRK	7
#define PRC$M_DISAWS	0x0100		/* Disable system-initiated working set adjustment */
#define PRC$V_DISAWS	8
#define PRC$M_DETACH	0x0200		/* Create a detached process (DETACH privilege required) */
#define PRC$V_DETACH	9
#define PRC$M_INTER	0x0400		/* Create an interactive process */
#define PRC$V_INTER	10
#define PRC$M_IMGDMP	0x0800		/* Enable image dump facility */
#define PRC$V_IMGDMP	11
#define PRC$M_CLISPEC	0x1000		/* CLI specified ? */
#define PRC$V_IMGDMP	12
#define PRC$M_NOPASSWORD	0x2000	/* Login under the creator's account */
#define PRC$V_NOPASSWORD	13

/* Miscellaneous Process Creation definitions */

#define	PRC$_LISTEND	0		/* End of a prcdef list */
#define	PRC$_PGFLCHAR	1
#define	PRC$_PGFLINDEX	2
#define	PRC$_INPUT_ATT	3
#define	PRC$_OUTPUT_ATT	4
#define	PRC$_ERROR_ATT	5
#define	PRC$S_PRCDEF	2		/* Size of a prcdef specifier ? */

#endif					/* ifndef PRC$S_PRCDEF */
