/*  */
/*      TITLE:                  STDIO - UNIX 'Standard I/O' DEFINITIONS
/*	SYSTEM:			COMMON DEC
/*	ENTRY POINT:		<NONE>
/*	SOURCE FILE:		STDIO.H
/*	PROGRAMMER:		Wayne E. Baisley
/*	SOFTWARE TREE:		CCLIB.STS
/*      DATE:                   July 31, 1984
/*
/*	REVISION	DATE	  PROGRAMMER		DESCRIPTION
/*	--------      --------	--------------	-----------------------------
/*
/*         1)         07/31/84  W. E. Baisley   Modified version of DEC's stdio.h
/*						file from VAX-11C V1.4.  To their
/*						file have been added definitions 
/*						for abs, min, max, YES, NO, and
/*						FOREVER.
/*
/*	   2)	      08/07/84	W. E. Baisley	Add #define to convert "unlink"
/*						into "delete".
/*
/*	   3)	      08/20/85	W. E. Baisley	Merge GSD changes with VAXC V2.0.
/*
/*	   4)	      09/20/85	W. E. Baisley	Add declarations for all the known 
/*						string functions which return addresses.
/*
/*	   5)	      10/30/85	W. E. Baisley	Add definitions for L_cimageid, STDIN, 
/*						STDOUT and STDERR, and declarations for 
/*						cimageid, ctermid, cuserid and getname.
/*  */

/*	STDIO - UNIX 'Standard I/O' Definitions 	 */

# ifndef __FILE
# define __FILE 1

# define _NFILE 20
# define BUFSIZ 512

	extern	struct	_iobuf 
		{
		int	_cnt;
		char	*_ptr;
		char	*_base;
		char	_flag;

#define	_IOREAD		0x01
#define	_IOWRT		0x02
#define	_IONBF		0x04
#define	_IOMYBUF	0x08
#define	_IOEOF		0x10
#define	_IOERR		0x20
#define	_IOSTRG		0x40
#define _IORW		0x80

		char	_file;

		};

typedef struct _iobuf*	FILE;
extern noshare	FILE	*stdin, *stdout, *stderr;

#define STDIN		(*stdin->_file)
#define STDOUT		(*stdout->_file)
#define STDERR		(*stderr->_file)

#define	NULL		0
#define	EOF		(-1)
#define	TRUE		1
#define	FALSE		0

#define YES		1
#define NO		0
#define FOREVER		for (;;)

#define abs(x)		((x) < 0 ? -(x) : (x))
#define max(x,y)	(((x) < (y)) ? (y) : (x))
#define min(x,y)	(((x) < (y)) ? (x) : (y))

#define unlink		delete

#define L_ctermid	64
#define L_cuserid	16
#define L_cimageid	40
#define L_tmpnam	256
#define L_lcltmpnam	256
#define L_nettmpnam	256

#define getc(p)		fgetc(p)
#define getchar()	fgetc(stdin)
#define putc(x,p)	fputc(x,p)
#define putchar(x)	fputc(x,stdout)
#define feof(p)		(((*p)->_flag&_IOEOF)!=0)
#define ferror(p)	(((*p)->_flag&_IOERR)!=0)
#define fileno(p)	((*p)->_file)
#define clearerr(p)	((*p)->_flag &= ~(_IOERR|_IOEOF))

char	*cimageid();
char	*ctermid();
char	*cuserid();

char	*fgets();
char	*fgetname();
char	*getname();

char	*strcpy();
char	*strcat();
char	*strchr();
char	*strlower();
char	*strpbrk();
char	*strrchr();
char	*strncpy();
char	*strncat();
char	*strupper();
char	*strxcpy();
char	*strxcat();
char	*strzcpy();
char	*strzcat();

long	ftell();

FILE	*fopen(), *fdopen(), *freopen();

# endif
