$ set noverify
$ command_list ="C/L/I/T/E/D/P/"
$ type_list ="H/O/T/"
$ ws := write sys$output
$ display_loop:
$   set on
$   ws "   !---------------------------------------------------------------!"
$   ws "   !            *** LIBRARY COMMAND ***                            !" 
$   ws "   !   ch ,ct ,co   : (C)reate library in hlb, tlb ,olb            !"
$   ws "   !   lh ,lt ,lo   : (L)ist all modules in a hlb, tlb, olb        !"
$   ws "   !   ih ,it ,io   : (I)nsert a module into a hlb, tlb, olb       !"
$   ws "   !   eh ,et ,eo   : (E)xtract a module from a hlb, tlb, olb      !"
$   ws "   !   th ,tt       : (T)ype or list  a  module on the screen      !"
$   ws "   !   dh ,dt ,do   : (D)elete a module from a library             !"
$   ws "   !   ph ,pt ,po   : COMPRESS the library                         !" 
$   ws "   !   st*oref      : Command to replace the text and object       !"
$   ws "   !   de*fine      : Define my_library to some library name       !"
$   ws "   !   my*_help     : Help from your current library file          !"
$   ws "   !   h*elp        : Help in userlib topic                        !"
$   ws "   !   $ command    : DCL command                                  !"
$   WS "   !   exit         : Exit                                         !"
$   ws "   !   ? , <return> : Re-display the command list                  !" 
$   ws "   !                                                               !"
$   ws "   !   NOTE:  1. h*elp means you can type   h, he, hel or help     !"
$   ws "   !          2. List can list only a module:  Lx/module name      !"
$   ws "   !          3. Create can create variable size: Cx/size          !"
$   ws "   !---------------------------------------------------------------!" 
$!
$! 
$   loop:
$     ws ""
$       on warning then goto message
$       read/end=exit/prompt= "LIBCOM> " sys$command command1
$       command1:='command1   ! Get the capital letter
$       if (command1 .eqs. "").or.(command1 .eqs. "?")then goto display_loop 
$       if f$extract (0,2,command1) .eqs. "EX" then exit
$!
$       my_define = f$logical("my_library")
$       if my_define .eqs. "" then my_define := my_library
$!------------------------------------------------------------------------!
$!                      EXTRACT FOR SPECIAL COMMAND                       !
$!------------------------------------------------------------------------!
$       if f$extract(0,2,command1) .eqs. "DE" then goto def
$       if f$extract(0,1,command1) .eqs. "$" then goto command
$       IF f$extract(0,2,command1) .eqs. "ST" then goto storef
$       if f$extract(0,2,command1) .eqs. "MY" then goto my_help
$       If f$extract(0,1,command1) .eqs. "H" then goto help
$!------------------------------------------------------------------------!
$!                      EXTRACT FOR TWO CHARACTER COMMAND                 !
$!------------------------------------------------------------------------!
$     str= f$extract(2,1,command1)
$     if (str .nes. " ").and.(str .nes. "/").and.(str .nes. "") then goto error
$     command = f$extract(0,1,command1)
$     type = f$extract(1,1,command1)
$     if f$locate(command+"/",command_list).eq.f$length(command_list)-
         then goto error
$     if f$locate(type+"/",type_list).eq.f$length(type_list) then goto error
$     if type .eqs. "" then goto error
$!------------------------------------------------------------------------!
$!                      INITALIZE THE TYPE                                !
$!------------------------------------------------------------------------!
$     write sys$output "   "
$     if type .eqs. "H" then type := help
$     if type .eqs. "O" then type := object
$     if type .eqs. "T" then type := text
$     if type .eqs. "HELP" then tp   := .hlb
$     if type .eqs. "OBJECT" then tp := .olb
$     if type .eqs. "TEXT" then tp   := .tlb
$     if command .eqs. "C" then goto 'command
$     my_define:='my_define''tp'
$     if f$search("''my_define'") .eqs. "" then goto notf
$     if command .eqs. "L" .or. command .eqs. "P" then goto 'command
$!--------------------------------------------------------------------!
$!                    PROMPT INPUT MODULE IF IT NEED                  !
$!--------------------------------------------------------------------!
$     if f$length(command1) .le. 3 then -
      read/end=exit/prompt= " module name > " sys$command module
$     if f$length(command1) .gt. 3 then -
      module = f$extract(3,f$length(command1)-3,command1)
$     if f$locate("/",module).ne.f$length(module) then goto error
$     if module .eqs. "" then goto fail
$     goto 'command'
$!
$  L:
$!---------------------------------------------------------------------!
$!                 List my_library.xxx                                 !
$!                -----------------------                              !
$!  The (L)x command can be list only one module by specified          !
$!  Lx/module_name                                                     !
$!---------------------------------------------------------------------!
$      extention := full
$      qual= f$locate("/",command1)
$      if qual .eq. f$length(command1) .and. qual .gt. 2 then goto error
$      if qual.ne.f$length(command1) then extention= "only="+-
       f$extract(qual+1,f$length(command1)-qual,command1)+"/full"
$      lib/'type/log/list/'extention    my_library      
$      goto loop
$!
$  I:             
$!---------------------------------------------------------------------!
$!                   Replace my_library.xxx                            !
$!---------------------------------------------------------------------!
$      lib/'type/log/replace    my_library  'module     
$      goto loop
$!
$  T:              
$!---------------------------------------------------------------------!
$!                  Type module in my_library.xxx                      !
$!                 -------------------------------                     !
$! The type can be indicate by :  Tx module name                       !
$!---------------------------------------------------------------------!
$      lib/'type/log/out=sys$output/extract='module     my_library
$      goto loop
$!
$  E:              
$!---------------------------------------------------------------------!
$!                  Extract module in my_library.xxx                   !
$!---------------------------------------------------------------------!       
$      read/end=exit/prompt= " ext (return for default) > "  sys$command extention
$      lib/'type/log/out='module''extention'/extract='module  my_library
$      goto loop
$!
$  C:              
$!---------------------------------------------------------------------!
$!                  Create my_library.xxx                              !
$!                 -----------------------                             !
$!  When create we need the size of the libray(# of block)             !
$!  we can specify  Cx/# of block                                      !
$!---------------------------------------------------------------------!
$      qual= f$locate("/",command1)
$      if qual .eq. f$length(command1) .and. qual .gt. 2 then goto error
$      if qual.ne.f$length(command1) then -
$      size = f$extract(qual+1,f$length(command1)-qual,command1)
$      if qual.eq.f$length(command1) then -
$      read/end=exit/prompt= " number of block > " sys$command size
$      if size .eqs. "" then size = 100
$      lib/create=(blocks:'size)/'type  my_library
$      goto loop
$!
$  D:              
$!---------------------------------------------------------------------!
$!                  Delete module in my_library                        !
$!---------------------------------------------------------------------!
$      lib/'type/delete=('module)/log my_library
$      goto loop
$!
$  P:
$!----------------------------------------------------------------------!
$!                   COMPRESS MY_LIBRARY                                !
$!----------------------------------------------------------------------!
$      lib/compress/'type  my_library
$      purge my_library'tp
$      goto loop
$  storef:         
$!---------------------------------------------------------------------!
$!              Replace modules in my_library.tlb and .olb             !
$!---------------------------------------------------------------------!
$      if f$search("''my_define'"+".tlb") .eqs. "" then goto notf
$      if f$search("''my_define'"+".olb") .eqs. "" then goto notf
$      command= f$extract(0,f$locate(" ",command1),command1)
$      space= f$locate(" ",command1)
$      if f$locate(command,"STOREF").eq.f$length("STOREF") then goto error
$      if f$locate(" ",command1).eq.f$length(command1) then -
       read/end=exit/prompt= " file name > " sys$command file
$      if f$locate(" ",command1).ne.f$length(command1) then -
       file = f$extract(space,f$length(command1)-space,command1)
$      if file .eqs. "" then goto fail
$      read/end=exit/prompt= " module name (if different) > " sys$command module
$      if module .nes. "" then module := "/module="'module
$      lib/replace/text/log my_library 'file.for'module
$      lib/replace/object/log my_library 'file.obj
$      goto loop 
$!
$  my_help:
$!---------------------------------------------------------------------!
$!                       HELP IN LIBRARY                               !
$!---------------------------------------------------------------------!
$     command= f$extract(0,f$locate(" ",command1),command1)
$     if f$locate(command,"MY_HELP") .eq. f$length("MY_HELP") then goto error
$     my_define :='my_define'.hlb
$     lib_name = f$search("''my_define'")
$     if lib_name .eqs. "" then goto notf
$     define/user_mode sys$input sys$command
$     if f$locate(" ",command1) .ne. f$length(command1) then goto sub
$     help/library = 'lib_name
$     goto loop
$    sub:
$     space= f$locate(" ",command1)
$     sub_topic = f$extract(space,f$length(command1)-space,command1)
$     help/library = 'lib_name''sub_topic'
$     goto loop 
$!
$  help:
$!--------------------------------------------------------------------!
$!                       VMS HELP IN USERLIB SUBTOPIC                 !
$!--------------------------------------------------------------------!
$     command= f$extract(0,f$locate(" ",command1),command1)
$     if f$locate(command,"HELP") .eq. f$length("HELP") then goto error
$     define/user_mode sys$input sys$command
$     help userlib
$     goto loop 
$      
$  command:
$!--------------------------------------------------------------------!
$!                         DCL COMMANDS                               !
$!--------------------------------------------------------------------!
$     execute = f$extract(1,f$length(command1)-1,command1)
$     'execute'
$      goto loop   
$!
$  def:
$!--------------------------------------------------------------------!
$!             DEFINE MY_LIBRARY TO SOME LIBBRARY NAME                !
$!--------------------------------------------------------------------!  
$     command= f$extract(0,f$locate(" ",command1),command1)
$     if f$locate(command,"DEFINE").eq.f$length("DEFINE") then goto error
$     length=f$length(command1)
$     space=f$locate(" ",command1)
$     if space.eq.length then goto short
$     if f$logical("my_library") .nes. "" then $deassign my_library
$     lib_name=f$extract(space,length-space,command1)
$     lib_name := 'lib_name   ! take out the leading blank
$     if f$locate(" ",lib_name).nes.f$length(lib_name) then goto error
$     lib_name=f$parse("''lib_name'",,,"directory","syntax_only")+ -
               f$parse("''lib_name'",,,"name"     ,"syntax_only")
$     define my_library 'lib_name
$     goto loop
$  short:
$     if f$logical("my_library") .nes. "" then $deassign my_library
$     read/end=exit/prompt= " define my_library to ? > " sys$command lib_name
$     if lib_name .eqs. "" then goto loop
$     lib_name=f$parse("''lib_name'",,,"directory","syntax_only")+ -
               f$parse("''lib_name'",,,"name"     ,"syntax_only")
$     define my_library 'lib_name
$     goto loop
$!
$  notf:
$!----------------------------------------------------------------------!
$!                   MESSAGE FOR FILE NAME NOT EXIST                    !
$!----------------------------------------------------------------------!
$      if my_define .eqs. "" then my_define := my_library
$      ws " The file "+"'' my_define'"+" not found, check logical my_library. "
$      goto loop
$!
$  error:
$!----------------------------------------------------------------------!
$!                MESSAGE FOR ENTERING INVALID COMMAND                  !
$!----------------------------------------------------------------------!
$      ws "you entered an invalid command: ",command1
$      goto display_loop
$!
$  fail:
$!----------------------------------------------------------------------!
$!                MESSAGE ERROR FOR FAILURE                             !
$!----------------------------------------------------------------------!
$      ws ""
$      ws " Fail to perform   --- "+"''command1'"+" ---"
$      goto loop
$  message:
$!----------------------------------------------------------------------!
$!                     STATUS MESSAGE                                   !
$!----------------------------------------------------------------------!   
$      if ($severity .eq. 2).or.($severity .eq. 4) then goto fail
$      ws  f$message($status)
$      goto loop
$!----------------------------------------------------------------------!
$!                       EXIT                                           !
$!----------------------------------------------------------------------!
$  exit: exit
$!
