	SUBROUTINE SUBSTG(STRING,DELIM1,DELIM2,WORD)
C
C	RETURN FIRST "DELIM1"/"DELIM2" DELIMITED SUBSTRING OF
C	THE INPUT "STRING"; RETURN IN "WORD"
C	AND IF STRING IS BLANK, RETURN "WORD"= ' '
C	EXCEPTION: IF "DELIM1"= ' ', USE START-OF-STRING INSTEAD
C	OF THE "DELIM1".  THIS IS REQUIRED BECAUSE OF THE LEADING-BLANK
C	SUPPRESSION.
C	ON RETURN, STRING IS STRIPPED OF THE RETURNED WORD AND THE
C	DELIMITERS; REMAINING CHARACTERS SHIFTED TO CLOSE THE GAP.
C	LEADING BLANKS IN "STRING" ARE ALSO REMOVED ON RETURN
C	AND 'TAB' CHARACTERS CHANGED TO ' ' CHARACTERS.
C
C	DELIM1 AND DELIM2 MAY BE NOT IN THE STRING; IF NOT,
C	OTHER DELIMITERS ARE USED:
C		THE STARTING DELIMITER MAY BE:
C			DELIM1, OR START-OF-STRING
C		(TO FORCE START-OF-STRING, USE "DELIM1"=' ')
C		AND THE ENDING DELIMITER MAY BE ANY OF:
C			DELIM2, ',', '.', OR END-OF-STRING,
C		IN THAT ORDER OF PREFERENCE.
C	FOR INSTANCE, ONE COULD USE EITHER:
C			STRING= 'DATE=6-12-84, KEY=7,LIST=FOURTH'
C	OR:		STRING= '6-12-84 ,7,FOURTH'
C		AND RETRIEVE THE DATE WITH
C			CALL SUBSTG(STRING,'DATE=', ',',DATE)
C		THEN UNPACK THE KEY NUMBER WITH
C			CALL SUBSTG(STRING,'KEY=',',',LIST)
C
C		THE INTENTION IS TO ALLOW KEYWORDS TO BE RECOGNIZED,
C	IN A STRING-INTERPRETING MANNER.
C		ON RETURN, THE STRING CONTAINS THE ORIGINAL STRING WITH
C	THE SUBSTRING AND ITS DELIMITERS REMOVED.  THIS IS INTENDED TO
C	FACILITATE MULTIPLE CALLS TO SUBSTG WHICH WILL RETURN THE
C	SUCCESSIVE WORDS IN A SENTENCE. (PARAMETERS IN A LIST, ETC.)
C
C		JOHN WHITMORE, 1984
	PARAMETER (NTERM=2)
	CHARACTER*(*) STRING,WORD,DELIM1,DELIM2
	CHARACTER*(1) TERMIN(NTERM), BLANK, TAB
	DATA TERMIN / ',', '.' /
	DATA BLANK,TAB / ' ', 9/
C
	ND1=LEN(DELIM1)
	ND2=LEN(DELIM2)
C
C		CHANGE ANY TABS TO BLANKS
 1	M=INDEX(STRING,TAB)
	IF(M .NE. 0) THEN
		STRING(M:M) = BLANK
		GO TO 1
	ENDIF
C
C		IGNORE BLANK, SEARCH OTHERWISE FOR FIRST DELIMITER
	LS=NBLEN(STRING)
	IF(STRING .EQ. BLANK) THEN
		J2=0
		J1=1
		K1=LS+1
		K2=LS
		GO TO 999
	ELSE
C		DELETE ANY LEADING BLANKS
		DO 2 N=1,LS
 2			IF(STRING(N:N) .NE. ' ') GO TO 3
 3		IF(N .GT. 1) STRING=STRING(N:)
	ENDIF
	J= INDEX(STRING,DELIM1)
	IF( DELIM1 .EQ. BLANK .OR. J .EQ. 0) THEN
C
C			DEFAULT TO BEGINNING OF LINE
		J1= 1
		J2= 0
	ELSE IF(J .NE. 0) THEN
C
C			HAVE FOUND DELIM1, MARK BOTH ENDS
		J1=J+ND1
		J2= J-1
	ENDIF
C
C		FIND THE FOLLOWING DELIMITER
C		(EXCEPTION IF FOLLOWING IS ' ', SKIP LEADING ' ')
	J1S= J1
	IF(DELIM2 .EQ. BLANK) THEN
		DO 4 N=J1, LS
			IF(STRING(N:N) .EQ. BLANK) THEN
				J1S=J1S + 1
			ELSE
				GO TO 5
			ENDIF
 4			CONTINUE
 5		CONTINUE
	ENDIF
	J1M= J1S-1
	K=INDEX(STRING(J1S:),DELIM2) + J1M
	IF(STRING(J1:) .EQ. BLANK) THEN
		K1=LS+1
		K2=LS
	ELSE IF(K .NE. J1M) THEN
C
C			HAVE FOUND DELIM2, MARK BOTH ENDS
		K1=K+ND2
		K2= K-1
	ELSE 
C
C			SEARCH FOR ALTERNATE DELIMITERS
C		 DO WHILE (TERMINATOR NOT FOUND)
		KK=0
 7		KK=KK+1
		K= INDEX( STRING(J1:),TERMIN(KK)) + J1M
		IF(K .EQ. J1M .AND. KK .LT. NTERM) GO TO 7
C
C			IF NO TERMINATOR, DEFAULT TO END OF LINE
		IF(K .EQ. J1M) THEN
			K =LS+1
			K1=LS+1
			K2=LS
		ELSE
			K1= K+1
			K2= K-1
		ENDIF
	ENDIF
C
C		FILL WORD FROM STRING
999	WORD= BLANK
	IF(J1S .LE. K2)	WORD=STRING(J1S:K2)
C
C		AND SHORTEN STRING BY THE WORD AND ITS DELIMITERS
	IF(J2 .GE. 1 .AND. K1 .LE. LS) THEN
		STRING= STRING(1:J2)//STRING(K1:LS)
	ELSE IF(J2 .GE. 1 .AND. K1 .GT. LS) THEN
		STRING= STRING(1:J2)
	ELSE IF(J2 .LT. 1 .AND. K1 .LE. LS) THEN
		STRING= STRING(K1:LS)
	ELSE
		STRING=BLANK
	ENDIF
C
C		DELETE ANY LEADING BLANKS
	DO 12 N=1,LS
 12	IF(STRING(N:N) .NE. ' ') GO TO 13
 13	IF(N .GT. 1) STRING=STRING(N:)
C
	RETURN
	END

