C******************************************************************************
      program find_mail_directory
!
!     Gets the name of the mail directory for a user specified on the command
!     line.  The mail directory is returned as a DCL symbol called MAIL_DIR.
!
! functions
      integer         lib$get_foreign
! locals
      character       username*31               ! username on vax
      integer         i 			! dummy variable used for
						! status checking and loops
      integer         mail_dir_len		! length of mail directory 
						! string
      integer         mail_for_len              ! length of mail forwarding
						! string
      integer         pers_name_len             ! length of personal name
      integer         start_record              ! beginning of mail directory
						! string
      character       record*200                ! VMSmail record for the user
      character       mail_directory*20         ! string to hold mail directory

!------------------------------------------------------------------------------
      open( unit=95, file='sys$system:vmsmail.dat', iostat=i,
     $      status='old', organization='indexed', form='formatted',
     $      access='keyed', shared, readonly,recl=200 )
      if ( i.ne.0 ) then
        print *,'error opening file, iostat = ',i
        call exit
      endif

      i = lib$get_foreign( username,,, )
      if ( .not. i ) then
        print *,'error trying to get username'
        call exit(i)
      endif

      read(95,'(q,a)',key=username,iostat=i) len,record(1:len)
      if ( i.ne.0 ) then
        print *,'error reading VMSmail.dat record, iostat = ',i
        call exit(0)
      endif

c
c The hex offsets for VMSmail.dat for the following variables are:
c     Length of mail directory string   42H
c     Length of personal name string    43H
c     Length of mail forwarding string  44H
c     Beginning of strings              45H
c
      mail_dir_len = ichar(record('42'x:'42'x))
      pers_name_len = ichar(record('43'x:'43'x))
      mail_for_len = ichar(record('44'x:'44'x))

      start_record = '45'x + pers_name_len + mail_for_len
d     do i=1,len
d       print '(1x,a,10x,z2.2,2x,i,2x,z2.2)',record(i:i),record(i:i),i,i
d     enddo
d     print '(1x,i,2x,i)',start_record,mail_dir_len
      mail_directory = record(start_record:mail_dir_len+start_record)
c
c     Now put the name of the mail directory into the symbol MAIL_DIR
c
      i = lib$set_symbol('mail_dir', mail_directory(1:mail_dir_len), 1)
      if(.not.i) call exit(i)

d     print *,mail_dir
      close( 95 )
      call exit
      end
