$ !--------------------------------------------------------------------------
$ !   ADDUSER.COM                                                           |
$ !   ADD A NEW USER TO THE SYSTEM AUTHORIZATION FILE, his directory, quota,|
$ !             sysbull.dat                                                 |
$ !             and add to indexed accounting file                          |
$ !                                                                         |
$ !--------------------------------------------------------------------------
$ UserDisk = "SYS$USER0"                       ! DEFAULT DISK FOR NEW USERS
$ UAF = "$AUTHORIZE"
$ FIND := SEARCH SYS$SYSTEM:SYSUAF.LIS
$ put := WRITE SYS$OUTPUT
$ MessageOFF := SET MESSAGE/NOFACILITY/NOIDENTIFICATION/NOSEVERITY/NOTEXT
$ MessageON := SET MESSAGE/FACILITY/IDENTIFICATION/SEVERITY/TEXT
$ Vaxes = "PHAST,UWAPA1,UWAPA2,JANUS"
$ Mode_Ans = "IB"
$ Class_Set = "DEPARTMENT,UNIVERSITY,PERSONAL,OUTSIDER,SYSTEM,UNKNOWN"
$ Adduser_Prog := [accountng.new.eklund]adduser.exe    ! add to indexed file
$ Quota_Batch = 1000
$ Quota_Inter_L = 40000
$ Quota_Inter_S = 5000
$ Overdraft_L = 1000
$ Overdraft_S = 100
$ !
$ error_explain = "%ADDUSER-F-IDUNNO I dunno what happend ! ?"
$ ON CONTROLY THEN GOTO ERROREXIT
$ ON ERROR THEN GOTO ERROREXIT
$ OLDDIR = F$LOGICAL("SYS$DISK") + 'F$DIRECTORY()'
$ PREVPRIV = F$SETPRV("SYSPRV")
$ IF .NOT.F$PRIVILEGE("SYSPRV") THEN GOTO NOPRIV
$ SET DEFAULT SYS$SYSTEM
$ !
$ ! Get new user names
$ !
$ PUT " "
$ PUT "****************************************************************"
$ PUT "*     ADDUSER defines new users for the VAX system             *"
$ PUT "*     Press CTRL Y to exit at any time during entry phase      *"
$ PUT "****************************************************************"
$ PUT ""
$ Change = "False"
$GET_USERNAMES:
$! MessageOFF
$ INQUIRE User "Username(s) - separate by commas"
$ IF User .NES. "" THEN GOTO EXT_NAME
$ PUT "Username is required"
$ GOTO GET_USERNAMES
$ !
$ ! Extract one user name from list
$ !
$EXT_NAME:
$ UserName = F$EXTRACT(0,F$LOCATE(",",User),User)
$ User = User - UserName - ","
$ IF F$LENGTH(UserName) .LE. 12 THEN GOTO GET_NODE
$ PUT "Username cannot exceed 12 characters - Please try again."
$ GOTO GET_USERNAMES
$ !
$ ! Process extracted name, get full name and password
$ !
$ !
$GET_NODE:
$ INQUIRE Node "Which Vax (''Vaxes')"
$ IF Node .EQS. "" THEN GOTO CLEANUP
$ IF "''F$LOCATE(Node,Vaxes)'".EQ."''F$LENGTH(Vaxes)'" THEN GOTO GET_NODE
$!
$ NetNode = "''Node'::"
$ TempNode = ""
$ IF Node .NES. "PHAST" THEN TempNode = "''Node'::"
$ DEFINE Net_node "''Node'::"
$CHECK_NAMES:
$ ! Now make sure this UserName does not already exist
$ SET NOON
$ IF Node .NES. "PHAST" THEN GOTO CHCK_MICRO
$ SET DEFAULT SYS$SYSTEM
$ UAF SHOW/BRIEF 'UserName'
$ GOTO CHCK$STATUS
$ !
$CHCK_MICRO:
$ OPEN/WRITE FILE SYS$LOGIN:CHCKNAME.ADD
$ WRITE FILE "$ SET NOON
$ WRITE FILE "$ UAF := $AUTHORIZE
$ WRITE FILE "$ SET DEFAULT SYS$SYSTEM
$ WRITE FILE "$ UAF SHOW/BRIEF ''UserName'
$ WRITE FILE "$ SHOW SYMBOL $STATUS
$ CLOSE FILE
$ COPY SYS$LOGIN:CHCKNAME.ADD 'NetNode'
$ DEFINE SYS$OUTPUT SYS$LOGIN:OUT.ADD
$ ATNODE 'NetNode' ONELINE @CHCKNAME.ADD
$ DEASSIGN SYS$OUTPUT
$ OPEN IN SYS$LOGIN:OUT.ADD
$ !
$GET$STATUS:
$ READ IN RECO
$ IF F$LOCATE("$STATUS",RECO) .EQ. F$LENGTH(RECO) THEN GOTO GET$STATUS
$ CLOSE IN
$ $STATUS = F$EXTRACT(F$LOCATE("%X",RECO),10,RECO)
$ !
$CHCK$STATUS:
$ IF ((.NOT. $STATUS) .AND. (.NOT. Change)) THEN GOTO GET_FULL_NAME
$ IF ((.NOT. $STATUS) .AND. Change) THEN GOTO GET_DEV
$ PUT "''UserName' account already exists - Please choose different name."
$ GOTO GET_USERNAMES
$ !
$GET_FULL_NAME:
$ INQUIRE Full_Name "Full name for ''UserName'"
$ IF ((F$LENGTH(Full_Name) .LE. 32).AND.(.NOT. Change)) THEN -
  GOTO GET_PASSWORD
$ IF ((F$LENGTH(Full_Name) .LE. 32).AND. Change) THEN GOTO DISPLAY_INFO
$ PUT "Full name cannot exceed 32 characters - Please enter again."
$ GOTO GET_FULL_NAME
$ !
$GET_PASSWORD:
$ SET TERMINAL/NOECHO
$ INQUIRE PASSWORD "Password [''UserName']"
$ IF PASSWORD .NES. "" THEN GOTO VERIFY
$ SET TERMINAL/ECHO
$ PASSWORD = UserName
$ GOTO GET_UIC
$ !
$VERIFY:
$ SET TERMINAL/NOECHO
$ INQUIRE TEMP "Verification"
$ SET TERMINAL/ECHO
$ IF TEMP .EQS. PASSWORD THEN GOTO GET_UIC
$ PUT "Password verification failed - Please re-enter password."
$ GOTO GET_PASSWORD
$ !
$GET_UIC:
$ INQUIRE UIC "UIC Group Number or full UIC"
$ IF UIC .EQS. "" THEN GOTO GET_GRP
$ IF F$LOCATE(",",UIC) .EQ. F$LENGTH(UIC) THEN GOTO GET_GRP
$ IF F$LOCATE("[",UIC) .EQ. F$LENGTH(UIC) .AND. -
     F$LOCATE("]",UIC) .EQ. F$LENGTH(UIC) THEN UIC = "[" + UIC + "]"
$ IF CHANGE THEN GOTO DISPLAY_INFO
$ GOTO GET_ACCOUNT
$ !
$GET_GRP:
$ IF UIC .EQS. "" THEN UIC = "*"
$ PUT "Determine the UIC from the following listing:"
$ ON ERROR THEN CONTINUE
$ UAF SHOW ['UIC',*]/BRIEF
$ error_explain = "%ADDUSER-F-BADUIC after username verification"
$ ON WARNING THEN GOTO ERROREXIT
$ !
$FULLUIC:
$ INQUIRE UIC "Full UIC "
$ IF UIC .EQS. "" THEN GOTO GET_UIC
$ IF F$LOCATE(",",UIC) .EQ. F$LENGTH(UIC) THEN GOTO FULLUIC
$ IF F$LOCATE("[",UIC) .EQ. F$LENGTH(UIC) .AND. -
      F$LOCATE("]",UIC) .EQ. F$LENGTH(UIC) THEN UIC = "[" + UIC + "]"
$ IF Change THEN GOTO DISPLAY_INFO
$ !
$GET_ACCOUNT:
$ INQUIRE Account "Account Name [UNKNOWN]"
$ IF Account .EQS. "" THEN Account = "UNKNOWN"
$ !
$GET_CLASS:
$ Class = "PERSONAL"
$ IF "''F$LOCATE("-",Account)'".EQ."''F$LENGTH(Account)'" THEN GOTO NODASH
$ Class = "DEPARTMENT"
$ !
$NODASH:
$ INQUIRE TMP "Class (''Class_Set')[''Class']"
$ !
$ IF TMP .NES. ""  THEN CLASS = TMP
$ IF "''F$LOCATE(TMP,Class_Set)'" .EQ. "''F$LENGTH(Class_Set)'" THEN -
  GOTO GET_CLASS
$ IF Change THEN GOTO DISPLAY_INFO
$ !
$GET_PRIV:
$ INQUIRE Privs "Privileges [NONE]"
$ IF Privs THEN Privs = "/PRIV=(" + PRIVS + ")"
$ UserDir = F$EXTRACT(0,9,UserName)
$ IF Change THEN GOTO DISPLAY_INFO
$ !
$GET_LOGIN:
$ !
$ UserDir = UserName
$ INQUIRE TMP "Login Directory [''UserDir']"
$ IF TMP .NES. "" THEN UserDir = TMP
$ UserDir = UserDir - "[" - "]"
$ IF Change THEN GOTO DISPLAY_INFO
$ !
$GET_ACCESS_MODE:
$ Default_Mode = "I"
$ IF Node .NES. "PHAST" THEN Default_Mode = "B"
$ INQUIRE TMP "Interactive or Batch? [''Default_Mode']"
$ IF TMP .EQS. "" THEN Mode = Default_Mode
$ IF TMP .NES. "" THEN Mode = TMP
$ IF F$EXTRACT(0,1,Mode) .EQS. "I" THEN Mode = "INTERACTIVE"
$ IF F$EXTRACT(0,1,Mode) .EQS. "B" THEN Mode = "BATCH"
$ IF "''F$LOCATE(TMP,Mode_Ans)'" .EQ. "''F$LENGTH(Mode_Ans)'" THEN -
  GOTO GET_ACCESS_MODE
$ IF Change THEN GOTO GET_QUOTAS
$ !
$GET_DEV:
$ IF Node .EQS. "PHAST" THEN UserDisk = "SYS$USER0"
$ IF Node .NES. "PHAST" THEN UserDisk = "DUA0"
$ INQUIRE TMP "Login Device [''UserDisk']"
$ IF TMP .NES. "" THEN UserDisk = TMP
$ UserDisk = UserDisk - ":" + ":"
$ !
$GET_QUOTAS:
$ !
$ NQ0Val = "FALSE"
$ IF F$SEARCH("''TempNode'''UserDisk'[0,0]QUOTA.SYS") .EQS. "" THEN GOTO NQ
$ IF Mode .EQS. "BATCH" THEN GOTO GET_QUOBATCH
$ IF Mode .EQS. "INTERACTIVE" THEN GOTO GET_QUOINTER
$ !
$GET_QUOBATCH:
$ INQUIRE Quota "Disk Quota [''Quota_Batch']"
$ IF Quota .EQS. "" THEN Quota = Quota_Batch
$ INQUIRE Overdraft "Overdraft Quota [''Overdraft_S']"
$ IF Overdraft .EQS. "" THEN Overdraft = Overdraft_S
$ GOTO DISPLAY_INFO
$ !
$GET_QUOINTER:
$ IF Node .EQS. "PHAST" THEN -
  Quota_Inter = Quota_Inter_L
$ IF Node .EQS. "UWAPA2" THEN -
  Quota_Inter = Quota_Inter_L
$ IF Node .EQS. "PHAST" THEN -
  Overdraft_Inter = Overdraft_L
$ IF Node .EQS. "UWAPA2" THEN -
  Overdraft_Inter = Overdraft_L
$ IF Node .EQS. "JANUS" THEN -
  Quota_Inter = Quota_Inter_S
$ IF Node .EQS. "UWAPA1" THEN -
  Quota_Inter = Quota_Inter_S
$ IF Node .EQS. "JANUS" THEN -
  Overdraft_Inter = Overdraft_S
$ IF Node .EQS. "UWAPA1" THEN -
  Overdraft_Inter = Overdraft_S
$ INQUIRE Quota "Disk Quota [''Quota_Inter']"
$ IF Quota .EQS. "" THEN Quota = Quota_Inter
$ INQUIRE Overdraft "Overdraft Quota [''Overdraft_Inter']"
$ IF Overdraft .EQS. "" THEN Overdraft = Overdraft_Inter
$ GOTO DISPLAY_INFO
$ !
$NQ:
$ NQ0Val = "TRUE"
$ GOTO DISPLAY_INFO
$ !
$ ! Check account's information before process account
$ !
$DISPLAY_INFO:
$ PUT ""
$ PUT " 1  User Name     ''UserName'"
$ PUT " 2  Full Name     ''Full_Name'"
$ PUT " 3  Full UIC      ''UIC'"
$ PUT " 4  Privileges    ''Privs'"
$ PUT " 5  Account       ''Account'"
$ PUT " 6  Class         ''Class'"
$ PUT " 7  Vax           ''Node'"
$ PUT " 8  Login DIR     ''UserDir'"
$ PUT " 9  Login DEV     ''UserDisk'"
$ PUT "10  Disk Quota    ''Quota'          Overdraft    ''Overdraft'"
$ PUT "11  Access Mode   ''Mode'"
$ PUT " "
$ INQUIRE No "Enter number for change (1-10) or hit RETURN if everything OK"
$ IF No .EQS. "" THEN GOTO PROCESS_ACC
$ IF No .LT. 1 THEN GOTO ERRORNO
$ IF No .GT. 11 THEN GOTO ERRORNO
$ Change = "True"
$ GOTO Change'No'
$ !
$CHANGE1:
$ INQUIRE UserName "User Name"
$ GOTO DISPLAY_INFO
$ !
$CHANGE2:
$ GOTO Get_Full_Name
$ !
$CHANGE3:
$ GOTO Get_UIC
$ !
$CHANGE4:
$ GOTO Get_Priv
$ !
$CHANGE5:
$ GOTO Get_Account
$ !
$CHANGE6:
$ GOTO Get_Class
$ !
$CHANGE7:
$ GOTO Get_Node
$ !
$CHANGE8:
$ GOTO Get_Login
$ !
$CHANGE9:
$ GOTO Get_DEV
$ !
$CHANGE10:
$ IF MODE .EQS. "BATCH" THEN GOTO GET_QUOBATCH
$ IF MODE .EQS. "INTERACTIVE" THEN GOTO GET_QUOINTER
$CHANGE11:
$ GOTO Get_Access_Mode
$ !
$PROCESS_ACC:
$ DELETE/SYMBOL $STATUS		!  why ?????
$ MessageON
$ Change = "False"
$ IF NQ0VAL THEN GOTO NQ0
$ OPEN/WRITE FILE SYS$LOGIN:ADDQUOTA.ADD
$ WRITE FILE "$ RUN SYS$SYSTEM:DISKQUOTA"
$ WRITE FILE "    USE ''UserDisk'"
$ WRITE FILE "    ADD ",UIC,"/PERMQUOTA=",Quota,"/OVERDRAFT=",Overdraft
$ WRITE FILE "    EXIT
$ CLOSE FILE
$ !
$ !Run DISKQUOTA at Micro VAXen accross the network
$ !
$ Submit_CMD = "NETSUBMIT"
$ IF Node .eqs. "PHAST" THEN Submit_CMD = "@"
$ 'Submit_CMD' SYS$LOGIN:ADDQUOTA.ADD
$ IF .NOT. $STATUS THEN error_explain = "%ADDUSER-F-BADQUOTA Disk quota failed"
$ IF .NOT. $STATUS THEN GOTO ERROREXIT
$ DELETE SYS$LOGIN:ADDQUOTA.ADD;*/NOLOG
$ !
$NQ0:
$ Submit_CMD = "NETSUBMIT"
$ IF Node .EQS. "PHAST" THEN Submit_CMD = "@"
$CREATE_DIR:
$ OPEN/WRITE FILE SYS$LOGIN:CRDIR.ADD
$ WRITE FILE "CREATE/DIRECTORY/OWNER_UIC=''UIC'/ -"
$ WRITE FILE "PROTECTION=(S=RWE,O=RWE,G=RWE,W=RE) -"
$ WRITE FILE "''UserDisk'[''UserDir']/LOG"
$ CLOSE FILE
$ 'Submit_CMD' SYS$LOGIN:CRDIR.ADD
$ error_explain = "%ADDUSER-F-BADDIR Bad directory creation"
$ IF .NOT. $STATUS THEN GOTO ERROREXIT
$ DELETE SYS$LOGIN:CRDIR.ADD;*/NOLOG
$ IF F$SEARCH("SYS$MANAGER:LGISAMPL.COM") .EQS. "" THEN GOTO ADDACC
$! NOTE  not copy to MicroVAXen !!!  ???
$ COPY SYS$MANAGER:LGISAMPL.COM  'UserDisk'['UserDir']LOGIN.COM
$ !
$ADDACC:
$ !
$ IF F$SEARCH("''TempNode'SYS$MANAGER:SYSBULL.DAT") .EQS. "" THEN GOTO ADDUAF
$! COPY 'TempNode'SYS$MANAGER:SYSBULL.DAT 'TempNode''UserDisk'['UserDir']
$! SET FILE/OWNER_UIC='UIC'  'TempNode''UserDisk'['UserDir']SYSBULL.DAT 
$ !
$ADDUAF:
$ Mode_Qual := ""
$ IF Mode .eqs. "BATCH" THEN Mode_Qual := "/NOINTERACTIVE"
$ OPEN/WRITE FILE SYS$LOGIN:ADDUAF.ADD
$ WRITE FILE "$SET DEFAULT SYS$SYSTEM
$ WRITE FILE "$RUN AUTHORIZE"
$ WRITE FILE "ADD ",UserName,"/OWNER=""",FULL_NAME,"""/ACCOUNT=",ACCOUNT,-
      "/DEVICE=''UserDisk'/DIRECTORY=[''UserDir']/UIC=",UIC,-
      "/PASSWORD=",PASSWORD,"''Mode_Qual'"
$ CLOSE FILE
$ !
$ 'Submit_CMD' SYS$LOGIN:ADDUAF.ADD
$ error_explain = "%ADDUSER-F-BADUAF Bad authorize"
$ IF .NOT. $STATUS THEN GOTO ERROREXIT
$ DELETE SYS$LOGIN:ADDUAF.ADD;*/NOLOG
$ !
$ADD_ACCTNG:
$ !
$ ! Add empty record to indexed accounting file
$ !
$ Date := "''F$TIME()'"
$ Month := "''F$EXTRACT(3,3,Date)'"
$ Year  := "''F$EXTRACT(7,4,Date)'"
$ !
$ File_Name = "''Year'" + "''Month'"
$ FILE := "SYS$ULIB:[ACCOUNTNG.NEW.EKLUND]''File_Name'"
$ Disk = "DRC1:"
$ IF Node .NES. "PHAST" THEN Disk = "DUA0:"
$ OPEN/WRITE FILE SYS$LOGIN:RADDUSER.ADD
$ WRITE FILE "ADDUSER := $''Disk'''Adduser_Prog'"
$ WRITE FILE "ADDUSER ''UserName' ''UIC' ''ACCOUNT' ''CLASS' ''FILE'"
$ CLOSE FILE
$ 'Submit_CMD' SYS$LOGIN:RADDUSER.ADD
$ IF $STATUS THEN PUT " User ''UserName' added successfully."
$ DELETE SYS$LOGIN:RADDUSER.ADD;*/NOLOG
$ GOTO GET_NODE
$!
$ERRORNO:
$ PUT "****  Illegal number - Please try again  ****"
$ GOTO DISPLAY_INFO
$!
$ERROREXIT:
$ PUT error_explain
$ PUT "%ADDUSER-F-NOTADDED  ERROR  user ''UserName' NOT ADDED."
$ PUT "    Please tell MANAGER all error messages above."
$ PREVPRIV = F$SETPRV(PREVPRIV)
$ SET DEFAULT 'OLDDIR'
$ EXIT
$!
$CLEANUP:
$ IF User .NES. "" THEN GOTO EXT_NAME
$! should only do this via ATNODE if not local node ????
$ ATNODE 'NetNode' ONELINE DELETE *.ADD;*/NOLOG
$ SET TERMINAL/ECHO
$ PREVPRIV = F$SETPRV(PREVPRIV)
$ SET DEFAULT 'OLDDIR'
$ EXIT
$!
$NOPRIV:
$ PUT "You need SETPRV or SYSPRV privilege to run this procedure"
$ GOTO CLEANUP
