	integer function getdirectuser(username, terminal, circuit, location)
	IMPLICIT none
	character*(*) username,terminal,circuit,location
c  return terminal info for direct connected terminals using wildcard pid
c  assume VAXPORT file open on channel 14 already

	INCLUDE '($JPIDEF)'
	INCLUDE '($SSDEF)'

	character*7 TERM
	integer cloc, rtloc, vtloc, status, istat, pid

	INTEGER USERNAME_ADRS, USERNAME_LEN_ADRS, TERMINAL_ADRS
	INTEGER USERNAME_LEN, LISTEND, TERMINAL_LEN_ADRS, SYS$GETJPIW
	INTEGER TERMINAL_LEN
	INTEGER*2 JPILIST(14), IOSB(4)
	EQUIVALENCE (JPILIST(3), USERNAME_ADRS),
	1 (JPILIST(5), USERNAME_LEN_ADRS),
	2 (JPILIST(9), TERMINAL_ADRS),
	3 (JPILIST(11), TERMINAL_LEN_ADRS),
	4 (JPILIST(13), LISTEND)

	data pid /-1/	! forces into static memory to save across calls

	getdirectuser=1	! set success status return for default
C INITIALIZE ITEM SPECIFIERS AND BUFFER LENGTHS
	JPILIST(1)= 12
	JPILIST(2)= JPI$_USERNAME
	JPILIST(7)= 7
	JPILIST(8)= JPI$_TERMINAL
C
C INITIALIZE ADDRESS POINTERS
	USERNAME_ADRS= %LOC(USERNAME)
	USERNAME_LEN_ADRS= %LOC(USERNAME_LEN)
	TERMINAL_ADRS= %LOC(TERM)
	TERMINAL_LEN_ADRS= %LOC(TERMINAL_LEN)
	LISTEND= 0

C CALL GETJPI  (first time, pid=-1)
100	STATUS=SYS$GETJPIW(, pid,, JPILIST, IOSB,,)
	if(status) status = iosb(1)
D	print *, USERNAME, TERM

C IF THE TERMINAL LENGTH IS ZERO IT'S NOT AN INTERACTIVE PROCESS
	IF(STATUS) THEN
d		print *, 'terminal_len=',terminal_len
d		print *, term
		IF(TERMINAL_LEN .EQ. 0) GOTO 100 ! not interactive, try again

	ELSE  ! bad status or bad iosb(1)
d	   print *,'getjpi warning or error'

C IF WE DON'T HAVE PRIVILEGE, OR THE PROCESS IS NON-EXISTENT OR SUSPENDED
C JUST IGNORE AND TRY AGAIN
	   IF (STATUS .EQ. SS$_NOPRIV .OR.
	1      STATUS .EQ. SS$_NONEXPR	.OR.
	2      STATUS .EQ. SS$_SUSPENDED) GOTO 100

C IF THERE ARE NO MORE PROCESSES THEN JUMP
	   IF (STATUS .EQ. SS$_NOMOREPROC) then
		getdirectuser = 0 ! return 'nomoreprocess' status
		return
	   ENDIF

C IF WE GET TO HERE SOMETHING IS WRONG
	   print *,'getjpi bad'
	   CALL EXIT(STATUS)
	ENDIF


d	print *,' out of if'
D	WRITE(6,*) USERNAME, TERM
d	print '(1x,z8.8)', pid  ! actually next pid ? or low word of pid
				! with upper word -1 indicating wild


	CLOC= INDEX(TERM(1:TERMINAL_LEN), ':') - 2
	if( CLOC .LE. 0 ) GOTO 100	! not interactive, try again
d       print *,'*',term,'*'
	RTLOC = INDEX( TERM(1:TERMINAL_LEN), 'RT' )
	VTLOC = INDEX( TERM(1:TERMINAL_LEN), 'VT' )
	IF( RTLOC.NE.0 ) THEN
	    CIRCUIT= 'Decnet'
	    LOCATION=' Network Link'
	    TERMINAL = TERM(RTLOC:CLOC+1)
	ELSEIF( VTLOC.NE.0 ) THEN	! should probably find physical term
	    CIRCUIT= 'Virtual'
	    LOCATION=' Virtual Terminal'
	    TERMINAL = TERM(VTLOC:CLOC+1)
	else
c  ignore Micom
	    IF(  (TERM(CLOC-2:CLOC) .EQ. 'TTC') .OR.
	1       ((TERM(CLOC-2:CLOC) .GE. 'TTG') .AND.
	1	 (TERM(CLOC-2:CLOC) .LE. 'TTK')) ) goto 100

	    READ(14,KEYID=0,KEY=TERM(CLOC-2:CLOC+1),iostat=istat,err=495)
	1		TERMINAL, CIRCUIT, LOCATION


        ENDIF
C
d	print *,' getdirectuser returning to caller'
	return
C
495     WRITE(6,*)'ERROR READING VAXPORT.DAT, iostat=',istat
	write (6,*) terminal(cloc-2:cloc+1), TERM, circuit, location
	call exit(0)
C
1020	FORMAT(6X, Z2, 8X, Z2)

	END
