$ set verify=(proc,image)
$ run micom$dir:micom

! NOTE:  MICOM boards may take a minute after plugging in before INS CH works

OUT CH 0/1:2
SET CH 0/1:2 PG=1             ! Setting ch 0/01 &0/02
INS CH 0/1:2      
INS IC 1/1:8                  ! Put Internal ch in service
OUT CH 1/25:120               !
OUT CH 2/1:120                ! Put all ch out-of-service
OUT CH 3/1:120                !

! how set system back to defaults in software without battery power off ?

! 64 Access groups   (passwords to 8 char)
!    1
!    2
!    3 generic access to everything but ADP
!    4 dial-in access to everything but ADP and dial-out long dist, maybe ACC
!    11-25 ADP people
! 64 Protocol groups
!    17 chem switch port access group
!    18 PHAST port intended for chem switch
!128 Resource groups (passwords to 8 char)
!    11-25 ADP ports
!    128   PHAST
!    127   UWAPA1
!    126   JANUS
!    125   UWAPA2
!    124   dial-in-out modems
!    123   altypeahead on PHAST
!    122   SLAC Mux
!    121   ACS Micom
!    120   in-out on PHAST
!    119   in-out on JANUS
!    118   in-out on UWAPA2
!    100   reserved for TEST
! abbreviations:
!     78   P for PHAST
!     77   1 for UWAPA1
!     76   J for JANUS
!     75   2 for UWAPA2
!     74   M for MODEM
!
!255 Destination groups
!    11-25 ADP ports
!    128   PHAST
!    127   UWAPA1
!    126   JANUS
!    125   UWAPA2
!    124   dial-in-out modems
!    123   altypeahead on PHAST
!    122   SLAC Mux
!    121   ACS Micom
!    120   in-out PHAST
!    119   in-out JANUS
!    118   in-out UWAPA2
!    100   TEST
!128 Messages
!   1-22 default
!     80   DEST
!     81   BYE
!     82   GO
! 16 ABR speed lists
! 15 FWD groups of messages to forward to called channel upon connection
!          (can't send CR to ADP ports or they get confused)
!      1   carriage-return for all baud-rates
!      2   nothing at any baud-rate
!

! should set various timeouts etc.

! Messages

! DEST message     (HELP preceeded by NUL to avoid being interp by MICOM
!		    program as its HELP command)
SET MSG 80
I 0
<F8>
UW Physics VAX Micom Network channel <FA> 
<00>HELP or Select: <00>
!end of message text
!exit from SET MESSAGE

! BYE message
SET MSG 81
I 0
<F8>
MICOM disconnecting
!end of message text
!exit from SET MESSAGE

! GO message
SET MSG 82
I 0
<F8>
CONNECTED to <FB>! destination shelf/channel
!end of message text
!exit from SET MESSAGE

! HELP message
set msg 83
i 0
<F8>
To get HELP enter a carriage return.  At the Username: prompt enter HELP.
!end of message text
!exit from SET MESSAGE

! tell switch when to use our local messages
SET SM DEST=80 BYE=81 GO=82

!  Access Groups

! Chem Switch Ports 0-1A ( 1st 24 ) connected to 1st 24 MICOM ports
! note erratic numbering due to cabling quirks between VAX and MICOM
! set individual access groups for each Chem Switch Port
! these are not destinations, so no destination group
! protocol group is DTR & data lines only, data activity & timeout ???
! should be able to detect dropped DTR from switch indicating VAX should logout

SET PG 17 PROT=5 ! must also wire DTR from Chem switch to DTR of Micom
!                 ! DSR from Micom confirms connection, but is ignored by Chem

! generic Chem switch ports

! 1/025 Chem Switch port 00  Z\01  same block as  TTJ0:   1/073
! 1/032                  07  Z\08                 TTJ7:   1/080

! 1/033                  08  Z\09                 TTK0:   1/081
! 1/036                  0B  Z\12                 TTK3:   1/084

! 1/037                  10  Z\13                 TTI0:   1/085
! 1/044                  17  Z\20                 TTI7:   1/092

! 1/045                  0C  Z\21                 TTK4:   1/093
! 1/048                  0F  Z\24                 TTK7:   1/096

! 1/049                  18  A\01                 TTH0:   1/097
! 1/056                  1F  A\08                 TTH7:   1/104

! OTHER VAX PORTS

! 1/057                      A\09                 TTG4:   1/105
! 1/060                      A\12                 TTG7:   1/108

! 1/070                      A\21                 TTG0:   1/117
! 1/072                      A\24                 TTG3:   1/120

! 1/061                      A\13                 TTC0    1/109
! 1/069                      A\20                 TTC7    1/116

! Setting Access Group #3

SET AG 3 DRC=128               ! default connection to PHAST
SET AG 3 RCL                   ! give access to all VAX Resource Classes + modems
A 128                          ! generic PHAST port
A 127                          ! generic UWAPA1 port
A 126                          ! generic JANUS port
A 125                          ! generic UWAPA2 port
A 124                          ! generic dial-in-out MODEM port
A 123                          ! APHAST PHAST altypeahead port (file transfer)
A 122                          ! SLAC mux
A 121                          ! ACS Micom
A 120                          ! BPHAST in-out on PHAST::
A 119                          ! BJANUS in-out on JANUS:: 
A 118                          ! BUWAPA2 in-out on UWAPA2:: 
A 100                          ! unnamed for testing
A 78
A 77
A 76
A 75
A 74
!exit from SET AG RCL

! Setting Access Group #4

SET AG 4 DRC=128 DCH=NONE FDST=ON WMSG=NONE PTRY=0 RTRY=0 RSEL=OFF
SET AG 4 RCL
A 128
A 127
A 126
A 125  ! note:  no long distance dial-out modems 
A 123
A 122
A 121
A 100
A 78
A 77
A 76
A 75
! exit from SET AG 
 
! calling channels from chem switch

SET AG 3 DRC=128 DCH=NONE FDST=ON WMSG=NONE PTRY=0 RTRY=0 RSEL=OFF
SET CH 1/25:56 AG=3 DG=NONE PG=17 ! Setting Chem Switch channels (Z'S & A\01:08)

! direct connect terminals on Micom (don't let them dial out long dist.)

SET CH 1/57:60 AG=4 DG=NONE PG=1  ! A\09-A\12        ! 1/61 BEVERLY in ADP group
SET CH 1/62:64 AG=4 DG=NONE PG=1  ! A\14-A\16        ! 1/65 GERHART in ADP group
SET CH 1/67    AG=4 DG=NONE PG=1  ! A\19             ! 1/66 McPHEE in ADP group
SET CH 1/69:72 AG=4 DG=NONE PG=1  ! A\21-A\24        ! 1/68 DARREL in ADP group
SET CH 2/24:34 AG=4 DG=NONE PG=1  ! D\12,JB\01-JB\10 ! 2/12:21 & 23 in ADP group
SET CH 2/36    AG=4 DG=NONE PG=1  ! JB\12            ! 2/35 JDAVIS in ADP group
                                                    ! 2/22 Backup ACS Not in use
! Johnson Hall Mux.
 
SET CH 3/49:53 AG=4 DG=NONE PG=1  ! Johnson & Slac S-Cable ch #1-5
SET CH 3/55:56 AG=4 DG=NONE PG=1  ! Johnson & Slac S-Cable ch #7-8

! dial-in modems   restricted from dial-out again long distance.
!  300,1200

SET CH 3/25:48 AG=4 PG=5 DG=NONE   ! only 25-28,33-36,41-44 available on cable
                                   ! and only 25-28 and 33-36 have cards
    
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! Resource Classes   allow them to specify VAX port sometime 

! PHAST resource class
! VAX ports  TTJ TTK TTI TTH connected to MICOM channels 1/73:104 

SET PG 18 PROT=3 ! must also wire called channel MICOM DSR & DTR
!		  ! together to VAX DTR .  When connection is made, Micom
!                 ! raises DSR which raises its own DTR and VAX DTR.
! can't use PROT=5 since no high signal available to tell MICOM VAX is available


! 1/73  TTJ0: Chem Switch
! 1/83  TTJ7:      !
                   !
! 1/81  TTK0:      !
! 1/84  TTK3:      !
                   !
! 1/85  TTI0:      !
! 1/92  TTI7:      !
                   !
! 1/93  TTK4:      !
! 1/96  TTK7:      !
                   !
! 1/97  TTH0:      !
! 1/104 TTH7: Chem Switch

! 1/105 TTG4:
! 1/108 TTG7:

! 1/109 TTC0:
! 1/116 TTC7:

! 1/117 TTG0:
! 1/120 TTG3:

! PHAST resource class

SET DG 128 RC=128
SET RC 128 NAME="PHAST" D1DG=128 D2DG=120 D3DG=123 !Selects in order 128,120,123
SET RC 128 NAME="P" D1DG=128 D2DG=120 D3DG=123 !Selects in order 128,120,123

SET CH 1/73:79 AG=NONE PG=18 DG=128     ! PHAST:: (TTJ'S TTK'S TTI'S TTH'S)
SET CH 1/81:100 AG=NONE PG=18 DG=128    ! CH 1/80 is Dead
SET CH 1/109:116 AG=NONE PG=17 DG=128   ! PHAST:: (TTC0-TTC7)


! APHAST Altypeahead PHAST:: resource class
                  
SET DG 123 RC=123
SET RC 123 NAME="APHAST" D1DG=123

SET CH 1/101:104 AG=3 PG=17 DG=123   ! Alt-typeahead on PHAST:: (TTH4-TTH7)


! BPHAST in-out PHAST:: resource class
             
SET DG 120 RC=120
SET RC 120 NAME="BPHAST" D1DG=120

SET CH 1/105:108 AG=3 PG=17 DG=120  ! in-out on PHAST:: (TTG4-TTG7)
SET CH 1/117:120 AG=3 PG=17 DG=120  ! in-out on PHAST:: (TTG0-TTG3)


! UWAPA1 resource class

SET DG 127 RC=127
SET RC 127 NAME="UWAPA1" D1DG=127 
SET RC  77 NAME="1"      D1DG=127   ! abbreviation

SET CH 3/1:4 AG=3 PG=17 DG=127      ! in-out on UWAPA1:: (TTA0-TTA3)


! JANUS resource class 

SET DG 126 RC=126
SET RC 126 NAME="JANUS" D1DG=126 D2DG=119  !Selects in order 126,119
SET RC  76 NAME="J"     D1DG=126 D2DG=119  ! abbreviation
SET RC  50 NAME="HELP"  D1DG=126 D2DG=119  ! micom help
SET CH 3/9:12 AG=NONE PG=17 DG=126  ! JANUS::  (TXA4-TXA6)


! BJANUS in-out JANUS:: resource class

SET DG 119 RC=119
SET RC 119 NAME="BJANUS" D1DG=119

SET CH 3/5:8 AG=3 PG=17 DG=119      ! in-out on JANUS::  (TXA0-TXA3)


! UWAPA2 resource class

SET DG 125 RC=125
SET RC 125 NAME="UWAPA2" D1DG=125 D2DG=118 !Selects in order 125,118
SET RC  75 NAME="2"      D1DG=125 D2DG=118 ! abbreviation

SET CH 3/17:20 AG=NONE PG=17 DG=125        ! UWAPA2:: (TXA5-TXA7)


! BUWAPA2 in-out UWAPA2:: resource class

SET DG 118 RC=118
SET RC 118 NAME="BUWAPA2" D1DG=118

SET CH 3/13:16 AG=3 PG=17 DG=118           ! in-out on UWAPA2::  (TXA0-TXA3)


! dial-in-out MODEM resource class
! note: special wiring with resistor & capacitor necessary
!  should make provision for 300,1200,2400

SET RC 124 NAME="MODEM" D1DG=124
SET RC  74 NAME="M" D1DG=124
SET PG 22 PROT=5 ABR=3        ! 300, 1200 baud
SET CH 3/5:8 AG=4 PG=22 DG=124	! don't let them dial out after dialing in.


 
! SLAC resource class

SET PG 20 FSPD=9600 
SET PG 21 FSPD=1200 

SET DG 122 RC=122
SET RC 122 NAME="SLAC" D1DG=122
SET CH 3/57:60 AG=NONE PG=20 DG=122   ! speed=9600 ONLY
SET CH 3/60 PG=21                     ! speed=1200 ONLY

! ACS Micom resource class
SET RC 121 NAME="ACS" D1DG=121 
SET CH 4/33:40 AG=NONE PG=18 DG=121
SET CH 2/22 AG=NONE PG=18 DG=121      ! D\10

!
! ADP connections
!
SET AG 11:25 DRC=128 FDST=OFF   ! default connection to PHAST, not forced
SET AG 11:25 RCL
A 128                          ! generic PHAST port
A 127                          ! generic UWAPA1 port
A 126                          ! generic JANUS port
A 125                          ! generic UWAPA2 port
A 123                       ! PHAST altypeahead port (mainly for file transfer)
A 122                          ! SLAC mux
A 121                          ! ACS Micom
A 100                          ! TEST
A 78
A 77
A 76
A 75
!exit from SET AG RCL
    
SET CH 2/1:12  AG=NONE PG=17   ! ADP ports B-M (PHY02-PHY13)
SET CH 3/54    AG=NONE PG=17   ! ADP port  N  (PHY14)  (Johnson & Slac S-CH #6)
SET CH 2/13:21 DG=NONE PG=1 ! users terminals (MUST be direct to Micom)D\01-D\09
SET CH 2/23    DG=NONE PG=1    ! D\11  Helga
SET CH 1/61    DG=NONE PG=1    ! A\13R Y\16 Beverly
SET CH 1/65    DG=NONE PG=1    ! A\17 J\04 Gerhart
SET CH 1/66    DG=NONE PG=1    ! A\18  Darrel
SET CH 1/68    DG=NONE PG=1    ! A\20  Mcphee
SET CH 2/35    DG=NONE PG=1    ! JB\11 JDavis

! #A ADP Reserved for JDAVIS's direct ADP port  (but channel 1 on cable used
!                 for JDAVIS's CIT-101 on ADP port #14

! #B ADP Access Group entry for MCPHEE
SET RC 12 NAME="ADPJM"
SET AG 12 RCL                  ! give access to all VAX Resource Classes + ADP
A 12                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 1/68 AG=12              ! A\20
! #B ADP Destination Group entry for MCPHEE
SET DG 12 RC=12
SET CH 2/2 DG=12               

! #C ADP Access Group entry for GRAD
SET RC 13 NAME="ADPPF"
SET AG 13 RCL                  ! give access to all VAX Resource Classes + ADP
A 13                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/15 AG=13    ! D\03
! #C ADP Destination Group for GRAD
SET DG 13 RC=13
SET CH 2/3 DG=13

! #D ADP Access Group entry for DARREL
SET RC 14 NAME="ADPDS"
SET AG 14 RCL                  ! give access to all VAX Resource Classes + ADP
A 14                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 1/66 AG=14              ! A\18
! #D ADP Destination Group entry for DARREL
SET DG 14 RC=14
SET CH 2/4 DG=14 

! #E ADP Access Group entry for MARK
SET RC 15 NAME="ADPMM"
SET AG 15 RCL                  ! give access to all VAX Resource Classes + ADP
A 15                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/16 AG=15              ! D\04
! #E ADP Destination Group for MARK
SET DG 15 RC=15
SET CH 2/5 DG=15 

! #F ADP Access Group entry for LUCKY
SET RC 16 NAME="ADPLL"
SET AG 16 RCL                  ! give access to all VAX Resource Classes + ADP
A 16                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/13 AG=16              ! D\01
! #F ADP Destination Group for LUCKY
SET DG 16 RC=16
SET CH 2/6 DG=16 

! #G ADP Access Group entry for VILETT
SET RC 17 NAME="ADPLV"
SET AG 17 RCL                  ! give access to all VAX Resource Classes + ADP
A 17                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/20 AG=17              ! D\08
! #G ADP Destination Group for VILETT
SET DG 17 RC=17
SET CH 2/7 DG=17 

! #H ADP Access Group entry for TRINITY (Alma Johnson, solid state secretary)
SET RC 18 NAME="ADPAJ"
SET AG 18 RCL                  ! give access to all VAX Resource Classes + ADP
A 18                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/19 AG=18              ! D\07
SET CH 1/61 AG=18              ! A\13R Y\16 Beverly uses same ADP ch. as Alma
! #H ADP Destination Group for TRINITY
SET DG 18 RC=18
SET CH 2/8 DG=18 

! #I ADP Access Group entry for HELGA
SET RC 19 NAME="ADPHB"
SET AG 19 RCL                  ! give access to all VAX Resource Classes + ADP
A 19                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/23 AG=19              ! D\ Block @ D\11
! #I ADP Destination Group for HELGA
SET DG 19 RC=19
SET CH 2/9 DG=19 

! #J ADP Access Group entry for VALLES OR EMILY VAN ZEE
SET RC 20 NAME="ADPJDV"
SET AG 20 RCL                  ! give access to all VAX Resource Classes + ADP
A 20                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/18 AG=20 ! D\06
! #K ADP Destination Group for VALLES
SET DG 20 RC=20
SET CH 2/10 DG=20 

! #K ADP Access Group entry for JOYNER
SET RC 21 NAME="ADPMJ"
SET AG 21 RCL                  ! give access to all VAX Resource Classes + ADP
A 21                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/21 AG=21              ! D\09
! #K ADP Destination Group for JOYNER
SET DG 21 RC=21
SET CH 2/11 DG=21 

! #L ADP Access Group entry for MARGOT NIMS (Under Grad. Advisor)
SET RC 22 NAME="ADPMN"
SET AG 22 RCL                  ! give access to all VAX Resource Classes + ADP
A 22                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/14 AG=22              ! D\02
! #L ADP Destination Group for MARGOT
SET DG 22 RC=22
SET CH 2/12 DG=22 

! #M ADP Access Group entry for JDAVIS's CIT-101
SET RC 11 NAME="ADPJD2"        ! not used since direct connected
SET AG 11 RCL                  ! give access to all VAX Resource Classes + ADP
A 11                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/35 AG=11              ! JB\11
! #N ADP Destination Group for JDAVIS
SET DG 11 RC=11
SET CH 2/1 DG=11  ! channel 1 on spider cable, ADP port #14
!  NOTE !!! OUT OF ORDER !!!

! #N ADP Access Group entry for RICE
SET RC 23 NAME="ADPMR"
SET AG 23 RCL                  ! give access to all VAX Resource Classes + ADP
A 23                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 2/17 AG=23              ! D\05       
! #M ADP Destination Group for RICE    
SET DG 23 RC=23
SET CH 3/54 DG=23   

! #O ADP Access Group entry for GERHART
SET RC 24 NAME="ADPJG"
SET AG 24 RCL                  ! give access to all VAX Resource Classes + ADP
A 24                           ! this person's ADP Resource Class
!exit from SET AG RCL
SET CH 1/65 AG=24              ! A\17 J\04
! #O ADP Destination Group for GERHART
SET DG 24 RC=24
SET CH 2/37 DG=24 

!! #P ADP Access Group entry for ???
!SET RC 25 NAME="ADP??"
!SET AG 25 RCL                  ! give access to all VAX Resource Classes + ADP
!A 25                           ! this person's ADP Resource Class
!!exit from SET AG RCL
!SET CH 1/?? AG=25              ! A\17 J\04
!! #P ADP Destination Group for ???
!SET DG 25 RC=25
!SET CH 2/?? DG=25 

INS CH 1/25:120                 !
INS CH 2/1:120                  ! Put all ch in-service
INS CH 3/1:120                  !
  
INS SY                          ! Put system in-service
         
EXIT
$ set nover
