	PROGRAM TERMLIST
C  converts TERMLIST.SRC into several direct access file
C   SWITCHTERM.DAT, VAXPORT.DAT, PORTLIST.DAT, TERMSTRT.COM
C   possibly should add SWITCH.INT
C  note: 2'I specifies UNIT'REC specification in direct access READ and WRITE
C  input file format is fixed must be
C  two hex digit switch terminal number or 4 character terminal name
C  SET TERMINAL qualifiers, (/PERM assumed, /AUTOBAUD assumed if no /SPEED
C  circuit routing,
C  location 
C  all fields must be on the same input line
C  format: a5, a40, a30, a30
C  All fields must be there if any are.
C  JUNE 7, 1986 Belonis added Micom6000-via-chem-switch handling
C
	implicit       integer (a-z)
	character*105  line
c	structure /record1/
c	   character*5 term_num
c	   character*40 characteristics
c	   character*30 circuit
c	   character*30 location
c	end structure
c	record  /record1/ line
c	data  line/105*' '/

C  input data base
	open(1, file='termlist.src', status='old')

C  SWITCH TERMINALS  00 - 5F characteristics
	open(2, file='switchterm.dat', status='new',
	1 recordtype='fixed', recl=25, access='direct')

C  VAXPORTS TTA0 - TTM7 characteristics
	open(3, file='vaxport.dat', status='new',
	1 recordtype='fixed', recl=16, access='keyed',
	1 organization='indexed', form='unformatted',
	1 key=(1:4:character))

C  MICOM channels 1/73:1/104 accessed by chem SWITCH PORTS 00-1F
	open(4, file='portlist.dat', status='new',
	1 recordtype='fixed', RECL=3, access='direct')

C  SET TERMINAL STATEMENTS
	open(8, file='termstrt.com', status='new',
	1 carriagecontrol='list')

C  MICOMLIST.DAT to contain Micom Calling channels characteristics
	open(10, file='micomlist.dat', status='new',
	1	recordtype='fixed', recl=28, access='keyed',
	1	organization='indexed', form='unformatted',
	1	key=(1:5:character)  )

C  PHAST:: ports (at least) indexed by Micom called channel
	open(12, file='micomport.dat', status='new',
	1	recordtype='fixed', recl=3, access='keyed',
	1	organization='indexed', form='unformatted',
	1	key=(1:5:character)  )

c  transfer the source records to the output files
C	write(6,*)'begin to write records'
c	j=1
	do while (.true.)
C	   write(6,*)'this is the ',j,'th line'
	   read(1,10,end=100)  line
10 	   format(a105)	
c  add 3 extra blanks to 2nd field to allow room numbers in last field
c     to not wrap in WIRES command
	   line=line(1:42)//'   '//line(43:)
C	   write(6,*)line

c  check for comments
	   if (line(1:1).ne.'!') then

c	     term_num        = line(1:4)
c	     characteristics = line(6:45)
c	     circuit         = line(46:75)
c	     location        = line(76:105)
c	     WRITE(6,*)'*', line(1:4), '*'
C	     write(6,*)'*', characteristics, '*'
C	     write(6,*)'*', circuit, '*' 
C     	     write(6,*)'*', location, '*'
	     if( index(line(1:5),'/') .ne. 0 ) then
c  Micom calling channels
!1/025                                        Z\01 sw:00                    switch 00 
	 	write(10) line(1:5), line(6:45),line(46:75), line(76:105)
	        if( line(76:81).eq.'switch' ) then
c  Chem switch ports to Micom calling channels
       	  	   n1 = ichar(line(84:84))-48
       	           if (ichar(line(85:85)).ge.65) then	! its a letter
			n2 = ichar(line(85:85))-55	! A hex=10 decimal
	           else	! digit
			n2 = ichar(line(85:85))-48
	           end if
		   iswitchport = n1*16 + n2
		   write(4'iswitchport+1) line(1:5)
                 endif

	     elseif(( line(1:1).ge.'0' ).and.( line(1:1).le.'6' )) then
c  Chem switch terminals
		   read(line(1:2), 900) iswitchterm	! convert from ascii hex
900		   format(bn, z2)
		   write(2'iswitchterm+1) line(6:45), line(46:75),
     1			                  line(76:105)
d		   write(6,1000) term_num, circuit, location

	      else	! computer port (or equivalent)
		   write(3) line(1:4),line(46:75),line(76:105)

		   if(line(76:80).eq.'micom') then
c  write indexed by Micom called channel too
			   write(12) line(84:88),line(1:4)
d			   write(6,1100) term_num, circuit, location
		   endif
	      endif

c  write to termstrt.com all vaxports characteristics	      
	      if (line(1:1).eq.'T') then
	        write(8,200) line(1:4), line(6:45), line(76:105)
200	        format('$ set term ',a4,':','/perm',a40 / '$!',45x,a30)
	      endif
	   endif	! not comment
c	j=j+1
	end do
100	continue
d1000	format (1x,'switch terminal ',a4,/1x,
d    1    'circut= ',a30,/1x,'location= ',a30,/1x,'end',//)
1050	format (4a1,30a1,30a)
d1100	format (1x,'VAX port ',a4,/1x,
d    1    'circut= ',a30,/1x,'location= ',a30,/1x,'end',//)

	close(1)
	close(2)
	close(3)
	close(4)
	close(8)
	close(10)
	close(12)

	call exit
	end
