	subroutine pageoverlay(param)
c  copies 'page'-type overlay file into output
	character*(*) param(5)
	character overfname*132, oline*132
	logical outok

	overfname = param(4)
	outok = .false.
	open(9,file=overfname,defaultfile='.qms',status='old',readonly)
	do while(.true.)
100		read(9,'(q,a)',end=200) length,oline
c  remove lines until QUIC on
c  since TeX output used as overlay will have first line with a single space
		hatpos = index(oline,'^PY')	! QUIC on
		if(hatpos.ne.0) outok = .true.
		if( .not. outok ) goto 100	! ignore line
c  remove some stuff from overlay file
		hatpos = index(oline,'^IF')	! tray and stacker control
		if(hatpos.ne.0) then
		    oline = oline(1:hatpos-1)//oline(hatpos+7:)
		    length=length-7
		endif
		hatpos = index(oline,'^PN')	! QUIC off
		if(hatpos.ne.0) then
			oline =	oline(1:hatpos-1)//oline(hatpos+3:)
			length=length-3
		endif
		hatpos = index(oline,'^,')	! end of overlay page
		if(hatpos.ne.0) then
c  flush last line
			oline =	oline(1:hatpos-1)//oline(hatpos+2:)
			length=length-2
			if(length.le.0) then
				write(8,'(a)')
			else
				write(8,'(a)') oline(1:length)
			endif
			goto 200				
		endif
		if( length.le.0 ) then
			write(8,'(a)')
		else
			write(8,'(a)') oline(1:length)
		endif
	enddo
200	continue
c  done copying overlay into output file
	close(9)

	return
	end

