	program qpost
c  post-processor for inserting QUIC material into TeX output file
c  watches for strings of the form
c  SPECIALGOESHEREpar1,par2,par3,par4,par5,
c  where par1=horiz dimen	! worry about dimensions ???
c        par2=vert dimen
c	 par3=overlay type  (page, vector, raster)  LOWER CASE ONLY ???
c  or
c  SPECIALGOESHEREpar1,par2,verbatim,par4,par5,
c  where par1,par2,par5 are ignored
c        par3=verbatim
c        par4=arbitrary string of QUIC commands not including '}' or ','
c
c  blength MUST be smarter in case space-CR is in file !! ???
c
c  30-JUL-1986 Belonis improved PAGE-type overlay so \nopagenumbers not screw up
c  20-JAN-1986 Belonis commented out printout of line width change
c   1-NOV-1985 Belonis fixed bug when multiple SPECIALGOESHERE on a single
c        input line.  Discovered that \magnification macro causes problems
c        since QPOST does not know magnification, so should pass 'true'
c        dimensions to \grafix macro somehow.
c
	implicit none

c  functions
	integer lib$get_foreign, blength

	integer specpos, length, prevlen, hatpos, speclen, istat
	integer oldlen, commapos, i, l, s
	logical buffull, paramsearch
	character line*264, prevline*132, fname*132, inline*132
	character param(5)*80
	real offsetx, offsety

	parameter nresetlines=3
	character resetlines(nresetlines)*132
c  default reset as if it was TeX
	data resetlines/' ','^PY^-','^IOP^F^IT^IJ^IC00^ISYNTAX00010^T0'/

	speclen = len('SPECIALGOESHERE')

	istat=lib$get_foreign(fname,' Filename: ',,)
	if( .not.istat ) call exit(0)
	open(7,file=fname,defaultfile='.qms',status='old',readonly)
	open(8,file='qmsp'//fname,defaultfile='.post',status='new',
	1				carriagecontrol='list')

c  beware: line may have been broken by QTEX within special string !
c  this is handled by appending successive lines and searching, then
c  removing first line in buffer and appending next.  Unfortunately
c  each line is searched twice, once when it is at end of buffer, and
c  once when it is at begin of buffer.

	oldlen = 0

50	continue
	paramsearch = .false.

100	read(7,'(q,a)',end=900) length,inline
d	if(length.gt.0) then
d		print *,inline(1:length)
d	else
d		print *
d	endif

	if( oldlen.le.0 ) then		! put at begin of buffer and read again
		line = inline(1:length)
		oldlen = length
		goto 100
	else	! append new line to previous line to avoid line-break problems
		line = line(1:oldlen)//inline(1:length)
	endif
d	print *,line(1:oldlen+length)
	buffull = .true.			! then special string too broken
	if( paramsearch ) goto 200	! looking for parameters

150	continue		! comes here to search rest of line for special
	specpos = index(line,'SPECIALGOESHERE')
	if( specpos.le.0 ) then		! special not found
c  so output begin of buffer
		write(8,'(a)') line(1:oldlen)
c  save line in case have to back up to find position of special
		prevline = line(1:oldlen)
		prevlen = oldlen
c  move the newest line to begin of buffer
		line = inline(1:length)
		oldlen = length
		buffull = .false.
		goto 100
	endif

c output line(s) up to special
	if( specpos.gt.oldlen ) then	! not in first line so output it whole
		write(8,'(a)') line(1:oldlen)
c  save line in case have to back up to find position of special
		prevline = line
		prevlen = oldlen
		specpos = specpos - oldlen

		line = inline(1:length)
                oldlen = length
		length = 0
		buffull = .false.
	endif
c  else found special string (defines insertion location)
c  write partial line if necessary and find current position on page
c	print *,' before write partial line specpos=',specpos
 	if(specpos.gt.1) then
	    write(8,'(a)') line(1:specpos-1)
c  find current position on page
c  expect position commands immediately before special string since first in box
c  ???? what do we do if specpos=1 ?
	    call findpos(line(1:specpos-1),specpos-1,prevline,prevlen,
	1						offsetx,offsety)
	else
	    call findpos(' ',              1,        prevline,prevlen,
	1						offsetx,offsety)
        endif
	offsetx = offsetx/300	! was dots, now inches
	offsety = offsety/300	!     since 300 dots per inch

c  now find out about insertion (parse up to 5th comma, extracting stuff)
c  BEWARE: fairly likely that the parameters are broken across line by QTEX
c    so if fail to find all the commas, read another line into buffer	

c  comes here after failing to find proper # of commas and reading more
200	continue
d	print *,'after 200 specpos=',specpos
	s = specpos+speclen	! start
	l = length+oldlen		! length
	do i=1,5
		commapos=index(line(s:l),',')
		if(commapos.le.0) then
			if( buffull ) then			
			    print *,
	1		    '%QPOST-F-TOOFEWPARAM Too few \grafix parameters'
			    print *,line(1:oldlen)
			    print *,line(oldlen+1:oldlen+length)
			    call exit(0)
			endif
			paramsearch = .true.
			goto 100	! append next line
		endif
		param(i) = line(s:s+commapos-2)
		s = s + commapos	! s points after last comma ?
	enddo
c  display overlay info to user
	do i=1,5
		print *,param(i)
	enddo

c  get ready to read overlay file
	if( param(3).ne.'verbatim' .and. param(3).ne.'page' .and.
	1	param(3).ne.'vector' .and. param(3).ne.'vectorrub' ) then
		print *,'%QPOST-F-UNSUPPORTED Unsupported \special type'
		print *,param(3)
		call exit(0)
	endif

	if( param(3).eq.'verbatim' ) then
c  should pass literal string, but this can not be easily done for arbitrary
c  strings since TeX will glue and break lines
c  Probably can delete ^T & ^J commands and put into free format
		write(8,'(a)') param(4)
		goto 250
	endif
	if( param(3).eq.'page' ) call pageoverlay(param)
	if( param(3).eq.'vector' ) then
c  SHOULD PUT THIS SYNTAX IN SUBROUTINE !!!????????
c  set inches (thousandths) as dimensions
		write(8,'(a)') '^ISYNTAX00000'
		call vectoroverlay(param,offsetx,offsety,.false.)
	endif
	if( param(3).eq.'vectorrub' ) then
c  SHOULD PUT THIS SYNTAX IN SUBROUTINE !!!????????
c  set inches (thousandths) as dimensions
		write(8,'(a)') '^ISYNTAX00000'
		call vectoroverlay(param,offsetx,offsety,.true.)
	endif

c  reset parameters in case the overlay screwed us up
250	do i=1,nresetlines
	   if( blength(resetlines(i)).le.0 ) then
		write(8,'(a)')
	   else
		write(8,'(a)') resetlines(i)(1:blength(resetlines(i)))
	   endif
	enddo

c  should search remainder of line for SPECIALGOESHERE
c  so shift line left so stuff immediately after parameters is at
c  beginning of buffer
	if(s.gt.oldlen) then	! only one input line left in buffer
d               print *,'s > oldlen   s,oldlen=',s,oldlen
		line = line(s:oldlen+length)
		oldlen = oldlen+length - s + 1
	else			! multiple input lines still left in buffer
d               print *,'s <= oldlen   s,oldlen=',s,oldlen
		line(1:oldlen-s+1) = line(s:oldlen)	
		if( length.ge.1) line(oldlen-s+2:)=line(oldlen+1:oldlen+length)
		oldlen= oldlen - s + 1
d		print *,line(1:oldlen+length)
	endif
	goto 50   ! search rest of line for special (reading line if necessary)


c  finished reading input file
900	continue
	close(8)
	close(7)

	call exit
	end
