	subroutine scale(line, offsetx, offsety, availx, availy, rubber )
c  scale vectors to fit (also find proper scale at begin of plot)
	implicit none
	character*(*) line
	real offsetx, offsety, availx, availy
	logical rubber	! true to scale x & y independently
			! false preserves aspect ratio

c  caller knows orientations, so should pass in correct order.
c  problem with direction names:  ^U xxxxx:yyyyy
c  but Portrait vs. Landscape change meaning of x & y if differ for
c  text & overlay  ????

c
c  all dimensions in inches (or thousandths)
c	avail      available space in input file
c	vec        actual size in vector overlay file
c	offset     position of upper left corner of available space in input file
c       offsetvec  position of upper left corner of plot in overlay file
	character*1 colon1, colon2, letter
	integer start, xmin, xmax, ymin, ymax, hatpos, posx, posy
	integer outx, outy, numpos, istat, penwidthin, penwidthout

	real scalex, scaley, scalexy, offsetvecx, offsetvecy
	common/scales/scalex,scaley,offsetvecx,offsetvecy
	logical scaled, firstline, splitcommand
	common/scalestuff/scaled, firstline, splitcommand
	data scaled, firstline, splitcommand/.false.,.true.,.false./
	character*10 cxmax,cxmin,cymax,cymin

	start = 1

c	print *,'entering scale routine with line='
c	print *,line

	if( scaled ) goto 100
c	print *,'inside scale: offsetx,offsety=',offsetx,offsety
c	print *,'not yet scaled'
c  not yet found scale in overlay file
c  should be of the form ^U 00000:00916 10119:08500  i.e.^U xmin:xmax xmax:ymax
c  or if done with the old QMSINI routine,   ^U xmax:ymax 00000:iflip
	hatpos = index(line,'^U')
	if(hatpos.le.0) then
		return	! pass early lines back unchanged
	else
c  there is a scale-indicating ^U command
		if( firstline ) then
			firstline = .false.
			return		! ignore first ^U line
		endif
		read(line(hatpos+2:hatpos+25),'(a6,a1,a5,a6,a1,a5)')
	1		cxmin,colon1,cymin,cxmax,colon2,cymax
c	print *,cxmin,' ',colon1,' ',cymin,' ',cxmax,' ',colon2,' ',cymax
		read(line(hatpos+2:hatpos+25),
	1		'(bn,i6,a1,i5,i6,a1,i5)',iostat=istat)
	1		xmin,colon1,ymin,xmax,colon2,ymax
c		print *,xmin,colon1,ymin,xmax,colon2,ymax
		if(istat.ne.0) then
c			write(*,'(1x,a,z10)') 'istat=',istat
			print *,'SCALE-F-BADREAD Bad read of size'
			print *,line(1:hatpos+25)
			call exit(0)
		endif
		if( colon1.ne.':' .or. colon2.ne.':' ) then
			print *,'%QPOST-F-BADVEC Bad size indication'
			print *,'should be 2 colons ',colon1,colon2
			call exit(0)
		endif
c  check whether from old-style QMSPLOT QMSINI routine
		if( xmax.eq.0 ) then  ! from old-style QMSPLOT routine QMSINI
			print *,'%QPOST-I-OBSQMSINI Obsolete QMSINI routine.  ',
	1			'Assuming xmin, ymin = 0,0'
			xmax = xmin
			xmin = 0
			ymax = ymin
			ymin = 0
		endif
c  scales must be mult by 1000 to get real scales since 'avail' in inches
c     and 'xmax,xmin' in thousandths
		scalex = availx/(xmax - xmin)
		scaley = availy/(ymax - ymin)
		if(.not.rubber) then
			scalexy = min(scalex,scaley)
			scalex = scalexy
			scaley = scalexy
		endif
		offsetvecx = xmin
		offsetvecy = ymin
c  Parenthetic expressions center the plot in the available area
c   even if .not.rubber prevents from stretching in that direction.
		offsetx = offsetx + ( availx - scalex*(xmax-xmin) )/2
		offsety = offsety + ( availy - scaley*(ymax-ymin) )/2
		scaled = .true.
		firstline = .false.
		start = hatpos+26
		write(*,'(a,2g10.3)')
	1		' original x to y size ratio =',
	1		float(xmax-xmin)/float(ymax-ymin)
		write(*,'(a,2g10.3)') 
	1		' scale factors x,y=',1000*scalex,1000*scaley
		write(*,'(a,2g10.3)')
	1		' after scaling x to y size ratio =',
	1		(scalex/scaley)*(xmax-xmin)/(ymax-ymin)
c		print *,'offsetvecx,offsetvecy',offsetvecx,offsetvecy
c  doesn't matter much what we do with that command now, so just pass to
c  the rest of the scaling routines
	endif

c	print *,' DONE SCALING'

c  ready to scale anything on the line
100	continue
c	print *,'scaling now'

	if(splitcommand) then
		numpos = 1
		goto 110
	endif
	hatpos = index(line(start:len(line)),'^')
c	print *,'hatpos=',hatpos
	if( hatpos.le.0 ) goto 300
	letter = line(start+hatpos:start+hatpos)	! letter after hat
	if( letter.ne.'D' .and. letter.ne.'U' .and. letter.ne.'E' .and.
	1		letter.ne.'P' ) then
		start = start+hatpos	! next space after hatpos (s/b farther?
		goto 100
	endif

c  need to scale something
	numpos = hatpos + 2 + start	! one beyond '^U ' '^D ' '^E ' or ^PW
c  pen width should not be split ?
	if( line(numpos-2:numpos-1).eq.'PW' ) then
		read(line(numpos:numpos+2),'(i2)') penwidthin
c  rounds up
		penwidthout = penwidthin*SQRT(scalex*scaley)*1000 + 1
c		print *,'pen width in,out=',penwidthin,penwidthout
c  replace the numbers directly in the input string
		write( line(numpos:numpos+1),'(i2.2)' ) penwidthout
		start = numpos + 2
		splitcommand = .false.
		goto 100	! search for another hat
	endif
110	if( len(line).le.numpos .or.
	1		 line(numpos-1:len(line)) .eq. ' ' ) then
c  no numbers so done with line, but command may be split across two lines
		splitcommand = .true.
		goto 300	! finished with line, return the line as-is
	endif
c  some non-blanks still on line

c  see if we can read position,     if not: go to 100 via 200 and scan for hat
	read(line(numpos:numpos+10),'(i5,a1,i5)',err=200) posx, colon1, posy
c	print *,'posx,posy=',posx,posy
	if( colon1.ne.':' ) then
		print *,'%QPOST-F-BADVEC Bad vector position colon'
		print *,line(numpos:numpos+10)
		call exit(0)
	endif
c  vector relative to corner of input plot, scaled, and
c  shifted to be relative to corner of output area
	outx = (  (posx-offsetvecx)*scalex + offsetx  )*1000
	outy = (  (posy-offsetvecy)*scaley + offsety  )*1000
c	print *,'outx,outy=',outx,outy

c  replace the numbers directly in the input string
	write( line(numpos:numpos+10),'(i5.5,'':'',i5.5)' ) outx, outy
	start = numpos + 11	! position for hat scan if fail to find number
	numpos = numpos + 12	! maybe another position with same pen condition
	goto 110

c  not a position so scan for hat
200	continue
	splitcommand = .false.
	goto 100

300	continue
c  line finished, return it
c	print *,'scaled line=',line

	return
	end
