	subroutine vectoroverlay( param, offsetx, offsety, rubber )
c  copies 'vector'-type overlay file into output
	character*(*) param(5)
	real offsetx, offsety
	logical rubber	! .true. to scale x & y independently
			! .false. to preserve aspect ratio

	character overfname*132, oline*132
	logical copying, done
	real par(2), availx, availy
	real inchesperunit(2)
	logical scaled, firstline, splitcommand
	common/scalestuff/scaled, firstline, splitcommand
	
c  initialize common block for subroutine 'scale'
	scaled = .false.
	firstline = .true.
	splitcommand = .false.

c	print *,' in vectoroverlay: offsetx,offsety=',offsetx,offsety
	overfname = param(4)
	open(9,file=overfname,defaultfile='.qms',status='old',readonly)
	copying = .false.
	done = .false.

c  figure out the available space from the first two parameters
	do j=1,2
	  do i=1,len(param(j))
	    if( param(j)(i:i).gt.'9' .or. param(j)(i:i).lt.'0' .and.
	1				param(j)(i:i).ne.'.' ) then
c  non-numeric, see if a dimension
		if( param(j)(i:i+1).eq.'in' ) then
			inchesperunit(j) = 1.
		elseif( param(j)(i:i+1).eq.'pt' ) then
			inchesperunit(j) = 1/72.27			
		elseif( param(j)(i:i+1).eq.'cm' ) then
			inchesperunit(j) = 1/2.54
		else
			print *,'%QPOST-F-ILLDIM Illegal dimension'
			print *,param(j)
			call exit(0)
		endif
		param(j) = param(j)(1:i-1)
		goto 160
	    endif
	  enddo		! all characters
	  print *,'%QPOST-F-NODIM No dimension specified'
	  print *,param(j)
	  print *,line
	  call exit(0)

160	  continue
	  read(param(j),'(bn,g10.0)') par(j)
c	  print *,'par=',par(j)
	enddo		! both parameters
	availy = par(1)*inchesperunit(1)
	availx = par(2)*inchesperunit(2)

	do while(.true.)
100		read(9,'(q,a)',end=200) length,oline
		if(copying) goto 140
c  not yet copying
		hatpos = index(oline,'^F')	! start at free format
		if(hatpos.le.0) then
		    goto 100
		else
		    copying=.true.
		    oline = oline(hatpos+2:)	! setup to output remainder
		    length=length-hatpos-1
		endif
140		continue

c  remove some stuff from overlay file (QMSPLOT ARRANGES SO NOT NECESSARY !)
c		hatpos = index(oline,'^IF')	! tray and stacker control
c		if(hatpos.ne.0) then
c		    oline = oline(1:hatpos-1)//oline(hatpos+7:)
c		    length=length-7
c		endif
c		hatpos = index(oline,'^PN')	! QUIC off
c		if(hatpos.ne.0) then
c			oline =	oline(1:hatpos-1)//oline(hatpos+3:)
c			length=length-3
c		endif

c  decide when to stop copying  NOT GOOD IF THERE ARE bitmaps, font inserts etc.
		hatpos = index(oline,'^IGE')	! end of vector stuff
		if(hatpos.ne.0) then
			oline = oline(1:hatpos+3)
			length = hatpos+3
			done = .true.
		endif

c  the following test should never succeed, should be pre-empted by ^IGE
c		hatpos = index(oline,'^,')	! end of overlay page
c		if(hatpos.ne.0) then
c			oline =	oline(1:hatpos-1)//oline(hatpos+2:)
c			length=length-2
c			if(length.le.0) then
c				write(8,'(a)')
c			else
c				write(8,'(a)') oline(1:length)
c			endif
c			done = .true.
c		endif

c  scale the numbers in the line to position the plot in available area
		call scale(oline, offsetx, offsety, availx, availy, rubber)

		if(copying) then
			if(length.le.0) then
				write(8,'(a)')
			else
				write(8,'(a)') oline(1:length)
			endif
		endif
		if(done) goto 200
	enddo
200	continue

c  done copying overlay into output file
	close(9)

	return
	end

