	Program Gollum
c
	Include '($BrkDef)'
c
	Character*7	Terminal
c
	Common /JpiStr/	Terminal
c
	Integer*4	Remaining_File_Quota,	File_Quota
c
	Common /JpiVal/	Remaining_File_Quota,	File_Quota
c
	Integer*4	Item_List( 12 )
	Integer*4	Terminal_Length
c
	Common /JpiPrm/	Item_List,	Terminal_Length
c
	Parameter	Max_Units = 128
c
	Integer*4	Idle,	Status
c
	Integer*4	Idle_Table( Max_Units ) / Max_Units * 0 /
	Integer*4	Pid_Table( Max_Units )  / Max_Units * 0 /
c
	Common /UsrTbl/ Idle_Table,	Pid_Table
c
	Character*11	Time
	Character*3	Idle_Time
	Character*1	Cr / 13 /,	Lf / 10 /,	Bell / 7 /
c
	Integer*4	TT_UCB
	Integer*4	Idle_Cut_Over,	User_Cnt
c
	Call Sys$AscTim ( , Time, , %Val( 1 ) )
	Call Sys$SetPrn ( 'GOLLUM_' // Time(:8) )
c
	Call Setup_Jpi_Request
c
	Idle_Cut_Over = 30
	User_Cnt = 10
	ii = 10
c
	Do While ( (User_Cnt .ge. 10) .and. (Idle_Cut_Over .ge. 10) )
c
	    Status = TT_UCB ( Idle_Table, Pid_Table, , , , Max_Units )
c
	    If ( Status ) Then
c
		ii = 1
		User_Cnt = 0
c
		Do While ( ( Pid_Table( ii ) .ne. 0 ) .and.
	1			( ii .le. Max_Units ) )
c
		    User_Cnt = User_Cnt + 1
c
		    If ( Idle_Table( ii ) .gt. 0 ) Then
c
c			***  Calculate amount of idle time	***
c
			I_Minute = Idle_Table( ii ) / 60
c
			If ( I_Minute .ge. Idle_Cut_Over ) Then
c
c			    ***   Get some process information	***
c
			    Call Get_Process_Information(Pid_Table(ii))
c
			    If ((File_Quota .eq. Remaining_File_Quota) .or.
	1			(I_Minute .gt. 120)) Then
c
c				***  Notify user that his process is being
c				***  deleted.
c
				Write ( Idle_Time, 10 ) I_Minute
c
				Call Sys$AscTim ( , Time, , %Val( 1 ) )
				Call Sys$BrkThru (
	1				, Cr // Lf // Bell //
	1		  	  '%SYSTEM-F-LOGOUT, forced logout after' //
	1		  	  Idle_Time // ' minutes of inactivity' //
	1			  Cr // Lf // '-SYSTEM-I-TRMTIM, process ' //
	1			  'terminated at ' // Time
	1			, Terminal
	1			, %Val( Brk$C_Device ) , ,
	1			, %Val( Brk$M_Screen .or. Brk$M_Bottom .or.
	1				Brk$M_NoRefresh .or. 5 )
	1			, %Val( Brk$C_General )
	1			, %Val( 5 ) , , )
c
c				***   Delete the process
c
				Call Sys$DelPrc ( Pid_Table( ii ), )
				User_Cnt = User_Cnt - 1
			    End If
			End If
		    End If
		    ii = ii + 1
		End Do
	    End If
	    Idle_Cut_Over = Idle_Cut_Over - 5
	End Do
c
10	Format ( I3 )
c
	End



	Subroutine Get_Process_Information ( PID )
c
	Include 'GetJpi.Def'
c
	Integer*4	PID,		Sys$GetJpiW
c
	Call Sys$Getjpi( , PID, , Item_List, , , )
c
	Return
	End



	Subroutine Setup_Jpi_Request
c
c *** Job/Process information request type codes ***
c
	Include '($JpiDef)'
c
	Include 'GetJpi.Def'
c
	Integer*2	Short_List( 2, 12 )
c
	Equivalence(	Item_List,	Short_List	)
c
c *** Set up the JPI request (never changes) ***
c
c *** Terminal
	Short_List( 1, 1 )	= 7
	Short_List( 2, 1 )	= Jpi$_Terminal
	Item_List( 2 )	= %Loc( Terminal )
	Item_List( 3 )	= %Loc( Terminal_Length )
c *** Open file count
	Short_List( 1, 4 )	= 4
	Short_List( 2, 4 )	= Jpi$_Filcnt
	Item_List( 5 )	= %Loc( Remaining_File_Quota )
	Item_List( 6 )	= 0
c *** File quota
	Short_List( 1, 7 )	= 4
	Short_List( 2, 7 )	= Jpi$_Fillm
	Item_List( 8 )	= %Loc( File_Quota )
	Item_List( 9 )	= 0
c *** Mark end of options
	Short_List( 1, 10 )	= 0
	Short_List( 2, 10 )	= 0
	Item_List( 11 )	= 0
	Item_List( 12 )	= 0
c
	Return
	End
