	Program Gollum
c
	Include '($BRKDEF)'
c
	Character*128	Image_Name
	Character*15	Process_Name,	User_Name
	Character*7	Terminal
c
	Common /JpiStr/	Image_Name,	Process_Name,	Terminal,
	1		User_Name
c
	Integer*4	Process_State,	Process_Status,	Process_Index
	Integer*4	Remaining_File_Quota,	File_Quota
c
	Common /JpiVal/	Remaining_File_Quota,	File_Quota,
	1		Process_State,	Process_Status,	Process_Index
c
	Integer*4	Item_List( 30 )
	Integer*4	Process_Length,	Terminal_Length
	Integer*4	User_Length,	Image_Length
c
	Common /JpiPrm/	Item_List,	Image_Length,
	1		Process_Length,	Terminal_Length,
	1		User_Length
c
	Parameter	Max_Units = 128
c
	Integer*4	Idle,	Status
c
	Integer*4	Idle_Table( Max_Units ) / Max_Units * 0 /
	Integer*4	Pid_Table( Max_Units )  / Max_Units * 0 /
c
	Common /UsrTbl/ Idle_Table,	Pid_Table
c
	Character*11	Time
	Character*3	Idle_Time,	Answer
	Character*1	Cr / 13 /,	Lf / 10 /,	Bell / 7 /
c
	Integer*4	TT_UCB
c
	Call Setup_Jpi_Request
c
	Status = TT_UCB ( Idle_Table, Pid_Table, , , , Max_Units )
c
	If ( Status ) Then
c
	    ii = 1
c
	    Do While ( ( Pid_Table( ii ) .ne. 0 ) .and.
	1		( ii .le. Max_Units ) )
c
		If ( Idle_Table( ii ) .gt. 0 ) Then
c
c		    ***	Calculate amount of idle time	***
c
		    I_Minute = Idle_Table( ii ) / 60
c
		    If ( I_Minute .ge. 30 ) Then
c
c			***	Get some process information	***
c
			Call Get_Process_Information( Pid_Table( ii ) )
c
			Type 20, Process_Name, User_name, Terminal,
	1			 Image_Name, I_Minute
			Type 30
			Accept 40, Answer
c
			If ( Answer .eq. 'yes' ) Then
c
c			    ***	Notify user that his process is being
c			    ***	deletion.
c
			    Write ( Idle_Time, 10 ) I_Minute
c
			    Call Sys$AscTim ( , Time, , %Val( 1 ) )
			    Call Sys$BrkThru (
	1		, Cr // Lf // Bell //
	1		  '%SYSTEM-F-LOGOUT, forced logout after' //
	1		  Idle_Time // ' minutes of idle time' // Cr // Lf //
	1		  '-SYSTEM-I-TRMTIM, process terminated at ' //
	1		  Time
	1		, Terminal
	1		, %Val( Brk$C_Device )
	1		, 
	1		,
	1		, %Val( BRK$M_SCREEN .OR. BRK$M_BOTTOM .OR.
	1			BRK$M_NOREFRESH .OR. 5 )
	1		, %VAL( BRK$C_GENERAL )
	1		, %VAL( 5 )
	1		,
	1		, )
c
c			    ***	Delete the process
c
			    Call Sys$DelPrc ( Pid_Table( ii ), )
c
			End If
c
		    End If
c
		End If
c
		ii = ii + 1
c
	    End Do
c
	End If
c
10	Format ( I3 )
20	Format ( ' Process ',A<Process_Length>, ', owned by ',
	1	 A<User_Length>, ', on ', A<Terminal_Length>, /,
	1	 ' running image "', A<Image_Length>, '"', /,
	1	 ' has been idle for ', I3,' minutes and is a '
	1	 'candidate for deletion.',/ )
30	Format ( '$Delete this process ? ' )
40	Format ( A )
c
	End



	Subroutine Get_Process_Information ( PID )
c
c
	Character*128	Image_Name
	Character*15	Process_Name,	User_Name
	Character*7	Terminal
c
	Common /JpiStr/	Image_Name,	Process_Name,	Terminal,
	1		User_Name
c
	Integer*4	BrdCst$M_Bottom / 512 /
c
	Integer*4	Process_State,	Process_Status,	Process_Index
	Integer*4	Remaining_File_Quota,	File_Quota
c
	Common /JpiVal/	Remaining_File_Quota,	File_Quota,
	1		Process_State,	Process_Status,	Process_Index
c
	Integer*4	Item_List( 30 )
	Integer*4	Process_Length,	Terminal_Length
	Integer*4	User_Length,	Image_Length
c
	Common /JpiPrm/	Item_List,	Image_Length,
	1		Process_Length,	Terminal_Length,
	1		User_Length
c
	Integer*4	PID,		Sys$GetJpiW
c
	Call Sys$Getjpi( , PID, , Item_List, , , )
c
	Return
	End



	Subroutine Setup_Jpi_Request
c
c *** Job/Process information request type codes ***
c
	Include '($JpiDef)'
c
c
	Character*128	Image_Name
	Character*15	Process_Name,	User_Name
	Character*7	Terminal
c
	Common /JpiStr/	Image_Name,	Process_Name,	Terminal,
	1		User_Name
c
	Integer*4	BrdCst$M_Bottom / 512 /
c
	Integer*4	Process_State,	Process_Status,	Process_Index
	Integer*4	Remaining_File_Quota,	File_Quota
c
	Common /JpiVal/	Remaining_File_Quota,	File_Quota,
	1		Process_State,	Process_Status,	Process_Index
c
	Integer*4	Item_List( 30 )
	Integer*4	Process_Length,	Terminal_Length
	Integer*4	User_Length,	Image_Length
c
	Common /JpiPrm/	Item_List,	Image_Length,
	1		Process_Length,	Terminal_Length,
	1		User_Length
c
c
	Integer*2	Short_List( 2, 30 )
c
	Equivalence(	Item_List,	Short_List	)
c
c *** Set up the JPI request (never changes) ***
c
c *** User name
	Short_List( 1,  1 )	= 12
	Short_List( 2,  1 )	= Jpi$_Username
	Item_List(  2 )	= %Loc( User_Name )
	Item_List(  3 )	= %Loc( User_Length )
c *** Process Name
	Short_List( 1,  4 )	= 15
	Short_List( 2,  4 )	= Jpi$_Prcnam
	Item_List(  5 )	= %Loc( Process_Name )
	Item_List(  6 )	= %Loc( Process_Length )
c *** Image Name
	Short_List( 1,  7 )	= 128
	Short_List( 2,  7 )	= Jpi$_Imagname
	Item_List(  8 )	= %Loc( Image_Name )
	Item_List(  9 )	= %Loc( Image_Length )
c *** Terminal
	Short_List( 1, 10 )	= 7
	Short_List( 2, 10 )	= Jpi$_Terminal
	Item_List( 11 )	= %Loc( Terminal )
	Item_List( 12 )	= %Loc( Terminal_Length )
c *** Open file count
	Short_List( 1, 13 )	= 4
	Short_List( 2, 13 )	= Jpi$_Filcnt
	Item_List( 14 )	= %Loc( Remaining_File_Quota )
	Item_List( 15 )	= 0
c *** File quota
	Short_List( 1, 16 )	= 4
	Short_List( 2, 16 )	= Jpi$_Fillm
	Item_List( 17 )	= %Loc( File_Quota )
	Item_List( 18 )	= 0
c *** Current State
	Short_List( 1, 19 )	= 4
	Short_List( 2, 19 )	= Jpi$_State
	Item_List( 20 )	= %Loc( Process_State )
	Item_List( 21 )	= 0
c *** Process status flags
	Short_List( 1, 22 )	= 4
	Short_List( 2, 22 )	= Jpi$_Sts
	Item_List( 23 )	= %Loc( Process_Status )
	Item_List( 24 )	= 0
c *** Process Index
	Short_List( 1, 25 )	= 4
	Short_List( 2, 25 )	= Jpi$_Proc_Index
	Item_List( 26 )	= %Loc( Process_Index )
	Item_List( 27 )	= 0
c *** Mark end of options
	Short_List( 1, 28 )	= 0
	Short_List( 2, 28 )	= 0
	Item_List( 29 )	= 0
	Item_List( 30 )	= 0
c
	Return
	End
