$ newsvfy = f$verify(0)
$ if f$trnlnm("NEWSDEBUG",,,,,"ACCESS_MODE") .eqs. "EXECUTIVE" then set verify
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Procedure to process NEWS commands
$!
$!	Version 2.0 - 15 Aug 1986 - J F Lawrence
$!
$!	Commands:
$!
$!		CANCEL		Cancel news item (System)
$!		DIRECTORY	List news items
$!		EXIT		Leave news
$!		HELP		Help display
$!		LIST user	List all or specified user (System)
$!		PROLONG		Extend news item expiration date
$!		READ number	Read next or specified item
$!		SUBMIT/e @fn	Submit a news item
$!				    /e = edit command
$!				    @fn = filename
$!		TOPIC		Select new topic
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Initialize names
$!
$ ask = "INQUIRE/NOPUNCTUATION"
$ assign = "ASSIGN"
$ close = "CLOSE"
$ create = "CREATE"
$ delete = "DELETE"
$ exit = "EXIT"
$ goto = "GOTO"
$ if = "IF"
$ inquire = "INQUIRE"
$ on = "ON"
$ open = "OPEN"
$ read = "READ"
$ say = "WRITE SYS$OUTPUT"
$ type = "TYPE"
$ write = "WRITE"
$ if f$search("news:welcome.txt") .eqs. "" then goto new_subdirectory
$ type news:welcome.txt
$ ask junk "Press RETURN when ready"
$! goto show_topics
$!
$!	Setup subdirectory (if specified)
$!
$new_subdirectory:
$ if p1 .eqs. "" then p1 = "NEWS"
$ subdir = f$search("''f$trnlnm("news",,"executive")'''p1'.dir")
$ if subdir .nes. "" then goto subdir_found
$ type sys$input

%NEWS-F-DIRNOTFOUND, invalid or nonexistant sub directory

$ exit
$!
$subdir_found:
$ subdir = "''f$trnlnm("newsroot",,"executive")'[''p1']"
$ p1 = p1 + " "
$ if p1 .eqs. "NEWS " then p1 = ""
$!
$!	Initialize user name and privileges
$!
$setup_news:
$ on control_y then goto command_done
$ privileged = f$privilege("sysprv")
$ fulluser = f$getjpi(0,"username")
$ username = f$edit(fulluser,"collapse")
$!
$!	Bump count in NEWSLOG. create file if not found
$!
$open_newslog:
$ open/read/write/share=write/error=no_newslog newslog 'subdir'newslog.dat
$ read/key="''fulluser'"/error=nosuchuser newslog newslogdata
$ newslogdata[28*8,16] = f$cvui(28*8,16,newslogdata) + 1
$ write/update newslog newslogdata
$ close newslog
$ goto open_newsdir
$!
$nosuchuser:
$ close newslog
$ open/read/write/share=write newslog 'subdir'newslog.dat
$ newslogdata[0,12] := 'fulluser
$ newslogdata[12,16] := 1900-01-01 00:00
$ newslogdata[28*8,16] = 0
$ write newslog newslogdata
$ close newslog
$!
$open_newsdir:
$ open/error=no_newsdir/read/share=write newsdir 'subdir'newsdir.dat
$!
$open_lastnews:
$ if f$search("''subdir'lastnews.date") .nes. "" then goto news_dir
$ type sys$input

%NEWS-E-NOFILE, no news date file found.
%NEWS-I-CREATFILE, creating news date file

$ create/fdl=sys$input 'subdir'lastnews.date
IDENT	"NEWS date file"

FILE
	ALLOCATION              1
	BEST_TRY_CONTIGUOUS     no
	CLUSTER_SIZE            1
	CONTIGUOUS              no
	EXTENSION               0
	GLOBAL_BUFFER_COUNT     0
	ORGANIZATION            sequential
	PROTECTION              (system:RWED, owner:RWED, group:RWE, world:RWE)

RECORD
	BLOCK_SPAN              yes
	CARRIAGE_CONTROL        none
	FORMAT                  variable
	SIZE                    0

$ open/read/write lastnews 'subdir'lastnews.date
$ write lastnews "1900-01-01 00:00"
$ close lastnews
$!
$!	Build the help libraries
$!
$build_help:
$ if f$search("news:managerhelp.hlb") .nes. "" then goto news_dir
$ if f$search("news:managerhelp.hlp") .nes. "" then goto build_mgr_help
$ type sys$input

%NEWS-E-NOMGRHELP, no news manager help file found.

$ goto check_user_help
$!
$build_mgr_help:
$ type sys$input

%NEWS-I-CREATFILE, creating manager help file

$ library/help/create=block=20 news:managerhelp.hlb
$ library/help/replace news:managerhelp.hlb news:managerhelp.hlp
$!
$check_user_help:
$ if f$search("news:newshelp.hlp") .nes. "" then goto build_user_help
$ type sys$input

%NEWS-E-NOUSERHELP, no user help file found.

$ goto check_sys_help
$!
$build_user_help:
$ type sys$input

%NEWS-I-CREATFILE, creating user help file

$ library/help/create=block=15 news:newshelp.hlb
$ library/help/replace news:newshelp.hlb news:newshelp.hlp
$!
$check_sys_help:
$ if f$search("news:sysnews.hlp") .nes. "" then goto build_sys_help
$ type sys$input

%NEWS-E-NOSYSHELP, no system news help file found.

$ goto news_dir
$!
$build_sys_help:
$ type sys$input

%NEWS-I-CREATFILE, creating system news help file

$ library/help/replace sys$help:helplib.hlb news:sysnews.hlp
$ goto news_dir

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Main loop
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$do_command:
$ read sys$command/end=command_done/prompt="''p1'NEWS> " line
$!
$new_command:
$ if f$type(line) .eqs. "INTEGER" then goto news_read
$ line := 'line
$ if line .eqs. "" then goto news_read
$ line = line + " "
$ command = f$element(0," ",line)
$ command = f$element(0,"/",command)
$ command = f$element(0,"@",command)
$ command := 'command
$ if f$locate(command,"CANCEL") .eq. 0 .and. privileged then goto news_cancel
$ if f$locate(command,"DIRECTORY") .eq. 0 then goto news_dir
$ if f$locate(command,"EXIT") .eq. 0 then goto command_done
$ if f$locate(command,"HELP") .eq. 0 then goto news_help
$ if f$locate(command,"LIST") .eq. 0 .and. privileged then goto news_list
$ if f$locate(command,"PROLONG") .eq. 0 .and. privileged then goto news_prolong
$ if f$locate(command,"READ") .eq. 0 then goto news_read
$ if f$locate(command,"SUBMIT") .eq. 0 then goto news_submit
$ if f$locate(command,"TOPIC") .eq. 0 then goto news_topic
$!
$bad_command:
$ type sys$input

%NEWS-E-SYNTAX, input syntax error

$ goto do_command
$!
$command_done:
$ close newsdir
$ junk = f$verify(newsvfy)
$ exit

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Cancel command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_cancel:
$ close newsdir
$ open/error=no_newsdir/read/write/share=write newsdir 'subdir'newsdir.dat
$ lastsubmittal = "1900-01-01 00:00"
$!
$cancel_loop:
$ read/end=cancel_done newsdir newsdirdata
$ subj_len = f$cvui(56*8,8,newsdirdata)
$ subj = f$extract(58,subj_len,newsdirdata)
$ postdate = f$extract(16,11,newsdirdata)
$ submittor = f$edit(f$extract(44,12,newsdirdata),"trim")
$ ask yesno -
  "Delete Subj: ''subj',  Submitted: ''postdate',  By: ''submittor'? (Y or N) [N] "
$ if yesno then goto cancel_file
$ lastsubmittal = f$extract(0,16,newsdirdata)
$ goto cancel_loop
$!
$cancel_file:
$ fn_len = f$cvui(57*8,8,newsdirdata)
$ filename = f$extract(58+subj_len,fn_len,newsdirdata)
$ filename = f$search(filename)
$ if filename .nes. "" then delete/nolog 'filename'
$ read/delete/key="''f$extract(0,16,newsdirdata)'" newsdir newsdirdata
$ goto cancel_loop
$!
$cancel_done:
$ open/read/write lastnews 'subdir'lastnews.date
$ read lastnews junk
$ write/update lastnews lastsubmittal
$ close lastnews
$ goto news_dir

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Directory command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_dir:
$ close newsdir
$ open/error=no_newsdir/read/share=write newsdir 'subdir'newsdir.dat
$ open/read/share newslog 'subdir'newslog.dat
$ read/key="''fulluser'" newslog newslogdata
$ close newslog
$ lastread = f$extract(12,16,newslogdata)
$ count = 0
$!
$dir_loop:
$ read/end=dir_done newsdir newsdirdata
$ postdate = f$extract(16,11,newsdirdata)
$ expdate = f$extract(33,11,newsdirdata)
$ submittor = f$extract(44,12,newsdirdata)
$ subjlen = f$cvui(56*8,8,newsdirdata)
$ subj = f$extract(58,subjlen,newsdirdata)
$ fnlen = f$cvui(57*8,8,newsdirdata)
$ filename = f$extract(58+subjlen,fnlen,newsdirdata)
$ if f$search(filename) .eqs. "" then goto dir_loop
$ if count .ne. 0 then goto dir_loop_01
$ type sys$input

	NEWS	***   Current topics:

Item    Posted       Expires     Submittor     Subject
----  -----------  -----------  ------------  -----------------
$!
$dir_loop_01:
$ count = count + 1
$ index = f$extract(f$length(count)-1,3,"  ''count'")
$ checkdate = f$extract(0,16,newsdirdata)
$ prefix = ""
$ if lastread .lts. checkdate then prefix = "[1;5m"
$ say "''prefix'''index'   ''postdate'  ''expdate'  ''submittor'  ''subj'[m"
$ goto dir_loop
$!
$dir_done:
$ if count .ne. 0 then goto dir_done_01
$ type sys$input

	NO NEWS IS GOOD NEWS
$!
$dir_done_01:
$ type sys$input

For a list of commands, enter HELP

$ goto do_command

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Help command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_help:
$ assign/user " " hlp$library
$ assign/user sys$command sys$input
$ if privileged then help/page @news:managerhelp.hlb
$ if .not. privileged then help/page @news:newshelp.hlb
$ goto do_command

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	List command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_list:
$ key = f$element(1," ",line)
$ if key .nes. "" then key = "/key=''key'"
$ open/read/share newslog 'subdir'newslog.dat
$ say := write sys$output
$ type sys$input
  Username        Last access       Count     Last submit       #Subs
------------    ----------------    -----   -----------------   -----
$!
$list_loop:
$ read/end=list_done'key' newslog newslogdata
$ fullname = f$extract(0,12,newslogdata)
$ lastdate = f$extract(12,16,newslogdata)
$ count = f$string(f$cvui(28*8,16,newslogdata))
$ count = f$extract(f$length(count),5,"00000"+count)
$ lastsubdate = f$extract(30,16,newslogdata)
$ subcount = ""
$ if lastsubdate .eqs. "" then goto never_submitted
$ subcount = f$string(f$cvui(46*8,16,newslogdata))
$ subcount = f$extract(f$length(subcount),5,"00000"+subcount)
$!
$never_submitted:
$ say "''fullname'    ''lastdate'    ''count'   ''lastsubdate'   ''subcount'"
$ if key .eqs. "" then goto list_loop
$!
$list_done:
$ close newslog
$ goto do_command

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Prolong command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_prolong:
$ close newsdir
$ open/error=no_newsdir/read/write/share=write newsdir 'subdir'newsdir.dat
$!
$prolong_loop:
$ read/end=prolong_done newsdir newsdirdata
$ subj_len = f$cvui(56*8,8,newsdirdata)
$ subj = f$extract(58,subj_len,newsdirdata)
$ postdate = f$extract(16,11,newsdirdata)
$ expdate = f$extract(33,11,newsdirdata)
$ submittor = f$edit(f$extract(44,12,newsdirdata),"trim")
$!
$get_extension:
$ say -
  "Extend Subj: ''subj',  Submitted: ''postdate',  By: ''submittor'"
$ ask yesno -
  "Expires: ''expdate'? (Y or N) [N] "
$ if .not. yesno then goto prolong_loop
$ ask extend "Number of days to extend submittal "
$ if f$type(extend) .nes. "INTEGER" then goto get_extension
$ if extend .lt. 1 then goto get_extension
$ exptime = f$cvtime("''expdate'+''extend'-","absolute")
$ exptime = f$extract(f$length(exptime)-22,11," "+exptime)
$ newsdirdata[33,11] := 'exptime'
$ write/update newsdir newsdirdata
$ goto prolong_loop
$!
$prolong_done:
$ goto news_dir

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Read command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_read:
$ item = f$element(1," ",line)
$ if f$type(line) .eqs. "INTEGER" then item = line
$ close newsdir
$ open/error=no_newsdir/read/share=write newsdir 'subdir'newsdir.dat
$ count = 0
$ open/read/share newslog 'subdir'newslog.dat
$ read/key="''fulluser'" newslog newslogdata
$ close newslog
$ lastread = f$extract(12,16,newslogdata)
$ open/read lastnews 'subdir'lastnews.date
$ read lastnews subtime
$ close lastnews
$!
$read_loop:
$ read/end=read_done newsdir newsdirdata
$ count = count + 1
$ if count .lt. item then goto read_loop
$ if lastread .ges. subtime then goto read_anyway
$ postdate = f$extract(0,16,newsdirdata)
$ if postdate .lts. lastread then goto read_loop
$!
$read_anyway:
$ subjlen = f$cvui(56*8,8,newsdirdata)
$ fnlen = f$cvui(57*8,8,newsdirdata)
$ filename = f$extract(58+subjlen,fnlen,newsdirdata)
$ if f$search(filename) .eqs. "" then goto read_loop
$ type/page 'filename'
$ read sys$command/end=do_command/prompt="[24;1fMORE NEWS> " line
$ line := 'line
$ if line .nes. "" then goto new_command
$ goto read_loop
$!
$read_done:
$ open/read/write/share=write newslog 'subdir'newslog.dat
$ read/key="''fulluser'" newslog newslogdata
$ newslogdata[12,16] := 'f$extract(0,16,f$cvtime(f$time()))
$ write/update newslog newslogdata
$ close newslog
$type sys$input

%NEWS-I-NOMORENEWS, no more news

$ goto do_command

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Submit command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_submit:
$ if f$trnlnm("NEWSENABLE",,,,,"ACCESS_MODE") .eqs. "EXECUTIVE" -
  .or. privileged then goto do_submit
$ type sys$input

%NEWS-E-NOTAVAIL, news submitals are not enabled, contact your system manager

$ goto do_command
$!
$do_submit:
$ close newsdir
$ open/error=no_newsdir/read/append/share=write newsdir 'subdir'newsdir.dat
$ line = f$edit(line,"collapse")
$ line_len = f$length(line)
$ edt_loc = f$locate("/",line)
$ fn_loc = f$locate("@",line)
$ edt_len = fn_loc - edt_loc
$ if edt_len .lt. 0 then goto edt_last
$ edit_command = f$extract(edt_loc,edt_len,line) - "/"
$ fn_len = line_len - fn_loc
$ input_file = f$extract(fn_loc,fn_len,line) - "@"
$ goto get_expiration
$!
$edt_last:
$ edt_len = line_len - edt_loc
$ edit_command = f$extract(edt_loc,edt_len,line) - "/"
$ fn_len = fn_loc - edt_loc
$ input_file = f$extract(fn_loc,fn_len,line) - "@"
$!
$get_expiration:
$ ask expire "Length of time in days news item will remain posted: (1 - 90) "
$ if f$type(expire) .nes. "INTEGER" then goto get_expiration
$ if expire .lt. 1 then goto get_expiration
$ if .not. privileged .and. expire .gt. 90 then goto get_expiration
$ time = f$time()
$ curtime = f$extract(f$length(time)-22,17," "+time)
$ exptime = f$cvtime("''time'+''expire'-","absolute")
$ exptime = f$extract(f$length(exptime)-22,11," "+exptime)
$!
$get_subject:
$ read/prompt="Subject: " sys$command subj
$ if subj .eqs. "" then goto get_subject
$ if input_file .nes. "" then goto input_exists
$ if edit_command .nes. "" then goto input_exists
$ say "Enter your subject below. Press CTRL Z when complete, or CTRL C to quit"
$ on control_y then goto cancel_submit
$ assign/user sys$command sys$input
$ create newstemp.nws
$!
$input_exists:
$ if input_file .eqs. "" then input_file = "NEWSTEMP.NWS"
$ if edit_command .eqs. "" then goto no_edit
$ assign/user sys$command sys$input
$ assign/user sys$command sus$output
$ 'edit_command' 'input_file'
$!
$no_edit:
$ submittor = fulluser
$ if privileged then submittor = "Staff       "
$ subtime = f$extract(0,16,f$cvtime(time))
$ filename = f$trnlnm("sys$login","lnm$job",,"executive") + "NEWS" -
  + f$extract(2,2,subtime) + f$extract(5,2,subtime)-
  + f$extract(8,2,subtime) + f$extract(11,2,subtime) -
  + f$extract(14,2,subtime) + ".NWS"
$ create/fdl=sys$input 'filename'
IDENT	"NEWS item file"

FILE
	ALLOCATION              1
	BEST_TRY_CONTIGUOUS     no
	CLUSTER_SIZE            1
	CONTIGUOUS              no
	EXTENSION               0
	GLOBAL_BUFFER_COUNT     0
	ORGANIZATION            sequential
	PROTECTION              (system:RWED, owner:RWE, group:RE, world:RE)

RECORD
	BLOCK_SPAN              yes
	CARRIAGE_CONTROL        carriage_return
	FORMAT                  variable
	SIZE                    0

$ open/append newsfile 'filename'
$ write newsfile "Date:	''curtime'		Expires: ''exptime'"
$ write newsfile "From:	''submittor'"
$ write newsfile "Subj:	''subj'"
$ write newsfile ""
$ close newsfile
$ append 'input_file' 'filename'
$ if input_file .eqs. "NEWSTEMP.NWS" then delete/nolog newstemp.nws;*
$ comptime = f$extract(0,16,f$cvtime(curtime))
$ newsdirdata = comptime + curtime + exptime + submittor
$ subjlen = f$length(subj)
$ fnlen = f$length(filename)
$ newsdirdata[56*8,8] = subjlen
$ newsdirdata[57*8,8] = fnlen
$ newsdirdata[58,subjlen] := "''subj'"
$ newsdirdata[58+subjlen,fnlen] := 'filename
$ write newsdir newsdirdata
$ open/read/write lastnews 'subdir'lastnews.date
$ read lastnews junk
$ write/update lastnews subtime
$ close lastnews
$ open/read/write/share=write newslog 'subdir'newslog.dat
$ read/key="''fulluser'" newslog newslogdata
$ if f$length(newslogdata) .eq. 30 then newslogdata[46*8,16] = 0
$ newslogdata[30,16] := 'subtime
$ newslogdata[46*8,16] = f$cvui(46*8,16,newslogdata) + 1
$ write/update newslog newslogdata
$ close newslog
$ goto do_command
$!
$cancel_submit:
$ on control_y then goto command_done
$ type sys$input

%NEWS-F-SUBMITABORT, no submittal made

$ goto do_command

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	Topic command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$news_topic:
$ item = f$element(1," ",line)
$ if item .eqs. "" then goto show_topics
$ p1 := 'item
$ goto default_topic
$!
$show_topics:
$ type sys$input

 	The following topics may be selected:

$!
$topic_loop:
$ next_file = f$search("news:*.dir")
$ if next_file .eqs. "" then goto get_topic
$ topic = f$parse(next_file,,,"name")
$ if topic .eqs. "NEWS" then topic = topic + " (Default)"
$ say "		''topic'"
$ goto topic_loop
$!
$!	The following code is here for future use when  I display highlighted
$!	topics
$!
$ subdir = "newsroot:[" _ topic + "]"
$ close newsdir
$ open/error=no_newsdir/read/share=write newsdir 'subdir'newsdir.dat
$ open/read/share newslog 'subdir'newslog.dat
$ read/key="''fulluser'" newslog newslogdata
$ close newslog
$ lastread = f$extract(12,16,newslogdata)
$ checkdate = f$extract(0,16,newsdirdata)
$ prefix = ""
$ if lastread .lts. checkdate then prefix = "[1;5m"
$!
$get_topic:
$ say ""
$ p1 = ""
$ read sys$command/end=default_topic/prompt="Enter desired topic (RETURN for default): " line
$ p1 := 'line
$!
$default_topic:
$ if p1 .eqs. "" then p1 = "NEWS"
$ if f$trnlnm ("newsdir") .nes. "" then close newsdir
$ goto new_subdirectory

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	No news directory. Create one
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$no_newsdir:
$ type sys$input

%NEWS-E-NODIR, no news directory found.
%NEWS-I-CREATDIR, creating news directory

$ create/fdl=sys$input 'subdir'newsdir.dat
IDENT	"NEWS directory data file"

FILE
	ORGANIZATION		indexed
	OWNER			[001,004]
	PROTECTION		(system:RWE, owner:RWE, group:RWE, world:RWE)

RECORD
	CARRIAGE_CONTROL	none
	FORMAT			variable
	SIZE			0

AREA 0
	ALLOCATION		9
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		1
	EXTENSION		1

AREA 1
	ALLOCATION		3
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		1
	EXTENSION		1

KEY 0
	CHANGES			no
	DATA_AREA		0
	DATA_FILL		100
	DATA_KEY_COMPRESSION	yes
	DATA_RECORD_COMPRESSION	yes
	DUPLICATES		no
	INDEX_AREA		1
	INDEX_COMPRESSION	yes
	INDEX_FILL		100
	LEVEL1_INDEX_AREA	1
	NAME			"time"
	PROLOG			3
	SEG0_LENGTH		16
	SEG0_POSITION		0
	TYPE			string

$ goto open_newsdir

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$!	No news log. Create one
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$no_newslog:
$ type sys$input

%NEWS-E-NOLOG, no news log found.
%NEWS-I-CREATLOG, creating news log

$ create/fdl=sys$input 'subdir'newslog.dat
IDENT	"NEWS log data file"

FILE
	ORGANIZATION		indexed
	OWNER			[001,004]
	PROTECTION		(system:RWE, owner:RWE, group:RWE, world:RWE)

RECORD
	CARRIAGE_CONTROL	none
	FORMAT			variable
	SIZE			0

AREA 0
	ALLOCATION		20
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		1
	EXTENSION		4

AREA 1
	ALLOCATION		3
	BEST_TRY_CONTIGUOUS	yes
	BUCKET_SIZE		1
	EXTENSION		1

KEY 0
	CHANGES			no
	DATA_AREA		0
	DATA_FILL		100
	DATA_KEY_COMPRESSION	yes
	DATA_RECORD_COMPRESSION	yes
	DUPLICATES		no
	INDEX_AREA		1
	INDEX_COMPRESSION	yes
	INDEX_FILL		100
	LEVEL1_INDEX_AREA	1
	NAME			"username"
	PROLOG			3
	SEG0_LENGTH		12
	SEG0_POSITION		0
	TYPE			string

$ goto open_newslog
