$ verify_state = f$verify(0)
$ if f$trnlnm("REMOTEDEBUG",,,,,"ACCESS_MODE") .eqs. "EXECUTIVE" then set verify
$!
$!	Procedure to read or write to a remote link. It primarily intended as a
$!	cluster management tool.
$!
$!	This routine runs either as the master on the local node or as a slave
$!	on a remote node.
$!
$!	Written by:	Joe Lawrence
$!			Mail Station 124-114
$!	  		Rockwell International CATD
$!	  		Cedar Rapids, IA, 52498
$!	  		(319) 395-4296
$!
$!	If you use this procedure on a microVAX I, a 725, or a 730, you should
$!	move all the comments (lines starting with $!) to the end of the
$!	procedure or delete them to improve performance.
$!
$!	The documentation is contained in these comments, so read them all
$!	the way through before you attempt to use REMOTE.
$!
$ on control_y then goto abort
$ on error then goto abort
$ on severe_error then goto abort
$ continue = "[7mpress RETURN to continue[m"
$ this_node = f$trnlnm("sys$node") - "::"
$!
$!	Determine which mode and branch accordingly.
$!
$ if f$mode() .eqs. "NETWORK" then goto net_link
$!
$!	Local node - Get node information
$!
$!	You will have to edit the following line to include all the names of
$!	nodes in your cluster. Enter in uppercase and separate names with a
$!	slash (/).
$!
$!	A note about the node list. REMOTE will search the list for a match
$!	with P1. If a match is found, REMOTE will use the value of P1 as the
$!	remote node name. If no match is found, REMOTE will search the list
$!	for the local node name and use the next item as the remote node
$!	name. REMOTE "wraps around" so that the first item follows the last
$!	item. You can edit the list to have node pairs default to each other
$!	by putting one name name on either side of the other.
$!
$ nodelist = "CAD1/CAD2/CAD1/SAL/HAL/SAL/FMS"
$ first_entry = "YES"
$ count = 0
$!
$!	First, we check if a node name was entered as the first parameter
$!
$check_node:
$ rem_node = f$element(count,"/",nodelist)
$ junk = "node: ''rem_node' count: ''f$string(count)'"	!Debug aid
$ if p1 .eqs. rem_node then goto got_node
$ if rem_node .eqs. "/" .or. rem_node .eqs. "" then goto no_node
$ count = count + 1
$ goto check_node
$!
$!	A node name was entered. Use it and trim P1 parameter from the input
$!	command. Then go and check for a command
$!
$got_node:
$ count = 1
$!
$move_params:
$ next = count + 1
$ if next .gt. 8 then goto get_command
$ p'count = p'next
$ if next .eq. 8 then p'next = ""
$ count = count + 1
$ goto move_params
$!
$!	No node was entered. Find the local node in the nodelist. Then use the
$!	next node name in the list. If the local name is the last name in the
$!	list, wrap to the first name.
$!
$no_node:
$ count = 0
$!
$get_local_node:
$ node = f$element(count,"/",nodelist)
$ if this_node .eqs. node then goto got_local_node
$ if node .eqs. "/" then goto local_node_error
$ count = count + 1
$ goto get_local_node
$!
$got_local_node:
$ rem_node = f$element(count + 1,"/",nodelist)
$ if rem_node .eqs. "/" then rem_node = f$element(0,"/",nodelist)
$!
$!	We now have a node to link to. Let's check the command. If none was
$!	entered, go into interactive mode and prompt for commands until a
$!	CTRL-Z or EXIT command is entered.
$!
$get_command:
$ command = p1
$ if p1 .eqs. "" .and. first_entry then write sys$output "Enter HELP for help"
$ if p1 .eqs. "" then -
  read sys$command/end=exit/prompt="REM-''rem_node'> "  p1
$ first_entry = "NO"
$ if p1 .eqs. "" then goto get_command
$!
$!	At this point we have some sort of command. We will now manipulate it
$!	to convert any symbols to a full DCL command. This allows us to use
$!	shorthand commands on other nodes. Of course, any private images or
$!	command files referenced by the command MUST be on the other node.
$!	For a cluster, this should be the case. Unfortunately, we cannot
$!	expand foreign commands since they may have qualifiers which can't be
$!	included in a RUN command. Foreign commands can be used if they are
$!	defined in the SYLOGIN command procedure of the target node.
$!
$ p1 = f$edit(p1,"upcase")
$ first_char = f$extract(0,1,p1)
$ if first_char .eqs. "$" .or. first_char .eqs. "@" then goto send_net_command
$ x = f$element(0,"/",p1)
$ x = f$element(0," ",x)
$ if f$locate(x,"EXIT") .eq. 0 then goto exit
$ if f$locate(x,"HELP") .eq. 0 then goto help
$ if f$locate(x,"REMOTE") .eq. 0 then goto local_command_error
$ y = x
$ if f$type('x) .eqs. "STRING" then y = 'x
$ if f$locate("$","''y'") .eq. 0 then y = x
$ z = p1 - x
$ if "''x'" .nes. "''y'"  then p1 = y + z
$!
$!	We finally have everything we need. Set up the remote link by making
$!	a task request over the network. We open a remote task read/write as
$!	if it were a file. We can then communicate between the local and
$!	remote nodes via DCL read and write commands. This works because of
$!	DEC's excellent lock manager.
$!
$!	There are three ways to setup REMOTE for use that I know of.
$!
$!	1. Object REMOTE can be defined in the DECnet database for each node
$!	   that it will be used on. This is best if more than one account
$!	   will be using REMOTE since only one copy of the procedure need be
$!	   on each node. If you use a common system disk for your cluster,
$!	   put REMOTE somewhere in one of the SYS$COMMON directories. Then
$!	   use the following commands to define and set it:
$!
$!		$ RUN SYS$SYSTEM:NCP
$!		NCP> DEFINE OBJECT REMOTE NUMBER 0 FILE file-name
$!		NCP> SET OBJECT REMOTE ALL
$!		NCP> EXIT
$!
$!	   File-name must be a full file name and include device, directory,
$!	   name, and type. eg, SYS$COMMON:[SYSEXE]REMOTE.COM. See your Guide
$!	   to Networking for more details on network objects.
$!
$!	2. Object REMOTE can be placed in the default DECNET account. Users
$!	   that don't have proxy accounts can then access it and you won't
$!	   have to define a new network object. This won't work for proxy
$!	   accounts. It also won't work for privileged accounts. Both of
$!	   these type of accounts must use method 1 (above) or 3 (below).
$!
$!	3. Object REMOTE can be placed in every node's SYS$LOGIN directory
$!	   for each user who will access it. This could mean lots of copies
$!	   floating around.
$!
$send_net_command:
$ open/read/write/error=local_open_fail net 'rem_node'::"0=REMOTE"
$ write net "''p1' ''p2' ''p3' ''p4' ''p5' ''p6' ''p7' ''p8'"
$!
$!	Now go into a loop reading the remote task's responses. After 24 lines
$!	have been sent, the remote task will poll for a continuation.
$!
$local_loop:
$ read/error=local_read_fail/end=local_loop_done net message
$ if f$locate(continue,message) .ne. f$length(message) then goto local_wait
$ write sys$output message
$ goto local_loop
$!
$local_wait:
$ read sys$command/end=local_loop_done/prompt="''message'" junk
$ write net " "
$ goto local_loop
$!
$!	Remote node closed the link. We do the same and check if we are in
$!	command or dialog mode
$!
$local_loop_done:
$ close net
$ if command .nes. "" then goto exit
$ p1 = ""
$ goto get_command
$!
$!	Process help request
$!
$help:
$ type sys$input

        REMOTE allows you to initiate a single command or command dialog
        with a remote node. You may enter any valid DCL command that
        does NOT take exclusive control of the screen (ie SHOW is ok,
        MONITOR is not). REMOTE will expand symbols to their full DCL
        command equivalent. It will not expand foreign command lines at
        this time. They must exist on the remote node.

	The command syntaxes for REMOTE are:

		$ REMOTE  [node] [command]
	or
		REM-node> command

$!	The following is specific to my cluster. You should change or remove
$!	it.
$!
$ type sys$input
	Special commands that are recognized are:

		DISKUSE	  - Displays disk usage by volume
		MICOM	  - Displays MICOM port usage
	        NETLINKS  - Displays DECnet links on the remote node
		VIEWS	  - Displays login time and image for all processes

$ p1 = ""
$ goto get_command

$!
$!	Network request. respond to it by opening a read/write link. Read the
$!	input command, echo it back, and then execute it. We assign a temporary
$!	file to SYS$OUTPUT since assigning SYS$NET to SYS$OUTPUT is not always
$!	reliable.
$!
$net_link:
$ open/read/write/error=remote_open_fail net sys$net
$ read/end=remote_read_fail net input
$ input = f$edit(input,"trim")
$ if input .eqs. "" then goto no_net_request
$ write net "Request: ''input' received on node: ''this_node'"
$ write sys$output "''input'"
$ assign temp.file sys$output
$ 'input'
$ deassign sys$output
$!
$!	Now process the temporary output file by reading each record to SYS$NET.
$!	Keep track of lines out and poll for a response every 24 lines.
$!
$ open/read temp temp.file
$ count = 1
$!
$net_loop:
$ read/end=net_loop_done temp data
$ write net data
$ count = count + 1
$ if count .lt. 24 then goto net_loop
$ write net f$fao("!28* !AS",continue)
$ read/end=net_loop_done net junk
$ count = 1
$ goto net_loop
$!
$net_loop_done:
$ close temp
$ close net
$ goto exit

$!
$!    	Error stuff
$!
$local_command_error:
$ write sys$output "%REMOTE-F-CMDERR, ''p1' is an invalid command"
$ p1 = ""
$ goto get_command
$!
$local_node_error:
$ write sys$output "%REMOTE-F-NODERR, cannot find this node in node list"
$ goto exit
$!
$local_open_fail:
$ write sys$output "%REMOTE-F-OPENFAIL, unable to open local link"
$ goto exit
$!
$local_write_fail:
$ write sys$output "%REMOTE-F-WRITEFAIL, unable to write local link"
$ goto exit
$!
$local_read_fail:
$ write sys$output "%REMOTE-F-READFAIL, unable to read local link"
$ goto exit
$!
$remote_open_fail:
$ write sys$net "%REMOTE-F-OPENFAIL, unable to open remote link"
$ goto exit
$!
$remote_read_fail:
$ write net "%REMOTE-F-READFAIL, unable to read from remote link"
$ goto exit
$!
$no_net_request:
$ write net "%REMOTE-F-NOREQUEST, no request received"
$ goto exit
$!
$abort:
$ deassign sys$output
$ if f$search("temp.file") .eqs. "" then goto exit
$ set noon
$ open/read temp temp.file
$ read temp data
$ write net data
$ close net
$ read temp data
$ close temp
$ goto exit
$!
$!	Procedure exit
$!
$exit:
$ if f$trnlnm("net") .nes. "" then close net
$ if f$trnlnm("temp") .nes. "" then close temp
$ if f$search("temp.file") .nes. "" then delete/nolog temp.file;*
$ verify_state = f$verify(verify_state)
$ exit
