C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C	
C	NAME --  AGN_EXT
C
C       PURPOSE -- 
C
C	  Character*(*) functions used to extract information
C	  from AUTOGEN file records (currently MODPARAMS.DAT)        
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  An attempt is made here to be able to locate and decode our
C	  private records in MODPARAMS.DAT even after they have been
C	  (slightly) edited by the end-user.
C	  Our ATTCAGN specific records in MODPARAMS.DAT use a format:
C
C	  ![typ_]parameter = value  !%ATTCAGN #product#disabled#device#cputyp#
C          \
C	    disabled flag (exclamation point) or space(s)
C
C	  Our decoding tries to be based on kyword ATTCAGN presence,
C	  and item-list delimiters "#".
C
C       NOTES -- 
C
C	  After switch to VMSPARAMS.DAT, this module will be replaced
C	  by simple statement functions extracting fixed-length fields
C	  from VMSPARAMS.DAT record offsets.
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C  START OF EXECUTABLE CODE --
C                              
C	====================================================================
 	Character*(*) Function AGN_EXT_PRODUCT(rec)
C
C	Extract PRODUCT name
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mpro) AGN_EXT_element        ! Element Function
C
	if (index(rec,'ATTCAGN').eq.0) then    ! Not an ATTC AGN line
	    AGN_EXT_product=' '			! => item not found
	else
	    AGN_EXT_product=AGN_EXT_element(EPRO,'#',rec) !Get product string
	    if (AGN_EXT_product(1:1) .eq. '#') 	! delimiter returned
     $	        AGN_EXT_product = ' '		! => record damaged
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_PARAM (rec)
C
C	Extract PARAMETER name
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mpar) AGN_EXT_element        ! Element Function
C
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_param=' '			! => item not found
	else
	  if (rec(2:5).eq.'MIN_' 	   	! Any of valid prefixes
     $	  .or.rec(2:5).eq.'MAX_' 		! present
     $	  .or.rec(2:5).eq.'ADD_' ) then   	! => parameter starts at 6
	    AGN_EXT_param=AGN_EXT_element(0,'=',rec(6:)) !Get param string
	    if (AGN_EXT_param(1:1) .eq. '=') 	! delimiter returned
     $	        AGN_EXT_param = ' '		! => record damaged
          else					! No Prefix (MIN_) present
	    AGN_EXT_param=AGN_EXT_element(0,'=',rec(2:)) !Get param string
	    if (AGN_EXT_param(1:1) .eq. '=') 	! delimiter returned
     $	        AGN_EXT_param = ' '		! => record damaged
	  end if
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_TYPE (rec)
C
C	Extract  Parameter TYPE
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mtyp) AGN_EXT_element        ! Element Function
C
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_type=' '			! => item not found
	else
	  AGN_EXT_type='VAL'			! Assume VALUE  type
	  if (rec(2:5).eq.'MIN_') AGN_EXT_type='MIN'
     	  if (rec(2:5).eq.'MAX_') AGN_EXT_type='MAX'
	  if (rec(2:5).eq.'ADD_') AGN_EXT_type='ADD'
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_CPUTYP (rec)      
C
C	Extract CPU type 
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mcpu) AGN_EXT_element        ! Element Function
C
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_cputyp=' '			! => item not found
	else
	    AGN_EXT_cputyp=AGN_EXT_element(ECPU,'#',rec) !Get cputyp string
	    if (AGN_EXT_cputyp(1:1) .eq. '#') 	! delimiter returned
     $	        AGN_EXT_cputyp = ' '		! => record damaged
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_VALUE (rec)
C	
C	Extract parameter VALUE string
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mrec) AGN_EXT_element        ! Element Function
	Character*(mrec) wrk	    		! Working storage
	Integer		 l			! wrk length
C
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_value=' '			! => item not found
	else
	    wrk=AGN_EXT_element(1,'=',rec) 	! Get string past "=" sign
	    if (wrk(1:1) .eq. '=') then		! delimiter returned
     	       AGN_EXT_value = ' '		! => record damaged
	       Return				! done here
	    end if				!
	    l = index(wrk,'!')                  ! Get length up to "!"
	    if (l.eq.0) then   			! not found=invalid rec
     	       AGN_EXT_value = ' '		! => record damaged
	    else	    
               Call AGN_EXT_LJUST(wrk(:l-1),wrk(:l)) ! Justify left, uncomment
	       AGN_EXT_value = AGN_EXT_element(0,' ',wrk(:l)) ! extract value
	    end if
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_DISABLED(rec)
C                     
C	Extract DISABLED FLAG 
C
C	For MODPARAMS.DAT records we only check presence of our DISABLED
C	field, actual flag value is derived from comment (!) presence.
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mdis) AGN_EXT_element        ! Element Function
C
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_disabled=' '		! => item not found
	else
	    AGN_EXT_disabled=AGN_EXT_element(EDIS,'#',rec) !Get disabled string
	    if (AGN_EXT_disabled(1:1) .eq. '#') ! delimiter returned
     $	        AGN_EXT_disabled = ' '		! => record damaged
	    if (rec(1:1).eq.'!') AGN_EXT_disabled = '1'
	    if (rec(1:1).ne.'!') AGN_EXT_disabled = '0'
	end if
	Return
	End
C
C	====================================================================
	Character*(*) Function AGN_EXT_DEVICE (rec)
C
C	Extract DEVICE name
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! Field sizes
	Character*(mrec) rec			! Input data record
	Character*(mdev) AGN_EXT_element        ! Element Function
C                                 
	if (index(rec,'ATTCAGN').eq.0) then     ! Not an ATTC AGN line
	    AGN_EXT_device=' '			! => item not found
	else
	    AGN_EXT_device=AGN_EXT_element(EDEV,'#',rec) !Get device string
	    if (AGN_EXT_device(1:1) .eq. '#') 	! delimiter returned
     $	        AGN_EXT_device = ' '		! => record damaged
	end if
	Return
	End
C
C	====================================================================
	Character*(*)    Function AGN_EXT_element  (elnum,delim,rec)
C       
C	Function to extract a numbered element (similar to DCL f$element)
C	The only difference is we return blank-padded string to the caller
C	
	IMPLICIT	NONE	! Force ALL declared
C
	Integer*4	elnum	! element number, first element =  0
	Character*(*)	delim	! delimiter string
	Character*(*)	rec	! input record
C
	Integer		iel	! loop variable (elements)
	Integer		ista	! substring delimiter
	Integer		iend	! substring delimiter
	Integer		ldel	! delimiter length
	Integer		lrec	! record length
	Logical		curd	! delimiter found for current element
	Logical		prvd	! delimiter found for previous element
C
        ldel=len(delim)	                                              
        lrec=len(rec)
	ista=1      
	curd =.false.				! no delimiter found yet
	do iel = 0 , elnum
	   prvd=curd				! save prvious delimiter found
	   curd=.false.				! and assume we did not found
	   if (prvd)ista=iend+ldel 		! skip over previous delimiter
	   if (ista.le.lrec) then		! are we within input record
	      iend = index(rec(ista:),delim)	! = find delimiter
	      if (iend.ne.0) then		! Delimiter found
	          curd = .true.			! => remember it
	          iend=ista+iend-1		! iend = abs delimiter position
	      end if ! delim found
	   end if ! within record 
	end do
C
	if (curd) then	 	 		! trailing delimiter found
	   if (iend.gt.ista) then          	! for non-empty element
	      AGN_EXT_element=rec(ista:iend-1)	! => extract element
	   else                            	! ortherwise
	      AGN_EXT_element=' '		! => return space
	   end if				!          
	else					! delimiter not found
	   if (.not.prvd) then			! No delimiter in prev element
	       AGN_EXT_element = delim		! => return  delimiter
           else					! behind  previous delimiter
	       if (ista.lt.lrec) then		! and within a line
	          AGN_EXT_element = rec(ista:)	! => return rest of record
	       else  				! beyond line end
	          AGN_EXT_element=' '		! => return space
               end if                           ! 
	   end if                               ! 
	end if	                                !
	Return
	END
C
C
C	====================================================================
	Subroutine AGN_EXT_LJUST (inp,out)
C
C	Justify record left, convert special char. to blanks,
C	fold to uppercase (later eventually un-tab)
C                               
	IMPLICIT	NONE			! Force ALL declared
C
 	Character*(*) 	inp,out			! Arguments
	Integer*4	i,j			! Loop variable
C
	Call STR$UPCASE(inp,inp)    
	j=0					! Init output position
	Do i = 1, len(inp)			! Process the whole line
	  if (inp(i:i).lt.' ')inp(i:i) = ' '   	! Replace spec chars    
	  if (inp(i:i).eq.' ' .and. j.eq.0) then! If leading blank
	     continue				! Skip leading blanks
	  else                                  !
	     j=j+1                              ! Bump output counter
	     out(j:j)=inp(i:i)			! and load character
	  end if
	end do
	Do i = j+1, len(out)
	     out(i:i)=' '			! Fill trailing zeroes
	end do
	Return
	END
	                   

                          
