	SUBROUTINE AGN_GET()
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- AGN_GET 
C
C       PURPOSE -- Subroutines to get VMS CLI command line items for AGN
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  Module uses VMS CLI$ facility to process AGN commands.
C	  For command definitions, see AGN_TABLE.CLD definition.
C
C       NOTES --
C
C	  AGN_TABLE should be linked with the AGN image.
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
	IMPLICIT	NONE			! Force ALL declared
	Include		'AGN_PAR/NoList'	! AGN  parameters
	Include		'AGN_FNC/NoList'	! AGN  functions (declared)
C
C	Arguments:
	CHARACTER*(*)	FILSTR,PROSTR,DEVSTR,PARSTR,TYPSTR,VALSTR,CPUSTR
	INTEGER*4	LFIL,NUMBER,LEN
	LOGICAL*4	PRO,DEV,PAR,TYP,VAL,CPU, ALL,REB
C             
C	Local:
	INTEGER*4	IST 
	EXTERNAL	CLI$_ABSENT,CLI$_PRESENT,CLI$_NEGATED
	INTEGER		CLI$GET_VALUE
	LOGICAL		CLI$PRESENT
C
C START OF EXECUTABLE CODE --
C
	ENTRY	AGN_GET_FILE(LFIL,FILSTR)	! Get filename from USE cmd
	
	IF (CLI$PRESENT('FILE')) then
	   IST=CLI$GET_VALUE('FILE',FILSTR,LFIL)
	ELSE
	   FILSTR='MODPARAMS'
	   LFIL=9                
	END IF    
	RETURN                   
C
	ENTRY	AGN_GET_PRODUCT(PRO,PROSTR)	! Get /Product=name
	PRO=.false.    
	PROSTR=' '
	IF (CLI$PRESENT('PRODUCT')) then
	   IST=CLI$GET_VALUE('PRODUCT',PROSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) PRO=.true.
	END IF                                                             
	RETURN
C
	ENTRY	AGN_GET_DEVICE(DEV,DEVSTR)	! Get /Device=name
	DEV=.false.
	DEVSTR=' '
	IF (CLI$PRESENT('DEVICE')) then
	   IST=CLI$GET_VALUE('DEVICE',DEVSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) DEV=.true.
	END IF
	RETURN
C
	ENTRY	AGN_GET_PARAMETER(PAR,PARSTR)	! Get /Parameter=name
	PAR=.false.
	PARSTR=' '
	IF (CLI$PRESENT('PARAMETER')) then
	   IST=CLI$GET_VALUE('PARAMETER',PARSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) PAR=.true.
	END IF
	RETURN
C
	ENTRY	AGN_GET_ALL(ALL)		! Check /ALL qualifier presence
	ALL=CLI$PRESENT('ALL')
	RETURN
C
	ENTRY	AGN_GET_REBOOT(REB)		! Check /REBOOT state
	REB=.true.					! REBOOT is default
	IST=CLI$PRESENT('REBOOT')
	if (IST.eq.%loc(CLI$_NEGATED)) REB=.false.	! /NOREBOOT used
	RETURN
C
	ENTRY	AGN_GET_TYPE(TYP,TYPSTR)	! Get /Type=keyword
	TYP=.false.
	TYPSTR=' '
	IF (CLI$PRESENT('TYPE')) then
	   IST=CLI$GET_VALUE('TYPE',TYPSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) TYP=.true.
	END IF
	RETURN
C
	ENTRY	AGN_GET_VALUE(VAL,VALSTR)	! Get /Value=nnnn string
	VAL=.false.
	VALSTR=' '
	IF (CLI$PRESENT('VALUE')) then
	   IST=CLI$GET_VALUE('VALUE',VALSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) VAL=.true.
	END IF
	RETURN
C
	ENTRY	AGN_GET_CPU(CPU,CPUSTR)		! Get /CPU=nnn string
	CPU=.false.
	CPUSTR=' '
	IF (CLI$PRESENT('CPU')) then
	   IST=CLI$GET_VALUE('CPU',CPUSTR)
	   IF (IST.NE.%loc(CLI$_ABSENT)) CPU=.true.
	END IF
	RETURN
C
	END
