	INTEGER*4 FUNCTION AGN_HAN (SIGNAL, MECH)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- AGN_HAN
C
C       PURPOSE -- 
C
C	  ATTC AGN exception handler
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  The ATTC AGN utility uses exception handling to signall any
C	  messages to user.
C	  The exception handling is also used to transfer  control back
C	  to main loop (on any anticipated error). Thus, any CLI$ or AGN$
C	  generated ERROR (severe error) signals cause stack UNWIND
C	  back to handler establisher = root dispatch loop.
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
C ARGUMENTS --
C
	INTEGER  SIGNAL(*)
        INTEGER  MECH  (*)
C
C LOCAL VARIABLES --
C
	Integer*4	FAC	! Extracted message facility code
	EXTERNAL SS$_CONTINUE	!
	EXTERNAL SS$_RESIGNAL	! handler exit status values
	EXTERNAL SS$_NORMAL	! used here
	EXTERNAL SS$_UNWIND	!      
	EXTERNAL CLI$_FACILITY 	!
	EXTERNAL ATTCAGN$_FACILITY	!
C
C START OF EXECUTABLE CODE --
C
C 	 Handler called during stack-unwind. We just dismiss the call
C
	IF (SIGNAL(2) .EQ. %LOC(SS$_UNWIND)) then
 	    QERHAN = %LOC(SS$_NORMAL)		! Just to make sure
	    RETURN				! dismiss immediatelly
	END IF
C
	if (SIGNAL(2).or.iand(SIGNAL(2),6).eq.0) GoTo 300 ! Not ERR=cont.
C
C	Get the facility number and check if we can handle this error
C	Any errors other than CLI and AGN are passed to system handler   
	FAC  = SIGNAL(2)/'10000'X 		! get facility code and
	FAC  = iand  (FAC,'7FFF'X)		! mask out cntl bits
	if (FAC.eq.%loc(CLI$_FACILITY) .or.     ! We handle all our errors
     $	    FAC.eq.%loc(ATTCAGN$_FACILITY))GoTo 300	! 
	AGN_HAN = %loc(SS$_RESIGNAL)		! Resignal other  errors
	Return					! to system handler
C
C	Output the related message using $PUTMSG, (it may be either some
C	warning or information, or AGN/CLI error:	
 300	SIGNAL(1) = SIGNAL(1)-2			! Remove PC,PSL from count
	Call	SYS$PUTMSG(SIGNAL(1))		! Output message
	if (SIGNAL(2).or.iand(SIGNAL(2),6).eq.0) then	! On non-error MSGs
	   AGN_HAN = %loc(SS$_CONTINUE)		! allow continuation
	   Return                                                         
	end if
C       
C	On AGN/CLI error  we unwind the stack back to AGN_ROOT, thus
C	cancelling current operation and requesting another one.
C  	Unwind call stack - this should be the last thing to do
	Call SYS$UNWIND (MECH(3),)		! UNWIND TO AGN_ROOT
	AGN_HAN = %LOC(SS$_CONTINUE)		! After $UNWIND the
	Return					! status should not matter
	END
