	SUBROUTINE AGN_PRM(NAME,IDENT,ITYP)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- AGN_PRM
C
C       PURPOSE -- 
C
C	  Subroutine finds a parameter in our parameter list, and returns
C	  parameter numeric identifier  (for sys$getsyi) along with parameter
C	  type (for special parameters). Type of 0 means "unknown parameter"
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  This module will depend on VMS release level used. We hope that
C	  $GETSYI item identifiers will not change with release. However,
C	  there will be new items.
C	  For ATTCAGN 0101, we introduce special parameters to inquire:
C	      GBLPAGES_FREE, GBLSECTIONS_FREE.
C	  Those should appear in future VMS release(s). Currently, we call
C	  then "special" and have a very special code in AGN_VMS to inquire
C	  those values.
C
C       NOTES --
C
C	  Character string VMS parameters  handling is coded here, but we
C	  DO NOT use it, since AGN CLI command handling requires DECIMAL
C	  values for any /VALUE qualifier.
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
C
	IMPLICIT	NONE
	Integer		VMSPAR,SPCPAR
	Parameter	(VMSPAR = 262)		! 262 VMS 4.4 parameters
	Parameter	(SPCPAR = 2)		! 2 special paramaters  
C
	CHARACTER*(*)	NAME			! Parameter name
	INTEGER*4	IDENT			! Item ident for $GETSYI
	INTEGER*4	ITYP			! Par type 1=INTEGER, 2=STRING
C
	CHARACTER*16	PARNAM(VMSPAR+SPCPAR)
	INTEGER*4	PARID (VMSPAR+SPCPAR)
	INTEGER*4	ipar			! Found parameter index
	INTEGER*4	naml			! parameter name length
	INTEGER*4	nfound			! match count for par. search
	INTEGER*4	I			! 
	INCLUDE		'AGN_ERR/NoList'	! AGN error messages
	INCLUDE		'($SYIDEF)/NOLIST'
C
C	BASIC system parameters  as of VMS 4.4 (parameter names) (1-262)
	DATA PARNAM(1)		/'ACP_BASEPRIO    '/
	DATA PARNAM(2)		/'ACP_DATACHECK   '/
	DATA PARNAM(3)		/'ACP_DINDXCACHE  '/
	DATA PARNAM(4)		/'ACP_DIRCACHE    '/
	DATA PARNAM(5)		/'ACP_EXTCACHE    '/
	DATA PARNAM(6)		/'ACP_EXTLIMIT    '/
	DATA PARNAM(7)		/'ACP_FIDCACHE    '/
	DATA PARNAM(8)		/'ACP_HDRCACHE    '/
	DATA PARNAM(9)		/'ACP_MAPCACHE    '/
	DATA PARNAM(10)		/'ACP_MAXREAD     '/
	DATA PARNAM(11)		/'ACP_MULTIPLE    '/
	DATA PARNAM(12)		/'ACP_QUOCACHE    '/
	DATA PARNAM(13)		/'ACP_REBLDSYSD   '/
	DATA PARNAM(14)		/'ACP_SHARE       '/
	DATA PARNAM(15)		/'ACP_SWAPFLGS    '/
	DATA PARNAM(16)		/'ACP_SYSACC      '/
	DATA PARNAM(17)		/'ACP_WINDOW      '/
	DATA PARNAM(18)		/'ACP_WORKSET     '/
	DATA PARNAM(19)		/'ACP_WRITEBACK   '/
	DATA PARNAM(20)		/'ACP_XQP_RES     '/
	DATA PARNAM(21)		/'ALLOCLASS       '/
	DATA PARNAM(22)		/'AWSMIN          '/
	DATA PARNAM(23)		/'AWSTIME         '/
	DATA PARNAM(24)		/'BALSETCNT       '/
	DATA PARNAM(25)		/'BJOBLIM         '/
	DATA PARNAM(26)		/'BORROWLIM       '/
	DATA PARNAM(27)		/'BUGCHECKFATAL   '/
	DATA PARNAM(28)		/'BUGREBOOT       '/
	DATA PARNAM(29)		/'CHANNELCNT      '/
	DATA PARNAM(30)		/'CJFLOAD         '/
	DATA PARNAM(31)		/'CJFSYSRUJ       '/
	DATA PARNAM(32)		/'CLASS_PROT      '/
	DATA PARNAM(33)		/'CLISYMTBL       '/
	DATA PARNAM(34)		/'CONCEAL_DEVICES '/
	DATA PARNAM(35)		/'CRDENABLE       '/
	DATA PARNAM(36)		/'CTLIMGLIM       '/
	DATA PARNAM(37)		/'CTLPAGES        '/
	DATA PARNAM(38)		/'DEADLOCK_WAIT   '/
	DATA PARNAM(39)		/'DEFMBXBUFQUO    '/
	DATA PARNAM(40)		/'DEFMBXMXMSG     '/
	DATA PARNAM(41)		/'DEFMBXNUMMSG    '/
	DATA PARNAM(42)		/'DEFPRI          '/
	DATA PARNAM(43)		/'DEFQUEPRI       '/
	DATA PARNAM(44)		/'DISK_QUORUM     '/
	DATA PARNAM(45)		/'DISMOUMSG       '/
	DATA PARNAM(46)		/'DLCKEXTRASTK    '/
	DATA PARNAM(47)		/'DORMANTWAIT     '/
	DATA PARNAM(48)		/'DUMPBUG         '/
	DATA PARNAM(49)		/'EXTRACPU        '/
	DATA PARNAM(50)		/'EXUSRSTK        '/
	DATA PARNAM(51)		/'FREEGOAL        '/
	DATA PARNAM(52)		/'FREELIM         '/
	DATA PARNAM(53)		/'GBLPAGES        '/
	DATA PARNAM(54)		/'GBLPAGFIL       '/
	DATA PARNAM(55)		/'GBLSECTIONS     '/
	DATA PARNAM(56)		/'GROWLIM         '/
	DATA PARNAM(57)		/'IJOBLIM         '/
	DATA PARNAM(58)		/'IMGIOCNT        '/
	DATA PARNAM(59)		/'INTSTKPAGES     '/
	DATA PARNAM(60)		/'IOTA            '/
	DATA PARNAM(61)		/'IRPCOUNT        '/
	DATA PARNAM(62)		/'IRPCOUNTV       '/
	DATA PARNAM(63)		/'KFILSTCNT       '/
	DATA PARNAM(64)		/'LAMAPREGS       '/
	DATA PARNAM(65)		/'LGI_BRK_DISUSER '/
	DATA PARNAM(66)		/'LGI_BRK_LIM     '/
	DATA PARNAM(67)		/'LGI_BRK_TERM    '/
	DATA PARNAM(68)		/'LGI_BRK_TMO     '/
	DATA PARNAM(69)		/'LGI_HID_TIM     '/
	DATA PARNAM(70)		/'LGI_PWD_TMO     '/
	DATA PARNAM(71)		/'LGI_RETRY_LIM   '/
	DATA PARNAM(72)		/'LGI_RETRY_TMO   '/
	DATA PARNAM(73)		/'LNMPHASHTBL     '/
	DATA PARNAM(74)		/'LNMSHASHTBL     '/
	DATA PARNAM(75)		/'LOADCHKPRT      '/
	DATA PARNAM(76)		/'LOADERAPT       '/
	DATA PARNAM(77)		/'LOADMTACCESS    '/
	DATA PARNAM(78)		/'LOCKDIRWT       '/
	DATA PARNAM(79)		/'LOCKIDTBL       '/
	DATA PARNAM(80)		/'LOCKIDTBL_MAX   '/
	DATA PARNAM(81)		/'LOCKRETRY       '/
	DATA PARNAM(82)		/'LONGWAIT        '/
	DATA PARNAM(83)		/'LRPCOUNT        '/
	DATA PARNAM(84)		/'LRPCOUNTV       '/
	DATA PARNAM(85)		/'LRPMIN          '/
	DATA PARNAM(86)		/'LRPSIZE         '/
	DATA PARNAM(87)		/'MAXBUF          '/
	DATA PARNAM(88)		/'MAXPROCESSCNT   '/
	DATA PARNAM(89)		/'MAXQUEPRI       '/
	DATA PARNAM(90)		/'MAXSYSGROUP     '/
	DATA PARNAM(91)		/'MINWSCNT        '/
	DATA PARNAM(92)		/'MOUNTMSG        '/
	DATA PARNAM(93)		/'MPW_HILIMIT     '/
	DATA PARNAM(94)		/'MPW_LOLIMIT     '/
	DATA PARNAM(95)		/'MPW_PRIO        '/
	DATA PARNAM(96)		/'MPW_THRESH      '/
	DATA PARNAM(97)		/'MPW_WAITLIMIT   '/
	DATA PARNAM(98)		/'MPW_WRTCLUSTER  '/
	DATA PARNAM(99)		/'MVTIMEOUT       '/
	DATA PARNAM(100)	/'NJOBLIM         '/
	DATA PARNAM(101)	/'NOAUTOCONFIG    '/
	DATA PARNAM(102)	/'NOCLOCK         '/
	DATA PARNAM(103)	/'NOCLUSTER       '/
	DATA PARNAM(104)	/'NPAGEDYN        '/
	DATA PARNAM(105)	/'NPAGEVIR        '/
	DATA PARNAM(106)	/'PAGEDYN         '/
	DATA PARNAM(107)	/'PAGFILCNT       '/
	DATA PARNAM(108)	/'PAGTBLPFC       '/
	DATA PARNAM(109)	/'PAMAXPORT       '/
	DATA PARNAM(110)	/'PANOPOLL        '/
	DATA PARNAM(111)	/'PANUMPOLL       '/
	DATA PARNAM(112)	/'PAPOLLINTERVAL  '/
	DATA PARNAM(113)	/'PAPOOLINTERVAL  '/
	DATA PARNAM(114)	/'PASANITY        '/
	DATA PARNAM(115)	/'PASTDGBUF       '/
	DATA PARNAM(116)	/'PASTIMOUT       '/
	DATA PARNAM(117)	/'PE1             '/
	DATA PARNAM(118)	/'PE2             '/
	DATA PARNAM(119)	/'PE3             '/
	DATA PARNAM(120)	/'PE4             '/
	DATA PARNAM(121)	/'PE5             '/
	DATA PARNAM(122)	/'PE6             '/
	DATA PARNAM(123)	/'PFCDEFAULT      '/
	DATA PARNAM(124)	/'PFRATH          '/
	DATA PARNAM(125)	/'PFRATL          '/
	DATA PARNAM(126)	/'PFRATS          '/
	DATA PARNAM(127)	/'PHYSICALPAGES   '/
	DATA PARNAM(128)	/'PIOPAGES        '/
	DATA PARNAM(129)	/'PIXSCAN         '/
	DATA PARNAM(130)	/'POOLPAGING      '/
	DATA PARNAM(131)	/'PQL_DASTLM      '/
	DATA PARNAM(132)	/'PQL_DBIOLM      '/
	DATA PARNAM(133)	/'PQL_DBYTLM      '/
	DATA PARNAM(134)	/'PQL_DCPULM      '/
	DATA PARNAM(135)	/'PQL_DDIOLM      '/
	DATA PARNAM(136)	/'PQL_DENQLM      '/
	DATA PARNAM(137)	/'PQL_DFILLM      '/
	DATA PARNAM(138)	/'PQL_DJTQUOTA    '/
	DATA PARNAM(139)	/'PQL_DPGFLQUOTA  '/
	DATA PARNAM(140)	/'PQL_DPRCLM      '/
	DATA PARNAM(141)	/'PQL_DTQELM      '/
	DATA PARNAM(142)	/'PQL_DWSDEFAULT  '/
	DATA PARNAM(143)	/'PQL_DWSEXTENT   '/
	DATA PARNAM(144)	/'PQL_DWSQUOTA    '/
	DATA PARNAM(145)	/'PQL_MASTLM      '/
	DATA PARNAM(146)	/'PQL_MBIOLM      '/
	DATA PARNAM(147)	/'PQL_MBYTLM      '/
	DATA PARNAM(148)	/'PQL_MCPULM      '/
	DATA PARNAM(149)	/'PQL_MDIOLM      '/
	DATA PARNAM(150)	/'PQL_MENQLM      '/
	DATA PARNAM(151)	/'PQL_MFILLM      '/
	DATA PARNAM(152)	/'PQL_MJTQUOTA    '/
	DATA PARNAM(153)	/'PQL_MPGFLQUOTA  '/
	DATA PARNAM(154)	/'PQL_MPRCLM      '/
	DATA PARNAM(155)	/'PQL_MTQELM      '/
	DATA PARNAM(156)	/'PQL_MWSDEFAULT  '/
	DATA PARNAM(157)	/'PQL_MWSEXTENT   '/
	DATA PARNAM(158)	/'PQL_MWSQUOTA    '/
	DATA PARNAM(159)	/'PRCPOLINTERVAL  '/
	DATA PARNAM(160)	/'PROCSECTCNT     '/
	DATA PARNAM(161)	/'QDSKINTERVAL    '/
	DATA PARNAM(162)	/'QDSKVOTES       '/
	DATA PARNAM(163)	/'QUANTUM         '/
	DATA PARNAM(164)	/'QUORUM          '/
	DATA PARNAM(165)	/'REALTIME_SPTS   '/
	DATA PARNAM(166)	/'RECNXINTERVAL   '/
	DATA PARNAM(167)	/'RESALLOC        '/
	DATA PARNAM(168)	/'RESHASHTBL      '/
	DATA PARNAM(169)	/'RJOBLIM         '/
	DATA PARNAM(170)	/'RMS_DFMBC       '/
	DATA PARNAM(171)	/'RMS_DFMBFHSH    '/
	DATA PARNAM(172)	/'RMS_DFMBFIDX    '/
	DATA PARNAM(173)	/'RMS_DFMBFREL    '/
	DATA PARNAM(174)	/'RMS_DFMBFSDK    '/
	DATA PARNAM(175)	/'RMS_DFMBFSMT    '/
	DATA PARNAM(176)	/'RMS_DFMBFSUR    '/
	DATA PARNAM(177)	/'RMS_DFNBC       '/
	DATA PARNAM(178)	/'RMS_EXTEND_SIZE '/
	DATA PARNAM(179)	/'RMS_FILEPROT    '/
	DATA PARNAM(180)	/'RMS_GBLBUFQUO   '/
	DATA PARNAM(181)	/'RMS_PROLOGUE    '/
	DATA PARNAM(182)	/'SAVEDUMP        '/
	DATA PARNAM(183)	/'SBIERRENABLE    '/
	DATA PARNAM(184)	/'SCSBUFFCNT      '/
	DATA PARNAM(185)	/'SCSCONNCNT      '/
	DATA PARNAM(186)	/'SCSFLOWCUSH     '/
	DATA PARNAM(187)	/'SCSMAXDG        '/
	DATA PARNAM(188)	/'SCSMAXMSG       '/
	DATA PARNAM(189)	/'SCSNODE         '/
	DATA PARNAM(190)	/'SCSRESPCNT      '/
	DATA PARNAM(191)	/'SCSSYSTEMID     '/
	DATA PARNAM(192)	/'SCSSYSTEMIDH    '/
	DATA PARNAM(193)	/'SETTIME         '/
	DATA PARNAM(194)	/'SPTREQ          '/
	DATA PARNAM(195)	/'SRPCOUNT        '/
	DATA PARNAM(196)	/'SRPCOUNTV       '/
	DATA PARNAM(197)	/'SRPMIN          '/
	DATA PARNAM(198)	/'SRPSIZE         '/
	DATA PARNAM(199)	/'SSINHIBIT       '/
	DATA PARNAM(200)	/'STARTUP_P1      '/
	DATA PARNAM(201)	/'STARTUP_P2      '/
	DATA PARNAM(202)	/'STARTUP_P3      '/
	DATA PARNAM(203)	/'STARTUP_P4      '/
	DATA PARNAM(204)	/'STARTUP_P5      '/
	DATA PARNAM(205)	/'STARTUP_P6      '/
	DATA PARNAM(206)	/'STARTUP_P7      '/
	DATA PARNAM(207)	/'STARTUP_P8      '/
	DATA PARNAM(208)	/'SWPALLOCINC     '/
	DATA PARNAM(209)	/'SWPFAIL         '/
	DATA PARNAM(210)	/'SWPFILCNT       '/
	DATA PARNAM(211)	/'SWPOUTPGCNT     '/
	DATA PARNAM(212)	/'SWPRATE         '/
	DATA PARNAM(213)	/'SWP_PRIO        '/
	DATA PARNAM(214)	/'SYSMWCNT        '/
	DATA PARNAM(215)	/'SYSPAGING       '/
	DATA PARNAM(216)	/'SYSPFC          '/
	DATA PARNAM(217)	/'TAILORED        '/
	DATA PARNAM(218)	/'TBSKIPWSL       '/
	DATA PARNAM(219)	/'TIMEPROMPTWAIT  '/
	DATA PARNAM(220)	/'TTY_ALTALARM    '/
	DATA PARNAM(221)	/'TTY_ALTYPAHD    '/
	DATA PARNAM(222)	/'TTY_AUTOCHAR    '/
	DATA PARNAM(223)	/'TTY_BUF         '/
	DATA PARNAM(224)	/'TTY_CLASSNAME   '/
	DATA PARNAM(225)	/'TTY_DEFCHAR     '/
	DATA PARNAM(226)	/'TTY_DEFCHAR2    '/
	DATA PARNAM(227)	/'TTY_DEFPORT     '/
	DATA PARNAM(228)	/'TTY_DIALTYPE    '/
	DATA PARNAM(229)	/'TTY_DMASIZE     '/
	DATA PARNAM(230)	/'TTY_OWNER       '/
	DATA PARNAM(231)	/'TTY_PARITY      '/
	DATA PARNAM(232)	/'TTY_PROT        '/
	DATA PARNAM(233)	/'TTY_RSPEED      '/
	DATA PARNAM(234)	/'TTY_SCANDELTA   '/
	DATA PARNAM(235)	/'TTY_SILOTIME    '/
	DATA PARNAM(236)	/'TTY_SPEED       '/
	DATA PARNAM(237)	/'TTY_TIMEOUT     '/
	DATA PARNAM(238)	/'TTY_TYPAHDSZ    '/
	DATA PARNAM(239)	/'UAFALTERNATE    '/
	DATA PARNAM(240)	/'UDABURSTRATE    '/
	DATA PARNAM(241)	/'USER3           '/
	DATA PARNAM(242)	/'USER4           '/
	DATA PARNAM(243)	/'USERD1          '/
	DATA PARNAM(244)	/'USERD2          '/
	DATA PARNAM(245)	/'VAXCLUSTER      '/
	DATA PARNAM(246)	/'VIRTUALPAGECNT  '/
	DATA PARNAM(247)	/'VMS5            '/
	DATA PARNAM(248)	/'VMS6            '/
	DATA PARNAM(249)	/'VMS7            '/
	DATA PARNAM(250)	/'VMS8            '/
	DATA PARNAM(251)	/'VMSD1           '/
	DATA PARNAM(252)	/'VMSD2           '/
	DATA PARNAM(253)	/'VMSD3           '/
	DATA PARNAM(254)	/'VMSD4           '/
	DATA PARNAM(255)	/'VOTES           '/
	DATA PARNAM(256)	/'WRITABLESYS     '/
	DATA PARNAM(257)	/'WRITESYSPARAMS  '/
	DATA PARNAM(258)	/'WSDEC           '/
	DATA PARNAM(259)	/'WSINC           '/
	DATA PARNAM(260)	/'WSMAX           '/
	DATA PARNAM(261)	/'WS_OPA0         '/
	DATA PARNAM(262)	/'XFMAXRATE       '/
C	Special parameters (should be available via GETSYI later)
	DATA PARNAM(263)	/'GBLPAGES_FREE   '/
	DATA PARNAM(264)	/'GBLSECTIONS_FREE'/

C
C	SYS$GETSYI parameter identifiers
C
	DATA PARID(1)	/SYI$_ACP_BASEPRIO    /
	DATA PARID(2)	/SYI$_ACP_DATACHECK   /
	DATA PARID(3)	/SYI$_ACP_DINDXCACHE  /
	DATA PARID(4)	/SYI$_ACP_DIRCACHE    /
	DATA PARID(5)	/SYI$_ACP_EXTCACHE    /
	DATA PARID(6)	/SYI$_ACP_EXTLIMIT    /
	DATA PARID(7)	/SYI$_ACP_FIDCACHE    /
	DATA PARID(8)	/SYI$_ACP_HDRCACHE    /
	DATA PARID(9)	/SYI$_ACP_MAPCACHE    /
	DATA PARID(10)	/SYI$_ACP_MAXREAD     /
	DATA PARID(11)	/SYI$_ACP_MULTIPLE    /
	DATA PARID(12)	/SYI$_ACP_QUOCACHE    /
	DATA PARID(13)	/SYI$_ACP_REBLDSYSD   /
	DATA PARID(14)	/SYI$_ACP_SHARE       /
	DATA PARID(15)	/SYI$_ACP_SWAPFLGS    /
	DATA PARID(16)	/SYI$_ACP_SYSACC      /
	DATA PARID(17)	/SYI$_ACP_WINDOW      /
	DATA PARID(18)	/SYI$_ACP_WORKSET     /
	DATA PARID(19)	/SYI$_ACP_WRITEBACK   /
	DATA PARID(20)	/SYI$_ACP_XQP_RES     /
	DATA PARID(21)	/SYI$_ALLOCLASS       /
	DATA PARID(22)	/SYI$_AWSMIN          /
	DATA PARID(23)	/SYI$_AWSTIME         /
	DATA PARID(24)	/SYI$_BALSETCNT       /
	DATA PARID(25)	/SYI$_BJOBLIM         /
	DATA PARID(26)	/SYI$_BORROWLIM       /
	DATA PARID(27)	/SYI$_BUGCHECKFATAL   /
	DATA PARID(28)	/SYI$_BUGREBOOT       /
	DATA PARID(29)	/SYI$_CHANNELCNT      /
	DATA PARID(30)	/SYI$_CJFLOAD         /
	DATA PARID(31)	/SYI$_CJFSYSRUJ       /
	DATA PARID(32)	/SYI$_CLASS_PROT      /
	DATA PARID(33)	/SYI$_CLISYMTBL       /
	DATA PARID(34)	/SYI$_CONCEAL_DEVICES /
	DATA PARID(35)	/SYI$_CRDENABLE       /
	DATA PARID(36)	/SYI$_CTLIMGLIM       /
	DATA PARID(37)	/SYI$_CTLPAGES        /
	DATA PARID(38)	/SYI$_DEADLOCK_WAIT   /
	DATA PARID(39)	/SYI$_DEFMBXBUFQUO    /
	DATA PARID(40)	/SYI$_DEFMBXMXMSG     /
	DATA PARID(41)	/SYI$_DEFMBXNUMMSG    /
	DATA PARID(42)	/SYI$_DEFPRI          /
	DATA PARID(43)	/SYI$_DEFQUEPRI       /
	DATA PARID(44)	/SYI$_DISK_QUORUM     /
	DATA PARID(45)	/SYI$_DISMOUMSG       /
	DATA PARID(46)	/SYI$_DLCKEXTRASTK    /
	DATA PARID(47)	/SYI$_DORMANTWAIT     /
	DATA PARID(48)	/SYI$_DUMPBUG         /
	DATA PARID(49)	/SYI$_EXTRACPU        /
	DATA PARID(50)	/SYI$_EXUSRSTK        /
	DATA PARID(51)	/SYI$_FREEGOAL        /
	DATA PARID(52)	/SYI$_FREELIM         /
	DATA PARID(53)	/SYI$_GBLPAGES        /
	DATA PARID(54)	/SYI$_GBLPAGFIL       /
	DATA PARID(55)	/SYI$_GBLSECTIONS     /
	DATA PARID(56)	/SYI$_GROWLIM         /
	DATA PARID(57)	/SYI$_IJOBLIM         /
	DATA PARID(58)	/SYI$_IMGIOCNT        /
	DATA PARID(59)	/SYI$_INTSTKPAGES     /
	DATA PARID(60)	/SYI$_IOTA            /
	DATA PARID(61)	/SYI$_IRPCOUNT        /
	DATA PARID(62)	/SYI$_IRPCOUNTV       /
	DATA PARID(63)	/SYI$_KFILSTCNT       /
	DATA PARID(64)	/SYI$_LAMAPREGS       /
	DATA PARID(65)	/SYI$_LGI_BRK_DISUSER /
	DATA PARID(66)	/SYI$_LGI_BRK_LIM     /
	DATA PARID(67)	/SYI$_LGI_BRK_TERM    /
	DATA PARID(68)	/SYI$_LGI_BRK_TMO     /
	DATA PARID(69)	/SYI$_LGI_HID_TIM     /
	DATA PARID(70)	/SYI$_LGI_PWD_TMO     /
	DATA PARID(71)	/SYI$_LGI_RETRY_LIM   /
	DATA PARID(72)	/SYI$_LGI_RETRY_TMO   /
	DATA PARID(73)	/SYI$_LNMPHASHTBL     /
	DATA PARID(74)	/SYI$_LNMSHASHTBL     /
	DATA PARID(75)	/SYI$_LOADCHKPRT      /
	DATA PARID(76)	/SYI$_LOADERAPT       /
	DATA PARID(77)	/SYI$_LOADMTACCESS    /
	DATA PARID(78)	/SYI$_LOCKDIRWT       /
	DATA PARID(79)	/SYI$_LOCKIDTBL       /
	DATA PARID(80)	/SYI$_LOCKIDTBL_MAX   /
	DATA PARID(81)	/SYI$_LOCKRETRY       /
	DATA PARID(82)	/SYI$_LONGWAIT        /
	DATA PARID(83)	/SYI$_LRPCOUNT        /
	DATA PARID(84)	/SYI$_LRPCOUNTV       /
	DATA PARID(85)	/SYI$_LRPMIN          /
	DATA PARID(86)	/SYI$_LRPSIZE         /
	DATA PARID(87)	/SYI$_MAXBUF          /
	DATA PARID(88)	/SYI$_MAXPROCESSCNT   /
	DATA PARID(89)	/SYI$_MAXQUEPRI       /
	DATA PARID(90)	/SYI$_MAXSYSGROUP     /
	DATA PARID(91)	/SYI$_MINWSCNT        /
	DATA PARID(92)	/SYI$_MOUNTMSG        /
	DATA PARID(93)	/SYI$_MPW_HILIMIT     /
	DATA PARID(94)	/SYI$_MPW_LOLIMIT     /
	DATA PARID(95)	/SYI$_MPW_PRIO        /
	DATA PARID(96)	/SYI$_MPW_THRESH      /
	DATA PARID(97)	/SYI$_MPW_WAITLIMIT   /
	DATA PARID(98)	/SYI$_MPW_WRTCLUSTER  /
	DATA PARID(99)	/SYI$_MVTIMEOUT       /
	DATA PARID(100)	/SYI$_NJOBLIM         /
	DATA PARID(101)	/SYI$_NOAUTOCONFIG    /
	DATA PARID(102)	/SYI$_NOCLOCK         /
	DATA PARID(103)	/SYI$_NOCLUSTER       /
	DATA PARID(104)	/SYI$_NPAGEDYN        /
	DATA PARID(105)	/SYI$_NPAGEVIR        /
	DATA PARID(106)	/SYI$_PAGEDYN         /
	DATA PARID(107)	/SYI$_PAGFILCNT       /
	DATA PARID(108)	/SYI$_PAGTBLPFC       /
	DATA PARID(109)	/SYI$_PAMAXPORT       /
	DATA PARID(110)	/SYI$_PANOPOLL        /
	DATA PARID(111)	/SYI$_PANUMPOLL       /
	DATA PARID(112)	/SYI$_PAPOLLINTERVAL  /
	DATA PARID(113)	/SYI$_PAPOOLINTERVAL  /
	DATA PARID(114)	/SYI$_PASANITY        /
	DATA PARID(115)	/SYI$_PASTDGBUF       /
	DATA PARID(116)	/SYI$_PASTIMOUT       /
	DATA PARID(117)	/SYI$_PE1             /
	DATA PARID(118)	/SYI$_PE2             /
	DATA PARID(119)	/SYI$_PE3             /
	DATA PARID(120)	/SYI$_PE4             /
	DATA PARID(121)	/SYI$_PE5             /
	DATA PARID(122)	/SYI$_PE6             /
	DATA PARID(123)	/SYI$_PFCDEFAULT      /
	DATA PARID(124)	/SYI$_PFRATH          /
	DATA PARID(125)	/SYI$_PFRATL          /
	DATA PARID(126)	/SYI$_PFRATS          /
	DATA PARID(127)	/SYI$_PHYSICALPAGES   /
	DATA PARID(128)	/SYI$_PIOPAGES        /
	DATA PARID(129)	/SYI$_PIXSCAN         /
	DATA PARID(130)	/SYI$_POOLPAGING      /
	DATA PARID(131)	/SYI$_PQL_DASTLM      /
	DATA PARID(132)	/SYI$_PQL_DBIOLM      /
	DATA PARID(133)	/SYI$_PQL_DBYTLM      /
	DATA PARID(134)	/SYI$_PQL_DCPULM      /
	DATA PARID(135)	/SYI$_PQL_DDIOLM      /
	DATA PARID(136)	/SYI$_PQL_DENQLM      /
	DATA PARID(137)	/SYI$_PQL_DFILLM      /
	DATA PARID(138)	/SYI$_PQL_DJTQUOTA    /
	DATA PARID(139)	/SYI$_PQL_DPGFLQUOTA  /
	DATA PARID(140)	/SYI$_PQL_DPRCLM      /
	DATA PARID(141)	/SYI$_PQL_DTQELM      /
	DATA PARID(142)	/SYI$_PQL_DWSDEFAULT  /
	DATA PARID(143)	/SYI$_PQL_DWSEXTENT   /
	DATA PARID(144)	/SYI$_PQL_DWSQUOTA    /
	DATA PARID(145)	/SYI$_PQL_MASTLM      /
	DATA PARID(146)	/SYI$_PQL_MBIOLM      /
	DATA PARID(147)	/SYI$_PQL_MBYTLM      /
	DATA PARID(148)	/SYI$_PQL_MCPULM      /
	DATA PARID(149)	/SYI$_PQL_MDIOLM      /
	DATA PARID(150)	/SYI$_PQL_MENQLM      /
	DATA PARID(151)	/SYI$_PQL_MFILLM      /
	DATA PARID(152)	/SYI$_PQL_MJTQUOTA    /
	DATA PARID(153)	/SYI$_PQL_MPGFLQUOTA  /
	DATA PARID(154)	/SYI$_PQL_MPRCLM      /
	DATA PARID(155)	/SYI$_PQL_MTQELM      /
	DATA PARID(156)	/SYI$_PQL_MWSDEFAULT  /
	DATA PARID(157)	/SYI$_PQL_MWSEXTENT   /
	DATA PARID(158)	/SYI$_PQL_MWSQUOTA    /
	DATA PARID(159)	/SYI$_PRCPOLINTERVAL  /
	DATA PARID(160)	/SYI$_PROCSECTCNT     /
	DATA PARID(161)	/SYI$_QDSKINTERVAL    /
	DATA PARID(162)	/SYI$_QDSKVOTES       /
	DATA PARID(163)	/SYI$_QUANTUM         /
	DATA PARID(164)	/SYI$_QUORUM          /
	DATA PARID(165)	/SYI$_REALTIME_SPTS   /
	DATA PARID(166)	/SYI$_RECNXINTERVAL   /
	DATA PARID(167)	/SYI$_RESALLOC        /
	DATA PARID(168)	/SYI$_RESHASHTBL      /
	DATA PARID(169)	/SYI$_RJOBLIM         /
	DATA PARID(170)	/SYI$_RMS_DFMBC       /
	DATA PARID(171)	/SYI$_RMS_DFMBFHSH    /
	DATA PARID(172)	/SYI$_RMS_DFMBFIDX    /
	DATA PARID(173)	/SYI$_RMS_DFMBFREL    /
	DATA PARID(174)	/SYI$_RMS_DFMBFSDK    /
	DATA PARID(175)	/SYI$_RMS_DFMBFSMT    /
	DATA PARID(176)	/SYI$_RMS_DFMBFSUR    /
	DATA PARID(177)	/SYI$_RMS_DFNBC       /
	DATA PARID(178)	/SYI$_RMS_EXTEND_SIZE /
	DATA PARID(179)	/SYI$_RMS_FILEPROT    /
	DATA PARID(180)	/SYI$_RMS_GBLBUFQUO   /
	DATA PARID(181)	/SYI$_RMS_PROLOGUE    /
	DATA PARID(182)	/SYI$_SAVEDUMP        /
	DATA PARID(183)	/SYI$_SBIERRENABLE    /
	DATA PARID(184)	/SYI$_SCSBUFFCNT      /
	DATA PARID(185)	/SYI$_SCSCONNCNT      /
	DATA PARID(186)	/SYI$_SCSFLOWCUSH     /
	DATA PARID(187)	/SYI$_SCSMAXDG        /
	DATA PARID(188)	/SYI$_SCSMAXMSG       /
	DATA PARID(189)	/SYI$_SCSNODE         /
	DATA PARID(190)	/SYI$_SCSRESPCNT      /
	DATA PARID(191)	/SYI$_SCSSYSTEMID     /
	DATA PARID(192)	/SYI$_SCSSYSTEMIDH    /
	DATA PARID(193)	/SYI$_SETTIME         /
	DATA PARID(194)	/SYI$_SPTREQ          /
	DATA PARID(195)	/SYI$_SRPCOUNT        /
	DATA PARID(196)	/SYI$_SRPCOUNTV       /
	DATA PARID(197)	/SYI$_SRPMIN          /
	DATA PARID(198)	/SYI$_SRPSIZE         /
	DATA PARID(199)	/SYI$_SSINHIBIT       /
	DATA PARID(200)	/SYI$_STARTUP_P1      /
	DATA PARID(201)	/SYI$_STARTUP_P2      /
	DATA PARID(202)	/SYI$_STARTUP_P3      /
	DATA PARID(203)	/SYI$_STARTUP_P4      /
	DATA PARID(204)	/SYI$_STARTUP_P5      /
	DATA PARID(205)	/SYI$_STARTUP_P6      /
	DATA PARID(206)	/SYI$_STARTUP_P7      /
	DATA PARID(207)	/SYI$_STARTUP_P8      /
	DATA PARID(208)	/SYI$_SWPALLOCINC     /
	DATA PARID(209)	/SYI$_SWPFAIL         /
	DATA PARID(210)	/SYI$_SWPFILCNT       /
	DATA PARID(211)	/SYI$_SWPOUTPGCNT     /
	DATA PARID(212)	/SYI$_SWPRATE         /
	DATA PARID(213)	/SYI$_SWP_PRIO        /
	DATA PARID(214)	/SYI$_SYSMWCNT        /
	DATA PARID(215)	/SYI$_SYSPAGING       /
	DATA PARID(216)	/SYI$_SYSPFC          /
	DATA PARID(217)	/SYI$_TAILORED        /
	DATA PARID(218)	/SYI$_TBSKIPWSL       /
	DATA PARID(219)	/SYI$_TIMEPROMPTWAIT  /
	DATA PARID(220)	/SYI$_TTY_ALTALARM    /
	DATA PARID(221)	/SYI$_TTY_ALTYPAHD    /
	DATA PARID(222)	/SYI$_TTY_AUTOCHAR    /
	DATA PARID(223)	/SYI$_TTY_BUF         /
	DATA PARID(224)	/SYI$_TTY_CLASSNAME   /
	DATA PARID(225)	/SYI$_TTY_DEFCHAR     /
	DATA PARID(226)	/SYI$_TTY_DEFCHAR2    /
	DATA PARID(227)	/SYI$_TTY_DEFPORT     /
	DATA PARID(228)	/SYI$_TTY_DIALTYPE    /
	DATA PARID(229)	/SYI$_TTY_DMASIZE     /
	DATA PARID(230)	/SYI$_TTY_OWNER       /
	DATA PARID(231)	/SYI$_TTY_PARITY      /
	DATA PARID(232)	/SYI$_TTY_PROT        /
	DATA PARID(233)	/SYI$_TTY_RSPEED      /
	DATA PARID(234)	/SYI$_TTY_SCANDELTA   /
	DATA PARID(235)	/SYI$_TTY_SILOTIME    /
	DATA PARID(236)	/SYI$_TTY_SPEED       /
	DATA PARID(237)	/SYI$_TTY_TIMEOUT     /
	DATA PARID(238)	/SYI$_TTY_TYPAHDSZ    /
	DATA PARID(239)	/SYI$_UAFALTERNATE    /
	DATA PARID(240)	/SYI$_UDABURSTRATE    /
	DATA PARID(241)	/SYI$_USER3           /
	DATA PARID(242)	/SYI$_USER4           /
	DATA PARID(243)	/SYI$_USERD1          /
	DATA PARID(244)	/SYI$_USERD2          /
	DATA PARID(245)	/SYI$_VAXCLUSTER      /
	DATA PARID(246)	/SYI$_VIRTUALPAGECNT  /
	DATA PARID(247)	/SYI$_VMS5            /
	DATA PARID(248)	/SYI$_VMS6            /
	DATA PARID(249)	/SYI$_VMS7            /
	DATA PARID(250)	/SYI$_VMS8            /
	DATA PARID(251)	/SYI$_VMSD1           /
	DATA PARID(252)	/SYI$_VMSD2           /
	DATA PARID(253)	/SYI$_VMSD3           /
	DATA PARID(254)	/SYI$_VMSD4           /
	DATA PARID(255)	/SYI$_VOTES           /
	DATA PARID(256)	/SYI$_WRITABLESYS     /
	DATA PARID(257)	/SYI$_WRITESYSPARAMS  /
	DATA PARID(258)	/SYI$_WSDEC           /
	DATA PARID(259)	/SYI$_WSINC           /
	DATA PARID(260)	/SYI$_WSMAX           /
	DATA PARID(261)	/SYI$_WS_OPA0         /
	DATA PARID(262)	/SYI$_XFMAXRATE       /
C
C	Special paramaters, not available from $GETSTYI as of yet. The code
C	in AGN_VMS assumes we provide ident of related SYSGEN parameter
C	and  subtracts current use from it:
	DATA PARID(263) /SYI$_GBLPAGES	      / ! for GLBPAGES_FREE	
	DATA PARID(264) /SYI$_GBLSECTIONS     / ! for GBLSECTIONS_FREE
C
C   START OF EXECUTABLE CODE --
C
	Call STR$UPCASE(NAME,NAME)		! Make sure we are upper case
	naml=len(NAME)				! get parameter name length
	naml=index(NAME//' ',' ')-1		! and reduce it to non-blank 
	if (naml .lt. 1 )Call LIB$SIGNAL(AGN$_EMPPAR)! Empty par.msg, unwind
C
	nfound=0				! Count how many times found
	Do I=1,(VMSPAR+SPCPAR)			! to discover ambiguous pars.
	   if (name(:naml) .eq. PARNAM(I)(:naml) ) then
	      ident=parid(I)			! Parameter value for GETSYI
	      ipar=I				! and index in our table
	      if (index(PARNAM(I),' ').eq. naml+1) then
	         nfound=1			! Exact match, valid
	         goto 1100			! parameter
	      end if
	      nfound=nfound+1			! May be ambiguous ....
	   end if
	End do
1100	Continue
C           
	ityp = 0				! Assume undefined parameter
	if (nfound.eq.0) then			!		! not found
 	   Call LIB$SIGNAL(AGN$_UDFPAR,%val(1),name(:naml))	! = Unwind
	else if (nfound.gt.1) then				! ambiguous
 	   Call LIB$SIGNAL(AGN$_AMBPAR,%val(1),name(:naml))	! = Unwind   
	else
	   name = PARNAM(ipar)			! Expand to full par. name
	   ityp = 1	        		! Assume INTEGER parameter
C						! Check for STRING parameters
	   if ((name(:07) .eq. 'SCSNODE')
     $	   .or.(name(:13) .eq. 'TTY_CLASSNAME')
     $	   .or.(name(:11) .eq. 'DISK_QUORUM')
     $	   .or.(name(:09) .eq. 'STARTUP_P') ) ityp = 2
C						! Check for SPECIAL parameters
	   if (ipar.gt.VMSPAR) ityp = 3		! (here above VMS parameters)
	end if
	Return
	end
