	PROGRAM AGN_ROOT
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- AGN_ROOT
C
C       PURPOSE -- Root module for ATTC AGN utility
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	  The root module conteins the main command processing loop.
C	  It establishes an exception handler to force any error return
C	  back to this loop, load the default file (if found),  and
C	  processes commands as they come passing control to action
C	  subroutines.
C
C       NOTES --
C	  
C	  Explicite checking is needed to handle SINGLE command invocations
C	  correctly. In such a case, we can NOT prompt for additional
C	  commands.
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
	IMPLICIT NONE
 	INTEGER	 IST,FORLEN
	Character*132 FORSTR				! Foreign CMD string
C
	INTEGER	 CLI$DCL_PARSE,CLI$DISPATCH,CLI$PRESENT
	EXTERNAL LIB$GET_INPUT,AGN_TABLE,LIB$GET_FOREIGN
	EXTERNAL CLI$_NOCOMD
	EXTERNAL RMS$_EOF
	EXTERNAL SS$_NORMAL				!
	EXTERNAL AGN_HAN				! Local exception handl
C                        
C  START OF EXECUTABLE CODE --
C
C	We use exception handling to return control back to our main loop
C	at any CLI or AGN (our) error
C
	CALL	LIB$ESTABLISH(AGN_HAN)			! Establish handler
C
	CALL	AGN_USEDEF()				! Load the default file
C
	CALL	LIB$GET_FOREIGN(FORSTR,,FORLEN)		! CMD line present ?
C
  100	IST=CLI$DCL_PARSE(%VAL(0)                       ! Get (next) command
     $		,AGN_TABLE               		! (see AGN_TABLE.CLD)
     $		,LIB$GET_INPUT
     $		,LIB$GET_FOREIGN
     $	        ,'ATTCAGN>')                                 
	IF(IST.EQ.%loc(RMS$_EOF))then
	    CALL AGN_EXIT()				! terminate,
	    CALL sys$exit(%val(4))			! exit at AGN_EXIT error
	end if
	IF(IST.EQ.%loc(CLI$_NOCOMD)) GoTo 120		! skip empty cmd's
	IF(.not.IST)  GoTo 120				! and any errors
  	IST=CLI$DISPATCH()				! dispatch to routine
  120	If (FORLEN.eq.0)GOTO 100			! Loop for next cmd
	Call sys$exit(%val(1))				! Exit with status
	END	                                                       
