	SUBROUTINE AGN_SUB()      
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- AGN_SUB
C
C       PURPOSE -- Command action subroutines for ATTC AGN
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C	
C	  The following entries are called by  CLI$DISPATCH from the
C	  root module, based on command entered. No arguments are passed in.
C	  In many instances, we signal ERRORS here to cause UNWIND back to
C	  the main dispatch module. For message severity refer to AGN_MSG.MSG.
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  08/10/88,,,MARBRU, Added "global" flag file for compatibility
C	  08/05/88,,,MARBRU, Implemented SPAWN AUTOGEN on no-reboot
C	  03/08/88,,,MARBRU, Fixed flag file name handling
C	  07/01/87,,137-148312-000,MARBRU,Initial code
C
C  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
C  *****************************************************************
C
	IMPLICIT	NONE		! Force ALL declared
	INCLUDE		'AGN_PAR'	! AGN parameter definitions
	INCLUDE		'AGN_ERR'	! Error messages definitions
C                                                             
C	Local variables
C
C	Command qualifier presence flags (Returned form  AGN_GET_xxx)
	Logical			PRO		! Product present in command
	Logical 		DEV		! Device  present in command
	Logical 		PAR		! Parame  present in command
	Logical 		TYP		! Par.type present in command
	Logical 		CPU 		! CPU.type present in command
	Logical 		VAL		! Value present in command
	Logical			ALL		! ALL qualifier present in cmd
	Logical			REB		! REBOOT qual. present in cmd
C
C	Command qualifier value strings (Returned form AGN_GET_xxx)
	Character*(MPRO)	PROSTR		! Product string
	Character*(MDEV)	DEVSTR		! Device string
	Character*(MPAR)	PARSTR		! Parameter string
	Character*(MTYP)	TYPSTR		! Par.type string
	Character*(MCPU)	CPUSTR		! CPU type string
	Character*(MVAL)	VALSTR          ! VALUE string
	Character*(MDIS)	DISSTR		! Disabled flag string
C
C	Database record fields (returned from AGN_REC_DATA)
	Character*(MPRO)	PRODAT		! Product data string
	Character*(MDEV)	DEVDAT		! Device data string
	Character*(MPAR)	PARDAT		! Parameter data string
	Character*(MTYP)	TYPDAT		! Par.type data string
	Character*(MCPU)	CPUDAT		! CPU type data string
	Character*(MVAL)	VALDAT          ! VALUE data string
	Character*(MDIS)	DISDAT		! Disabled flag data string
C
	Character*255	FILSTR			! Filename string
	Integer*4	LFIL			! and length
	Character*255	NAMSTR			! Inquired name string
	Integer*4	LNAM			! and length
	Logical		FILEX			! File exists flag
C
	Logical		BADP	/.false./	! BAD VMS parameter found
	Save		BADP			! (must be saved across calls)
	Integer*4	IDENT			! VMS parameter identifier
	Integer*4	ITYP			! VMS parameter type
	Integer*4	IND			! Record index
	Integer*4	IS	  		! Status
	Integer*4	LIB$SYS_TRNLOG		! Translate logical
	Integer*4	I			! Index variable
C
C  START OF EXECUTABLE CODE --
C
C	=====================================================================
C	USE subroutines reads the AUTOGEN file(s) into memmory
C	Each call cancells the file previously loaded. The USEDEF entry
C	is called at program activation to load default file.
C 100                                           ! 
	ENTRY	AGN_USEDEF()			! Load the default file
	FILSTR = 'sys$system:MODPARAMS.DAT;0'	! using a default file
 	LFIL   = 27				! provided explicitly
	GoTo   120				! Chain common code
C
	ENTRY	AGN_USE()			! Use CLI provided filespec
	CALL	AGN_GET_FILE(LFIL,FILSTR)	! Get parsed filename
  120	CALL	AGN_REC_REA (LFIL,FILSTR)	! And try to load a file
	BADP	= .false.			! No bad parameter YET
	RETURN	
C	====================================================================
	ENTRY	AGN_DELETE()			! Delete ATTCAGN record(s)
C200
	CALL	AGN_GET_PRODUCT   (PRO,PROSTR)
	CALL	AGN_GET_DEVICE    (DEV,DEVSTR)
	CALL	AGN_GET_CPU       (CPU,CPUSTR)
	CALL	AGN_GET_PARAMETER (PAR,PARSTR)
	CALL	AGN_GET_ALL	  (ALL)
	If (.not.(ALL.or.CPU.or.PAR)) Call LIB$SIGNAL(AGN$_DELQUA) ! Unwind
C                                                 
	IND = 0					! Always start at first rec
220	Call	AGN_REC_LOC(PRO,PROSTR,DEV,DEVSTR,CPU,CPUSTR,
     $	                    PAR,PARSTR,TYP,TYPSTR,	IND)
    	If (IND.eq.0)RETURN			! No matching record 
	Call	AGN_REC_REM(IND)		! remove this record
	IND	= IND-1				! Back to previous record
	GoTo 	220				! and repeat scan
C	====================================================================
	ENTRY	AGN_SET()			! SET-up ATTCAGN record
C 300
	CALL	AGN_GET_PRODUCT   (PRO,PROSTR)
	CALL	AGN_GET_DEVICE    (DEV,DEVSTR)                     
	CALL	AGN_GET_CPU       (CPU,CPUSTR)
	CALL	AGN_GET_PARAMETER (PAR,PARSTR)
	CALL	AGN_GET_TYPE	  (TYP,TYPSTR)
	CALL	AGN_GET_VALUE	  (VAL,VALSTR)
	if (.not.PAR) Call LIB$SIGNAL(AGN$_PARREQ)        ! Signal, unwind
	if (.not.TYP) Call LIB$SIGNAL(AGN$_TYPREQ)        ! Signal, unwind
	if (.not.VAL) Call LIB$SIGNAL(AGN$_VALREQ)        ! Signal, unwind
	if (.not.PRO .and. 
     $	    .not.DEV) Call LIB$SIGNAL(AGN$_PRODEV)        ! Signal, unwind
	Call 	AGN_PRM(PARSTR,IDENT,ITYP)	! Check parameter (may unwind)
C                                                                  
	IND = 0					! Search for matching record
 340	Call	AGN_REC_LOC(PRO,PROSTR,DEV,DEVSTR,CPU,CPUSTR,
     $	                    PAR,PARSTR,TYP,TYPSTR,	IND)
	if (IND.ne.0) then			! Matching record found
	   Call AGN_REC_DATA(IND,PRODAT,PARDAT,TYPDAT,CPUDAT,DISDAT,
     $			     VALDAT,DEVDAT)	! Get this record data
	   if (VALDAT.eq.VALSTR ) Return    	! Same value = done
	   Call LIB$SIGNAL(AGN$_PAROVR,%val(2),PROSTR,PARSTR)! Other = overrides
	   Call AGN_REC_REM(IND)		! Remove old record
	   IND=IND-1				! Back up index
	   GoTo 340				! Repeat search
	end if					! (matching record found)
C
 	CALL	AGN_REC_ADD(PRO,PROSTR,DEV,DEVSTR,CPU,CPUSTR,
     $	                    PAR,PARSTR,TYP,TYPSTR,VAL,VALSTR)
	Return
C	====================================================================
	ENTRY	AGN_VER()			! VERIFY system parameter 
C 400                      
	CALL	AGN_GET_PRODUCT   (PRO,PROSTR)
	CALL	AGN_GET_DEVICE    (DEV,DEVSTR)        
	CALL	AGN_GET_CPU       (CPU,CPUSTR)                            
	CALL	AGN_GET_PARAMETER (PAR,PARSTR)
	CALL	AGN_GET_TYPE	  (TYP,TYPSTR)
	CALL	AGN_GET_VALUE	  (VAL,VALSTR)
	if (.not.PAR) Call LIB$SIGNAL(AGN$_PARREQ)	  ! Signal, unwind
	if (.not.TYP) Call LIB$SIGNAL(AGN$_TYPREQ)        ! Signal, unwind
	if (.not.VAL) Call LIB$SIGNAL(AGN$_VALREQ)        ! Signal, unwind
	if (.not.PRO .and. 
     $	    .not.DEV) Call LIB$SIGNAL(AGN$_PRODEV)        ! Signal, unwind
C                                         
	Call AGN_PRM(PARSTR,IDENT,ITYP)			  ! Check parameter
C	Check actual VMS system parameter value
	Call AGN_VMS(PARSTR,IDENT,ITYP,TYPSTR,VALSTR,BADP)! Verify VMS par.value
	RETURN
C	====================================================================
	ENTRY	AGN_LIST()                     	! List ATTCAGN records
C 500                                                      
	CALL	AGN_GET_PRODUCT   (PRO,PROSTR)
	CALL	AGN_GET_DEVICE    (DEV,DEVSTR)
	CALL	AGN_GET_CPU       (CPU,CPUSTR)
	CALL	AGN_GET_PARAMETER (PAR,PARSTR)
	CALL	AGN_GET_TYPE	  (TYP,TYPSTR)
	write(*,540)
	IND = 0					! Search from first record
 520	Call	AGN_REC_LOC(PRO,PROSTR,DEV,DEVSTR,CPU,CPUSTR,
     $	                    PAR,PARSTR,TYP,TYPSTR, 	IND)
    	If (IND.eq.0)RETURN			! No matching record 
	   Call AGN_REC_DATA(IND,PRODAT,PARDAT,TYPDAT,CPUDAT,DISDAT,
     $			     VALDAT,DEVDAT)	! Get this record data
        Write(*,530)
     $	     PRODAT,PARDAT(:20),TYPDAT,VALDAT,DEVDAT,CPUDAT,DISDAT
	GoTo 520				! Loop to try next record
C                                    
 530	FORMAT (1X,a,1X,a,1x,a,1X,a,1X,a,1X,a,1X,a)
 540	FORMAT 
     $	(/' Product  Parameter            Typ Value     Dev  CPU    Dis'
     $	 /' -----------------------------------------------------------')
C	====================================================================
	ENTRY	AGN_ENABLE()			! Enable ATTCAGN record(s)
C 600
	DISSTR	= '0'				! Flag DISABLED = 0
	GoTo	620				! Chain common code
C	====================================================================
	ENTRY	AGN_DISABLE()			! Disable ATTCAGN record(s)
C 700
	DISSTR	= '1'				! Flag DISABLED = 1 (disabled)
  620	CALL	AGN_GET_PRODUCT   (PRO,PROSTR)
	CALL	AGN_GET_DEVICE    (DEV,DEVSTR)
	CALL	AGN_GET_CPU       (CPU,CPUSTR)        
	CALL	AGN_GET_ALL	  (ALL)                                  
	PAR=.false.				! Parameter and Type
	TYP=.false.				! are match-all
	if (.not.(PRO .or. CPU .or. DEV) )	! Something must be required
     $	    Call LIB$SIGNAL(AGN$_PRODEV)	! Signal, unwind	
	IND = 0					! Search start
  630	Call	AGN_REC_LOC(PRO,PROSTR,DEV,DEVSTR,CPU,CPUSTR,
     $	                    PAR,PARSTR,TYP,TYPSTR,	IND)
	if (IND.ne.0) then			! We found matching record
	   Call AGN_REC_DATA(IND,PRODAT,PARDAT,TYPDAT,CPUDAT,DISDAT,
     $			     VALDAT,DEVDAT)	! Get this record data
           if(DISSTR.ne.DISDAT ) 		! State change needed
     $	      CALL AGN_REC_ENA(IND,DISSTR) 	! Modify record
	   GoTo 630				! Look for another record
	end if
	RETURN
C	====================================================================
	ENTRY	AGN_CHECK()				
C	Conditionally write AUTOGEN file back.
C	Check if any VERIFY command produced errors.
C	If verificatuion passed O.K., we make 	sure no flag-file
C	for this product are left around.
C	Otherwise, we check the reboot option. 
C	If reboot is enabled,  create a flag file and chain AUTOGEN command.
C	If reboot is disabled, spawn AUTOGEN command
C 800                           
	Call AGN_REC_WRT()				! Update file  
 	CALL	AGN_GET_PRODUCT (PRO,PROSTR)		! Product name mandatory
	IF (.NOT.PRO) CALL LIB$SIGNAL(AGN$_PROREQ)	! Get PRODUCT name
C               
	LFIL   = index(PROSTR,' ')-1			! Remove blank
	If (LFIL.gt.0) then
	  FILSTR = 'ATTCAGN_'//PROSTR(:LFIL)		! Build FLAG file name
	  LFIL   = LFIL+8				! and length
	else
	  FILSTR = ' '					! Let use the DEFAULT
	  LFIL   = 1					! name
	end if	
D	write(*,*)'Flag file name: '//FILSTR(:LFIL )
C
     	if (.not.BADP) then          			! No bad parameters
	    CALL LIB$DELETE_FILE (FILSTR(:LFIL)//';*',
     $		 'sys$manager:ATTCAGN_REBOOT.FLG;*')	! Delete any flag files
 	    CALL SYS$EXIT(%val(1))			! No bad parameter=done
	end if
C
C	Look for /NOREBOOT qualifier; if present, don't reboot
	CALL	AGN_GET_REBOOT	  (REB)
	if (.not.REB)  then
	   Call LIB$SIGNAL (AGN$_NOREBO)		! Report NO REBOOT
	   GoTo 850					! Try to spawn
	end if
C
C	Check PROCESS logical name ATTCAGN_REBOOT, if equal to NO, 
C	exit with an error status:
	IS = LIB$SYS_TRNLOG ('AT$ATTCAGN_REBOOT',I,NAMSTR,,,3)
	IF (IS .AND. I.GT.0 .and. NAMSTR(1:1).eq.'N') then
	    CALL LIB$SIGNAL (AGN$_REBDIS)		! Report REBOOT disabled
	    GoTo 850					! Try to spawn
	End If                                          
C
C	Check the global "flag" file presence; if exists, don't reboot.
820	INQUIRE(FILE='sys$manager:ATTCAGN_REBOOT.FLG;0',! Global flag file
     $		NAME=NAMSTR,ERR=830,EXIST=FILEX)
	If (.not.FILEX) GoTo 830
	LNAM = INDEX(NAMSTR,' ')			! Find pathname length
	Call LIB$SIGNAL (AGN$_FLGFIL,%val(1),NAMSTR(:LNAM)) ! Warn
	GoTo 850					! Try to spawn
C
C	Check the product "flag" file presence; if exists, don't reboot.
 830	INQUIRE(FILE=FILSTR(:LFIL),NAME=NAMSTR,ERR=840, ! Current flag file
     $		DEFAULTFILE='sys$manager:ATTCAGN_REBOOT.FLG;0',EXIST=FILEX)
	If (.not.FILEX) GoTo 840
	LNAM = INDEX(NAMSTR,' ')			! Find pathname length
	Call LIB$SIGNAL (AGN$_FLGFIL,%val(1),NAMSTR(:LNAM)) ! Warn
	GoTo 850					! Try to spawn
C
C	All checks complete. Create the new flag file and chain AUTOGEN
C	to adjust system parameters and reboot:
 840	Open (Unit=1,name=FILSTR(:LFIL),type='NEW',	! New, last version
     $	      DEFAULTFILE='sys$manager:ATTCAGN_REBOOT.FLG;0')
	Write(1,*)'ATTCAGN Flag file, used to prevent endless reboots'
	Close(Unit=1)					! of flag file
	CALL LIB$SIGNAL(AGN$_FLGNAM,%val(1),FILSTR(:LFIL)) 	! Tell user
	CALL LIB$SIGNAL(AGN$_AGNREB)			! Notify user
	CALL LIB$DO_COMMAND 				! Chain AUTOGEN
     $	     ( '@sys$update:AUTOGEN GETDATA REBOOT INITIAL' )
	CALL	SYS$EXIT(%val('10000004'X))		! NEVER get here !
	RETURN
C
C	Renboot is disabled. Try to spawn AUTOGEN SETPARAMS command

 850	CALL LIB$SIGNAL(AGN$_AGNSET)			! Notify user
	CALL LIB$SPAWN('@sys$update:AUTOGEN GETDATA SETPARAMS INITIAL')
	CALL SYS$EXIT(%val('10000004'x))		! CHECK operation failed
	RETURN
C
C	====================================================================
	ENTRY	AGN_EXIT()
C 900
	Call AGN_REC_WRT()				! Update file
	Call SYS$EXIT(%val(1))
	RETURN
C
C	====================================================================
 	ENTRY	AGN_QUIT()
C
	Call lib$signal(AGN$_NOSAVE)			! Warn user
	Call SYS$EXIT(%val(1))
	RETURN
	END
