! AUOSI.CTL - AUOSI Shareable Image Build control file
! ###############################################################
! # (C) Copyright 1985 Auto-trol Technology Corporation         #
! #                                                             #
! # This program is the sole property of Auto-trol Technology   #
! # Corporation and is considered a trade secret and/or a       #
! # proprietary product of Auto-trol Technology Corporation.    #
! # Use or disclosure of this program by other than Auto-trol   #
! # Technology Corporation and its assigned licensees and       #
! # customers is strictly forbidden by law.                     #
! #                                                             #
! # Use, duplication or disclosure by the Government is subject #
! # to restrictions as set forth in subdivision (b)(3)(ii) of   #
! # the Rights in Technical Data and Computer Software clause   #
! # at 252.227.7013.                                            #
! ###############################################################
!  /BEGIN MODULE HEADER/        AUOSI 	/STANDARD MODULE HEADER/
!
!       NAME -- AUOSI.CTL
!
!       PURPOSE -- 
!	  Control file for AUOSI VAX shareable image build.
!	  Defines all the user accessible AUOSI entry points, 
!	  image revision ID's etc.
!
!       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
!
!	  This module contains AUOSI image MAJOR and MINOR IDs.
!	  It has to be edited if any of the IDs changes. This should
!	  also guarantee that all changes ( new entry points )
!	  will be reflected here.
!
!       NOTES --
!
!       HISTORY --
!         MM/DD/YY,SDRC,functional spec number,initials,comments
!	  10/15/88,,,MXB, Example for DECUS tape distribution
!
!  /END MODULE HEADER/        AUOSI 	    /STANDARD MODULE HEADER/
!  *****************************************************************
!
! 	Major and Minor ID are used by LINKER GSMATCH option. Any product
! 	may link to the higher MINID shareable image version without
! 	changes. It has to be relinked if MAJID does not match.
!
OPTION=GSMATCH=LEQ,10,11	! Anything build against A11 can't use 
!				! AUOSI 10.nn
OPTION=UNSUPPORTED=1		! Use Demand Zero pages, where applicable
!
! 	To guarantee the position of the COMMON image cluster, the transfer
! 	vector table should have fixed length between releases. For image
! 	supporting access to it's common data section, transfer vector table
! 	size is an equivalent to the common size change - requires MAJOR ID
! 	change, and re-build of all linked images.
!	For AUOSISHR, we try to keep transfer vector table size constat,
!	even though it is not the strict requirement.
!
TABSIZ=2560			! Required transfer vector table size
!				! 320 EPT's = 5 pages
!
! 	Folowing FILE section should specify all the modules and libraries
! 	loaded into DEFAULT_CLUSTER. Here we can specify explicite files
!	to go into build.
!
FILE=AUOSILIB/LIB		! Build library logical - AUOSIrrbb.OLB
!	To avoid problems with multiple VAXCRTL global variables location,
!	we bind against shareable image
FILE=sys$library:VAXCRTL.EXE/SHARE
!
!	For AUOSISHR, any COMMONS and C Global Data are made LOCAL to AUOSI.
!	Any GLOBAL data (commons) would be declared as GLOBAL=name
!
LOCAL=AUOSI_SMOD	! AUOSI modes common
LOCAL=AUOSI_IOCB	! AUOSI I/O common
LOCAL=AUOSI_DCHR	! AUOSI device characteristics common
LOCAL=AUOSI_DFLT	! AUOSI file defaults common
LOCAL=AUOSI_DIRE	! AUOSI directory access common
LOCAL=AUOSI_EXCP	! AUOSI exception handling common
LOCAL=AUOSI_S232	! AUOSI RS-232 support common
LOCAL=AUOSI_SSCH	! AUOSI Scheduling/mailboxing common
LOCAL=AUOSI_SWFA	! AUOSI Switch file common
LOCAL=AUOSI_PRIN	! AUOSI printing common
!
!	The following image name defines the main logical name for AUOSI
!	shareable image. NOTE, ALL AUOSI callers MUST use the same logical
!	name, otherwise multiple AUOSIs will be loaded.
!	No load error routine provided.
!
IMAGE=AUOSISHR
!
! 	The folowing list of ENTRY definitions is used by the IMGBLD procedure
! 	to build:
! 	   1) Transfer vector table
! 	   2) Dummy entries module for the template shareable image
! 	   3) UNIVERSAL options of the linker option file
! 	The entry point sequence has to be kept. Any entry point sequence
! 	change requires GSMATCH MAJOR ID change. New modules should be added 
!	at the end of table. Addition of the new module requires MINOR ID 
!	change, to make sure images possibly referencing the new entry point 
!	will not be alowed to run with the older version. Obsolete modules 
!	should be replaced by DUMMY ones - merely returning.
!
ENTRY=SA1CPY   		,1	!
ENTRY=SABOR   		,2	!
ENTRY=SBITA   		,3	!
ENTRY=SBITC   		,4	!
ENTRY=SBITCM   		,5	!
ENTRY=SBITFC   		,6	!
ENTRY=SBITFS   		,7	!
ENTRY=SBITI   		,8	!
ENTRY=SBITT   		,9	!
ENTRY=SBITTM   		,10	!
ENTRY=SBITX   		,11	!
ENTRY=SBYTE   		,12	!
ENTRY=SC2D   		,13	!
ENTRY=SC2DS   		,14	!
ENTRY=SC2H   		,15	!
ENTRY=SC2O   		,16	!
ENTRY=SC2OS   		,17	!
ENTRY=SC2R   		,18	!
ENTRY=SC2RS   		,19	!
ENTRY=SCASE   		,20	!
ENTRY=SCBY   		,21	!
ENTRY=SCC2CI   		,22	!
ENTRY=SCCI2C   		,23	!
ENTRY=SCCI2D   		,24	!
ENTRY=SCCI2I   		,25	!
ENTRY=SCCI2L   		,26	!
ENTRY=SCCI2R   		,27	!
ENTRY=SCCI2T   		,28	!
ENTRY=SCD2CI   		,29	!
ENTRY=SCHAR   		,30	!
ENTRY=SCHARA   		,31	!
ENTRY=SCI2   		,32	!
ENTRY=SCI2CI   		,33	!
ENTRY=SCIS2   		,34	!
ENTRY=SCKST   		,35	!
ENTRY=SCKSTC   		,36	!
ENTRY=SCL2CI   		,37	!
ENTRY=SCLDV   		,38	!
ENTRY=SCLMBX   		,39	!
ENTRY=SCLOS   		,40	!
ENTRY=SCLSD   		,41	!
ENTRY=SCLST   		,42	!
ENTRY=SCLSWF   		,43	!
ENTRY=SCMBXN   		,44	!
ENTRY=SCR2   		,45	!
ENTRY=SCR2CI   		,46	!
ENTRY=SCRMBX   		,47	!
ENTRY=SCRS2   		,48	!
ENTRY=SCT2CI   		,49	!
ENTRY=SDELY   		,50	!
ENTRY=SDGETB   		,51	!
ENTRY=SDGETD   		,52	!
ENTRY=SDGETI   		,53	!
ENTRY=SDGETR   		,54	!
ENTRY=SDLMBX   		,55	!
ENTRY=SDRELB   		,56	!
ENTRY=SDRELD   		,57	!
ENTRY=SDRELI   		,58	!
ENTRY=SDRELR   		,59	!
ENTRY=SDSL   		,60	!
ENTRY=SEXIT   		,61	!
ENTRY=SFAP   		,62	!
ENTRY=SFATL   		,63	!
ENTRY=SFIN   		,64	!
ENTRY=SFINI   		,65	!
ENTRY=SFOLDL   		,66	!
ENTRY=SFOLDU   		,67	!
ENTRY=SFORCE   		,68	!
ENTRY=SFS   		,69	!
ENTRY=SFS2MD   		,70	!
ENTRY=SGATR   		,71	!
ENTRY=SGBY   		,72	!
ENTRY=SGBYS   		,73	!
ENTRY=SGCLP   		,74	!
ENTRY=OBSOLETE		,75	! Old SGCPYR interface
ENTRY=SGDAT   		,76	!
ENTRY=SGDEV   		,77	!
ENTRY=SGDEVI   		,78	!
ENTRY=SGDIR   		,79	!
ENTRY=SGEAT   		,80	!
ENTRY=SGECL   		,81	!
ENTRY=SGECLC   		,82	!
ENTRY=SGEDT   		,83	!
ENTRY=SGEFS   		,84	!
ENTRY=SGEPS   		,85	!
ENTRY=SGERS   		,86	!
ENTRY=SGETM   		,87	!
ENTRY=SGETP   		,88	!
ENTRY=SGETT   		,89	!
ENTRY=SGETU   		,90	!
ENTRY=SGETV   		,91	!
ENTRY=SGFS   		,92	!
ENTRY=SGLNMR   		,93	!
ENTRY=SGLNMT   		,94	!
ENTRY=SGNAME   		,95	!
ENTRY=SGTIM   		,96	!
ENTRY=SGTRM   		,97	!
ENTRY=SGUPI   		,98	!
ENTRY=SGUSR   		,99	!
ENTRY=SGVOL   		,100	!
ENTRY=SHDCPY   		,101	!
ENTRY=SHPWD   		,102	!
ENTRY=SIBYTE   		,103	!
ENTRY=SICHAR   		,104	!
ENTRY=SID   		,105	!
ENTRY=SINI   		,106	!
ENTRY=SINIEX   		,107	!
ENTRY=SINIT   		,108	!
ENTRY=SINQEX   		,109	!
ENTRY=SIOFN   		,110	!
ENTRY=SIOSN   		,111	!
ENTRY=SLEN   		,112	!
ENTRY=SLNKC   		,113	!
ENTRY=SLNKP   		,114	!
ENTRY=SLUNAL   		,115	!
ENTRY=SLUNDE   		,116	!
ENTRY=SMACH   		,117	!
ENTRY=SMBY   		,118	!
ENTRY=SMBYCH   		,119	!
ENTRY=SMBYR   		,120	!
ENTRY=SMCHBY   		,121	!
ENTRY=SMOVB   		,122	!
ENTRY=SMOVD   		,123	!
ENTRY=SMOVI   		,124	!
ENTRY=SMOVR   		,125	!
ENTRY=SOPB   		,126	!
ENTRY=SOPD   		,127	!
ENTRY=SOPDV   		,128	!
ENTRY=SOPLS   		,129	!
ENTRY=SOPMBX   		,130	!
ENTRY=SOPND   		,131	!
ENTRY=SOPNR   		,132	!
ENTRY=SOPNS   		,133	!
ENTRY=SOPR   		,134	!
ENTRY=SOPS   		,135	!
ENTRY=SOPST   		,136	!
ENTRY=SOPSWF   		,137	!
ENTRY=SOSLV   		,138	!
ENTRY=SPBY   		,139	!
ENTRY=SPIXR   		,140	!
ENTRY=SPIXS   		,141	!
ENTRY=SPRSE   		,142	!
ENTRY=SRDB   		,143	!
ENTRY=SRDD   		,144	!
ENTRY=SRDDF   		,145	!
ENTRY=SRDDS   		,146	!
ENTRY=SRDDVN   		,147	!
ENTRY=SRDDVX   		,148	!
ENTRY=SRDMBX   		,149	!
ENTRY=SRDR   		,150	!
ENTRY=SRDRC   		,151	!
ENTRY=SRDS   		,152	!
ENTRY=SRDSC   		,153	!
ENTRY=SRDST   		,154	!
ENTRY=SRNMF   		,155	!
ENTRY=SSC2F   		,156	!
ENTRY=SSCHCM   		,157	!
ENTRY=SSCHCMA   	,158	!
ENTRY=SSCHD   		,159	!
ENTRY=SSCHED   		,160	!
ENTRY=SSDIR   		,161	!
ENTRY=SSF2C   		,162	!
ENTRY=SSFAP   		,163	!
ENTRY=SSRCHF   		,164	!
ENTRY=SSVOL   		,165	!
ENTRY=SSXS   		,166	!
ENTRY=SVAAL   		,167	!
ENTRY=SVADE   		,168	!
ENTRY=SVAGC   		,169	!
ENTRY=SVAGD   		,170	!
ENTRY=SVAPC   		,171	!
ENTRY=SVAPD   		,172	!
ENTRY=SWAIT   		,173	!
ENTRY=SWRB   		,174	!
ENTRY=SWRMBX   		,175	!
ENTRY=SWRR   		,176	!
ENTRY=SWRRC   		,177	!
ENTRY=SWRS   		,178	!
ENTRY=SWRSC   		,179	!
ENTRY=SZERB   		,180	!
ENTRY=SZERD   		,181	!
ENTRY=SZERI   		,182	!
ENTRY=SZERR   		,183	!
ENTRY=SBITS		,184	!
ENTRY=SSFACP		,185	! Comm group File Acc Privileges (privileged)
ENTRY=SETUSR		,186	! Comm group Set User (UIC, privileges)
ENTRY=SGTWRD		,187	! Get word (2byte) sign extended
ENTRY=SPTWRD		,188	! Put word (2byte) from integer
! Add-on for AUOSI 10.01
ENTRY=SSEXIT		,189	! Exit with system status
ENTRY=SBOCLO		,190	! Buffered Output Close
ENTRY=SBOOPN		,191	! Buffered Output Open
ENTRY=SBOPUT		,192	! Buffered Output Put record
ENTRY=SBOFLU		,193	! Buffered Output Flush buffers
ENTRY=SBOFLW		,194	! Buffered Output Flush with wait
ENTRY=SMFOPN		,195	! Mapped file, OPEN
ENTRY=SMFMAP		,196	! Mapped file, MAP record
ENTRY=SMFOFF		,197	! Mapped file, MAP record giving offset
ENTRY=SDELF		,198	! Delete file
!
! AUOSI 11.00 additions
!
ENTRY=SDCMP		,199	! A11 Addition
ENTRY=SDEXST		,200	! A11 Addition
ENTRY=SFCOPY		,201	! A11 Addition
ENTRY=SFEXST		,202	! A11 Addition
ENTRY=SFMD2A		,203	! A11 Addition
ENTRY=SFMOVE		,204	! A11 Addition
ENTRY=SGCPYR		,205	! A11 Addition
ENTRY=SGENVV		,206	! A11 Addition
ENTRY=SGFATR		,207	! A11 Addition
ENTRY=SGMBX		,208	! A11 Addition
ENTRY=SGNODE		,209	! A11 Addition
ENTRY=SGPID		,210	! A11 Addition
ENTRY=SGPRT		,211	! A11 Addition
ENTRY=SGSDTM		,212	! A11 Addition
ENTRY=SPAUS		,213	! A11 Addition
ENTRY=SPRINT		,214	! A11 Addition
ENTRY=SSDEB		,215	! A11 Addition
ENTRY=SSMBX		,216	! A11 Addition
ENTRY=SSPRT		,217	! A11 Addition
ENTRY=SCLEN		,218	! A11 Addition
ENTRY=OBSOLETE		,219	! RESERVED at A11.00
!
ENTRY=SFS_CC		,220	! "C" callable
ENTRY=SCKSTC_CC		,221	! "C" callable
ENTRY=SDCMP_CC		,222	! "C" callable
ENTRY=SDELF_CC		,223	! "C" callable
ENTRY=SDEXST_CC		,224	! "C" callable
ENTRY=SFCOPY_CC		,225	! "C" callable
ENTRY=SFEXST_CC		,226	! "C" callable
ENTRY=SFMD2A_CC		,227	! "C" callable
ENTRY=SFMOVE_CC		,228	! "C" callable
ENTRY=SFS2MD_CC		,229	! "C" callable
ENTRY=SGATR_CC		,230	! "C" callable
ENTRY=SGCPYR_CC		,231	! "C" callable
ENTRY=SGDIR_CC		,232	! "C" callable
ENTRY=SGENVV_CC		,233	! "C" callable
ENTRY=SGFATR_CC		,234	! "C" callable
ENTRY=SGNODE_CC		,235	! "C" callable
ENTRY=SGPID_CC		,236	! "C" callable
ENTRY=SGPRT_CC		,237	! "C" callable
ENTRY=SGSDTM_CC		,238	! "C" callable
ENTRY=SGTIM_CC		,239	! "C" callable
ENTRY=SGUSR_CC		,240	! "C" callable
ENTRY=SGVOL_CC		,241	! "C" callable
ENTRY=SMACH_CC		,242	! "C" callable
ENTRY=SMFOPN_CC		,243	! "C" callable
ENTRY=SOPR_CC		,244	! "C" callable
ENTRY=SOPS_CC		,245	! "C" callable
ENTRY=SPAUS_CC		,246	! "C" callable
ENTRY=SPRINT_CC		,247	! "C" callable
ENTRY=SPRSE_CC		,248	! "C" callable
ENTRY=SRDSC_CC		,249	! "C" callable
ENTRY=SRNMF_CC		,250	! "C" callable
ENTRY=SSCHCM_CC		,251	! "C" callable
ENTRY=SSCHED_CC		,252	! "C" callable
ENTRY=SSDIR_CC		,253	! "C" callable
ENTRY=SSPRT_CC		,254	! "C" callable
ENTRY=SSVOL_CC		,255	! "C" callable
ENTRY=SWRSC_CC		,256	! "C" callable
!
ENTRY=SHCUIS		,257	! A11 Addition
ENTRY=SBSUIS		,258	! A11 Addition
ENTRY=SBRUIS		,259	! A11 Addition
ENTRY=SHCX11		,260	! A11 Addition
ENTRY=SBSX11		,261	! A11 Addition
ENTRY=SBRX11		,262	! A11 Addition
ENTRY=SDGETP		,263	! A11 Addition (malloc)
ENTRY=SDGETU		,264	! A11 Addition (realloc)
ENTRY=SDRELP		,265	! A11 Addition (free)
ENTRY=SIMGLD		,266    ! A11 Addition
ENTRY=SC2HS		,267 	! Was missing by mistake
!
