$ !IMGXFR.COM	DYNAMIC TRANSFER VECTOR GENERATOR
$ Set NoVerify
$ Goto START
$ ! ###############################################################
$ ! # (C) Copyright 1985 Auto-trol Technology Corporation         #
$ ! #                                                             #
$ ! # This program is the sole property of Auto-trol Technology   #
$ ! # Corporation and is considered a trade secret and/or a       #
$ ! # proprietary product of Auto-trol Technology Corporation.    #
$ ! # Use or disclosure of this program by other than Auto-trol   #
$ ! # Technology Corporation and its assigned licensees and       #
$ ! # customers is strictly forbidden by law.                     #
$ ! #                                                             #
$ ! # Use, duplication or disclosure by the Government is subject #
$ ! # to restrictions as set forth in subdivision (b)(3)(ii) of   #
$ ! # the Rights in Technical Data and Computer Software clause   #
$ ! # at 252.227.7013.                                            #
$ ! ###############################################################
$ !  /BEGIN MODULE HEADER/           	   /STANDARD MODULE HEADER/
$ !
$ !       NAME -- IMGXFR
$ !
$ !       PURPOSE -- 
$ !	    Generete the Dynamic Transfer Vector module from CTL file
$ !
$ !	  ARGUMENTS --
$ !
$ !	    P1 - ctlfile, Build Control file  
$ !		 For details on file format refer to VAX Image Build Tools.
$ !		 Ctlfile "name" portion applies to any generated files.
$ !   
$ !	    P2 - build ID (rrbb)
$ !
$ !	    P3 - object library for the module, or empty
$ !
$ !	    P4 - OPTIONS, L=Leave MACRO module
$ !
$ !       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
$ !
$ !       NOTES --
$ !
$ !       HISTORY --
$ !         MM/DD/YY,SDRC,functional spec number,initials,comments
$ !	    04/09/87,,,MXB, Added fatal status on error exit
$ !	    02/13/87,,,MXB, Initial definition
$ !
$ !  /END MODULE HEADER/       		    /STANDARD MODULE HEADER/
$ !  *****************************************************************
$ !
$START:
$ SET NoOn				! allow explicit error handling
$ !
$ ! ***** Define our tools:
$ !
$ self = f$envi("Procedure")
$ main = f$par(self,,,"DEVICE")+f$par(self,,,"DIRECTORY")
$ IMG:=$'main'IMGGEN.EXE 		! Build file generator
$ !
$ ERR:=write sys$error			   ! error messages
$ SAY:=write sys$output			   ! notifications
$ DELCMD := DELETE/NoLog/NoConfirm
$ PURCMD := PURGE /NoLog
$ INQCMD := INQUIRE
$ !
$ ! ***** Argument processing
$ !
$GETCTL:
$ if p1 .eqs. "" then $ INQCMD p1 "*IMGXFR, Enter CTL file with XFR definition"
$ CTLFIL=f$searech(f$par(p1,".CTL"))
$ NAME=f$parse(CTLFIL,"NONE.CTL",,"NAME")
$ P1 = ""
$ if CTLFIL .eqs. "" then $ GoTo GETCTL
$ !
$GETDID:
$ if P2 .eqs. "" then $ INQCMD P2 "*IMGXFR, Enter XFR module build  ID  [rrbb]"
$ P2=f$edit(P2,"UPCASE,COLLAPSE")
$ BLDID=f$extract(0,4,P2)
$ if BLDID .eqs. "" then $ GoTo GETDID
$
$GETLIB:
$ if P3 .eqs. "" then $ INQCMD P3 "*IMGXFR, Enter XFR modules library or  NONE"
$ P3=f$edit(P3,"UPCASE")
$ LIBFIL=f$search(f$par(P3,".OLB"))
$ if P3 .eqs. "NONE" .or. P3 .eqs. "" then LIBFIL = "NONE"
$ P3 = ""
$ if LIBFIL .eqs. "" then $ GoTo GETLIB
$ !
$GETOPT:
$ if P4 .eqs. "" then $ INQCMD P4 "*IMGXFR, Leave XFR MACRO  source online [N]"
$ if P4 then P4="L"
$ if f$loc("L",P4+"xxx") .lt. f$len(P4+"xxx") then $ DELCMD := "! "
$ !
$ ! ***** Generate files usinsg IMGGEN.EXE ******
$ !
$ IMG 'CTLFIL NONE NONE 'BLDID X
$ if .not. $Status then $ Exit %X1000000+$status
$ !
$ ! ***** Compile files generated by the IMGGEN run
$ !
$ if f$search("''NAME'_XFR.MAR") .eqs. "" then GoTo NOXFRSRC
$ MACRO /NODEBUG/NOLIST/OBJECT='NAME'_XFR.OBJ 'NAME'_XFR.MAR
$ sts=$STATUS
$ if .not. sts then $ ERR "%IMGXFR-E-XFRMOD, XFR module did not compile"
$ Exit 'sts
$ PURCMD 'NAME'_XFR.OBJ
$ if LIBFIL .nes. "NONE" then LIBRARY/Replace 'LIBFIL 'NAME'_XFR.OBJ/Log
$ if LIBFIL .nes. "NONE" then DELETE 'NAME'_XFR.OBJ;*
$ DELCMD 'NAME'_XFR.MAR;*
$ GoTo Finish
$NOXFRSRC:
$ ERR "%IMGXFR-E-XFRMOD, XFR module was not created !!!"
$ EXIT %X10000004
$FINISH:
$ Exit
