$ !IMGBLD.COM	VAX IMAGE BUILD PROCEDURE
$ Set NoVerify
$ Goto START
$ ! ###############################################################
$ ! # (C) Copyright 1985 Auto-trol Technology Corporation         #
$ ! #                                                             #
$ ! # This program is the sole property of Auto-trol Technology   #
$ ! # Corporation and is considered a trade secret and/or a       #
$ ! # proprietary product of Auto-trol Technology Corporation.    #
$ ! # Use or disclosure of this program by other than Auto-trol   #
$ ! # Technology Corporation and its assigned licensees and       #
$ ! # customers is strictly forbidden by law.                     #
$ ! #                                                             #
$ ! # Use, duplication or disclosure by the Government is subject #
$ ! # to restrictions as set forth in subdivision (b)(3)(ii) of   #
$ ! # the Rights in Technical Data and Computer Software clause   #
$ ! # at 252.227.7013.                                            #
$ ! ###############################################################
$ !  /BEGIN MODULE HEADER/           	   /STANDARD MODULE HEADER/
$ !
$ !       NAME -- IMGBLD
$ !
$ !       PURPOSE -- 
$ !	    VMS DCL command procedure to perform generalized
$ !	    VMS (shareable) images build
$ !
$ !	  ARGUMENTS --
$ !
$ !	    P1 - bldid, Build identification in form rrbb
$ !		 rr = rlease number, bb = build number
$ !
$ !	    P2 - lnmfile, Logical Names definition file in format
$ !	  	 logical_name>pathname
$ !	
$ !	    P3 - ctlfile, Build Control file  for IMGGEN.EXE. For
$ !		 details on file format refer to VAX Image Build Tools.
$ !		 Ctlfile "name" portion applies to any generated files.
$ !   
$ !	    P4 - updfile, Update Control file. Same format as Control
$ !		 file above, updates information contained within it.
$ !		 May be empty or specified as "NONE"
$ ! 
$ !	    P5 - refimg, Reference Image pathname for compatibilty checks
$ !		 if empty or specified as "NONE", only shareability
$ !	         checking will be performed.
$ !
$ !	    P6 - OPTIONS: (any combination of the folowing letters)
$ !		 If none specified, default "S" applies.
$ !		 E - Executable, build an executable image
$ !		 S - Shareable, build a shareable image
$ !		 T - Template, build shareable image STUB
$ !		 N - NoVector, do NOT use shr. image transfer vector
$ !		 D - Debug, Create Debug image
$ !	 	 M - Map, Create image map
$ !		 F - Full, create full map
$ !		 C - Cross, create cross-reference
$ !		 R - Rebuild image if does not satisfy shareability req.
$ !	 	 P - Patch the image MAJOR ID if not compatible to refimg
$ !		 L - Leave, leave (do not delete) support files
$ !		 U - Use object/option files generated by previous run
$ !		 A - Analyze, IMGGEN does not extract commons from SHR images
$ !		 B - NoTraceBack, use LINKER option /NoTraceBack
$ !		 	
$ !	    P7 - target, Target directory (pathname) for created	
$ !		 executable and map file. Default = current directory
$ !
$ !	    P8 - deflt, Default directory to use during the build
$ !		 process, also used for support files.
$ !
$ !	  RETURN GLOBAL SYMBOLS
$ !
$ !	    IMG$LINKSTATUS	- last LINK command status
$ !	    IMG$SHAREABLE	- created image is shareable =1
$ !	    IMG$COMPATIBLE	- created image is compatible with reference one
$ !	    IMG$REBUILD		- image rebuild occured = 1
$ !	    IMG$NEWMAJID	- new major ID (if patched) 
$ !
$ !       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
$ !
$ !       NOTES --
$ !
$ !       HISTORY --
$ !         MM/DD/YY,SDRC,functional spec number,initials,comments
$ !	    08/26/87,,,MXB, MACRO compilations /DEBUG for debugging
$ !	    04/09/87,,,MXB, Converted for IMGGEN.COM, added global symbols
$ !	    02/13/87,,,MXB, Initial definition
$ !
$ !  /END MODULE HEADER/       		    /STANDARD MODULE HEADER/
$ !  *****************************************************************
$ !
$START:
$ SET NoOn				! allow explicit error handling
$ PHASE=0				! Flag initial phase
$ !
$ ! ***** Define our tools:
$ !
$ self = f$envi("Procedure")
$ main = f$par(self,,,"DEVICE")+f$par(self,,,"DIRECTORY")
$ IMG:=$'main'IMGGEN.EXE 		! Build file generator
$ SCA:=$'main'IMGSCA.EXE 		! Image scanner
$ CHK:=@'main'IMGCHK.COM 		! Build results checker
$ !
$ ERR:=write sys$error			   ! error messages
$ SAY:=write sys$output			   ! notifications
$ SAY "%IMGBLD-I-STARTT, Starting   at "+f$time()
$ !
$ IMG$LINKSTATUS==1			   ! last LINK command status
$ IMG$SHAREABLE==1			   ! created image is shareable =1
$ IMG$COMPATIBLE==1			   ! created image is compatible
$ IMG$REBUILD==0			   ! image rebuild occured = 1
$ IMG$NEWMAJID==0			   ! new major ID (if patched) 
$ !
$ ! ***** Argument processing
$ !
$ARGUMENTS:
$ BLDID=f$extract(0,4,P1)
$ if BLDID .eqs. "" then $ ERR "%IMGBLD-F-NOBLDID, Build ID is mandatory"
$ if BLDID .eqs. "" then $ EXIT %X1000004
$ !
$ if P2 .eqs. "" .or. P2 .eqs. "NONE" then P2 = "NL:"
$ LNMFIL=f$search(P2)
$ if P2 .eqs. "NL:" then $ LNMFIL="NL:"
$ if LNMFIL .eqs. "" then $ ERR "%IMGBLD-F-NOLNMF, Logical names file not found"
$ if LNMFIL .eqs. "" then $ EXIT %X1000004
$ !
$ CTLFIL=P3
$ NAME=f$parse(CTLFIL,"NONE.CTL",,"NAME")
$ !
$ UPDFIL=P4
$ if UPDFIL .eqs. "" then $ UPDFIL="NONE"
$ !
$ REFIMG=P5
$ if REFIMG .eqs. "" then $ REFIMG="NONE"
$ !
$ OPTION=P6
$ if OPTION .eqs. "" then $ OPTION="S"
$ !
$ TARGET=f$envir("DEFAULT")
$ if P7 .nes. "" .and. p7 .nes. "NONE" then $ TARGET=P7
$ !
$ if P8 .nes. "" then $ SET DEFAULT 'P8
$ if .not. $status then $ Exit %X1000000+$status
$ !
$ ! ***** Process options, originally assuming NONE has been defined
$ !
$ SHRIMG="N"	! Shareable image generated
$ EXEIMG="N"	! Executable image generated
$ TEMIMG="N"	! Template (stub) image generated
$ DBGIMG="N"	! Debug image generated
$ MAP="N"	! Map required
$ FUL="N"	! Full map required
$ CRO="N"	! Cross reference requred
$ LEAVE="N"	! Leave generated files
$ REBLD="N"	! Rebuild non-shareable image
$ PATIMG="N"	! Patch non-compatible image
$ USEOLD="N"	! Use old files from previous run
$ NOTBK="N"	! Don't create /NoTraceback image
$ x=OPTION+"XXXXXX"
$ if f$locate("S",x).lt.f$len(x) then $ SHRIMG="Y"	! 
$ if f$locate("E",x).lt.f$len(x) then $ EXEIMG="Y"	! 
$ if f$locate("T",x).lt.f$len(x) then $ TEMIMG="Y"	! 
$ if f$locate("D",x).lt.f$len(x) then $ DBGIMG="Y"	! 
$ if f$locate("M",x).lt.f$len(x) then $ MAP="Y"	 	! 
$ if f$locate("F",x).lt.f$len(x) then $ FUL="Y"		! 
$ if f$locate("C",x).lt.f$len(x) then $ CRO="Y"		! 
$ if f$locate("L",x).lt.f$len(x) then $ LEAVE="Y"	! 
$ if f$locate("R",x).lt.f$len(x) then $ REBLD="Y"	! 
$ if f$locate("P",x).lt.f$len(x) then $ PATIMG="Y"	! 
$ if f$locate("U",x).lt.f$len(x) then $ USEOLD="Y"	! 
$ if f$locate("B",x).lt.f$len(x) then $ NOTBK="Y"	! 
$ x="N"
$ if SHRIMG .and. EXEIMG then $ x="Y"			! Check mutualy
$ if EXEIMG .and. TEMIMG then $ x="Y"			! exclusive options
$ if TEMIMG .and. SHRIMG then $ x="Y"
$ if x then $ ERR "%IMGBLD-F-ILLOPT, Illegal combination of options ''OPTION'"
$ if x then $ EXIT %X10000004
$ if USEOLD then LEAVE="Y"				! Using OLD preserve files
$ !
$ ! ***** Define PURGE and DELETE commands here, for ease of debugging
$ !
$ DELCMD := DELETE/NoLog/NoConfirm
$ PURCMD := PURGE /NoLog
$ if LEAVE then $ DELCMD := "! "		! DELETEs commented out
$ !
$ ! ***** Prepare for the IMGGEN RUN
$ !
$ OPTION=OPTION-"D"-"M"-"F"-"C"-"L"-"R"-"P"-"B"	! take out unrelated options
$ ! 
$ ! ***** Prepare symbols for the link phase (LINKIMG:)
$ !
$ IMGOPT = ""
$ IMGFIL = TARGET+NAME+BLDID+".EXE"	! Image file and LINKER command
$ IF TEMIMG then $ IMGFIL = TARGET+NAME+BLDID+".SHR"
$ IF SHRIMG then $ IMGOPT = "/SHAREABLE=" + IMGFIL
$ IF EXEIMG then $ IMGOPT = "/EXECUTABLE="+ IMGFIL
$ IF TEMIMG then $ IMGOPT = "/SHAREABLE=" + IMGFIL
$ IF NOTBK  then $ IMGOPT = IMGOPT + "/NoTRACEBACK"	! Not TRACEBACK image
$ DBGOPT = "/NODEBUG"				
$ IF DBGIMG   then $ DBGOPT = "/DEBUG"	! LINKER Debug commmand
$ MAPOPT = "/NOMAP"
$ MAPFIL = TARGET+NAME+BLDID+".MAP"	! MAP file name
$ if FUL .or. CRO then MAP = "Y"	! MAP name and LINKER commands
$ if MAP then $ MAPOPT = "/MAP="+MAPFIL
$ if FUL then $ MAPOPT = MAPOPT+"/FULL"
$ if CRO then $ MAPOPT = MAPOPT+"/CROSS"
$ RBLFIL=NAME+"_RBL.CTL"		! Rebuild update file name
$ GDSOBJ="N"				! Global Data Size object module created
$ VECOBJ="N"				! Transfer Vector object module created
$ !
$ ! ***** Create logical names using logical names definition file LNMFIL:
$ !       logname>pathname!Comment
$ !
$ OPEN/READ f 'LNMFIL
$ sts = $Status
$ if .not. sts then $ ERR "%IMGBLD-F-OPNLNM, Can not open logical names file "+LNMFIL
$ if .not. sts then $ GoTo FINISH
$LNMLOOP:
$ READ/END=LNMEND f x
$ n1 = f$locate("!",x)			! Look for comment delimiter
$ if n1 .eq. 0 Then $ Goto LNMLOOP	! Skip comment line
$ n2 = f$locate(">",x)			! Locate pathname delimiter
$ DEFINE/NoLog 'f$extract(0,n2,x) 'f$extract(n2+1,n1-1-n2,x)
$ GoTo LNMLOOP				! Loop for next file record
$LNMEND:
$ CLOSE f
$ !
$ ! ***** Two-phase processing, phase 2 re-builds image if our shareability and
$ !       compatibility checks failed.
$ !	
$ PHASE=1				! Flag the first build phase
$ if USEOLD then $ GoTo LINKIMG		! Using OLD files = skip files generation
$ !					! (but only for PHASE1)
$ !
$ ! ***** Generate support files (transfer vector, global data, option file)
$ !
$GENFILES:
$ SAY "%IMGBLD-I-BLDFIL, Building support files for ''NAME' build ''BLDID'"
$ IMG 'CTLFIL 'UPDFIL 'REFIMG 'BLDID 'OPTION
$ if .not. $Status then $ Exit %X1000000+$status
$ !
$ ! ***** Compile files generated by the IMGGEN run
$ !
$ if f$search("''NAME'_VEC.MAR") .eqs. "" then GoTo NOVECSRC
$ MACRO /DEBUG/NOLIST/OBJECT='NAME'_VEC.OBJ 'NAME'_VEC.MAR
$ if .not. $status then $ ERR "%IMGBLD-E-VECMOD, VEC module did not compile"
$ VECOBJ="Y"
$ PURCMD 'NAME'_VEC.OBJ
$ DELCMD 'NAME'_VEC.MAR;*
$NOVECSRC:
$ !
$ if f$search("''NAME'_GDS.MAR") .eqs. "" then GoTo NOGDSSRC
$ MACRO /DEBUG/NOLIST/OBJECT='NAME'_GDS.OBJ 'NAME'_GDS.MAR
$ if .not. $status then $ ERR "%IMGBLD-E-GDSMOD, GDS module did not compile"
$ GDSOBJ="Y"
$ PURCMD 'NAME'_GDS.OBJ
$ DELCMD 'NAME'_GDS.MAR;*
$NOGDSSRC:
$ !
$ ! ***** Perform the image link
$ !
$LINKIMG:
$ SAY "%IMGBLD-I-BLDFIL, Building image   files for ''NAME' build ''BLDID'"
$ LINK 'DBGOPT 'IMGOPT 'MAPOPT 'NAME'_OPT.OPT/OPTION
$ IMG$LINKSTATUS=$STATUS		! Save LINK command status
$ sts = $severity
$ !
$ ! ***** Clean-up (delete / purge support files)
$ !
$                PURCMD 'IMGFIL'
$           	 DELCMD 'NAME'_OPT.OPT;*
$ if GDSOBJ then DELCMD 'NAME'_GDS.OBJ;*
$ if VECOBJ then DELCMD 'NAME'_VEC.OBJ;*
$ if MAP    then PURCMD 'MAPFIL'
$ if sts .ge. 4 then $ GoTo FINISH
$ !
$ ! ***** PHASE1 shareable image checking for shareability
$ !
$ if .not. SHRIMG then $ Goto FINISH	! No checking on EXE or TEMPLATE image
$ SAY "%IMGBLD-I-BLDCHK, Build results checking for ''NAME' build ''BLDID'"
$ if .not. REBLD .or. PHASE .gt. 1 then $ Goto PHASE2 ! No rebuild = use PHASE2
$PHASE1:
$ SCA 'IMGFIL' C NL:			! Check shareability only
$ IMG$SHAREABLE==$STATUS		! Save SHAREABILITY status
$ if IMG$SHAREABLE then $ Goto PHASE2	! Shareable = check compatibility
$ !
$ ! ***** Preparing for image re-build (to guarantee shareability)
$ ! 	  To attempt re-build, we extract all the non-shareable SPSECT names
$ !       from our image (in the CTL file form GLOBAL=name), and append such
$ !       an information to existing update file (or use as a new update file).
$ !
$ SCA 'IMGFIL' S3 'RBLFIL'		! Get non-shareable names: GLOBAL=name
$ if UPDFIL .nes. "NONE" .and. f$search (UPDFIL) .nes. "" then -
     COPY 'RBLFIL','UPDFIL' 'RBLFIL'	! Append creating a new update file
$ PURCMD 'RBLFIL'			! Purge old versions
$ UPDFIL=RBLFIL				! Force merged upddate file usage
$ SAY "%IMGBLD-W-NEWUPD, New update CTL file created: " + f$search(RBLFIL)
$ ERR "%IMGBLD-W-IREBLD, Rebuilding image with added SPSECT definition"
$ PHASE = 2				! Flag rebuild phase
$ IMG$REBUILD=="1"			! Flag rebuild happened
$ Goto GENFILES				! repeat the whole GENFILES
$ !
$ ! ***** Phase 2 checking (after rebuild) merely checks results:
$ !
$PHASE2:
$ if .not. PATIMG then $ CHK 'IMGFIL' "''REFIMG'" 	! Check, don't patch
$ if       PATIMG then $ CHK 'IMGFIL' "''REFIMG'" P	! Check, path if needed
$ !
$ ! ***** Final (cleanup) operations
$ !
$FINISH:
$ if       sts then $ SAY "%IMGBLD-I-FINISH, Completed  at "+f$time()
$ if .not. sts then $ ERR "%IMGBLD-I-FINISH, Terminated at "+f$time()
$ Exit sts
