$ !IMGCHK.COM	IMAGE COMPATIBILITY CHECKER
$ Set NoVerify
$ Goto START
$ ! ###############################################################
$ ! # (C) Copyright 1985 Auto-trol Technology Corporation         #
$ ! #                                                             #
$ ! # This program is the sole property of Auto-trol Technology   #
$ ! # Corporation and is considered a trade secret and/or a       #
$ ! # proprietary product of Auto-trol Technology Corporation.    #
$ ! # Use or disclosure of this program by other than Auto-trol   #
$ ! # Technology Corporation and its assigned licensees and       #
$ ! # customers is strictly forbidden by law.                     #
$ ! #                                                             #
$ ! # Use, duplication or disclosure by the Government is subject #
$ ! # to restrictions as set forth in subdivision (b)(3)(ii) of   #
$ ! # the Rights in Technical Data and Computer Software clause   #
$ ! # at 252.227.7013.                                            #
$ ! ###############################################################
$ !  /BEGIN MODULE HEADER/           	   /STANDARD MODULE HEADER/
$ !
$ !       NAME -- IMGCHK
$ !
$ !       PURPOSE -- 
$ !	    VMS DCL command procedure to perform Shareable
$ !	    image shareability and compatibility checks
$ !
$ !	  ARGUMENTS --
$ !
$ !	    P1 - checked image pathname (mandatory)
$ !
$ !	    P2 - reference image pathname for compatibilty checks
$ !		 if empty or specified as "NONE", only shareability
$ !	         checking will be performed
$ !
$ !	    P3 - OPTIONS: (any combination of the folowing letters)
$ !		 P = PATCH an incompatible image, increase the MAJOR ID
$ !
$ !	  RETURN GLOBAL SYMBOLS
$ !
$ !	    IMG$SHAREABLE==1	created image is shareable =1
$ !	    IMG$COMPATIBLE==1   created image compatible with a ref. one
$ !	    IMG$NEWMAJID==0	new major ID (if patched) 
$ !
$ !       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
$ !
$ !	    Proocedure uses the IMGSCA programm to extract the GSD
$ !	    information from the shareable image.
$ !	    
$ !	    If shareability checking only is required, the IMGSCA
$ !	    is used in direct check mode; IMGSCA should report any
$ !	    non-shareable PSECTs, and return appropriate status.
$ !	    
$ !	    If compatibility checking is required, IMGSCA is used
$ !	    to generate full list of PSECTs in each image, and both
$ !	    lists are compared. If those match, images are considered
$ !	    compatible. 
$ !	    Otherwise, an error message is issued, and if the PATCH 
$ !	    is specified, the MAJOR image ID will be increased
$ !	    using the VMS PATCH utility.
$ !	    
$ !       NOTES --
$ !	    Currently, no ENTRY POINTS compatibility checking is
$ !	    implemented. This may happen later, since IMGSCA
$ !	    provides all the tools necessary.
$ !
$ !       HISTORY --
$ !         MM/DD/YY,SDRC,functional spec number,initials,comments
$ !	    04/09/87,,,MXB, added global symbols IMG$xxxx
$ !	    10/23/86,,,MXB, Initial definition
$ !
$ !  /END MODULE HEADER/       		    /STANDARD MODULE HEADER/
$ !  *****************************************************************
$ !
$START:
$ SET NoOn				! allow explicite error handling
$ !
$ !	Define commonly used abbreavitions, etc.
$ !
$ self = f$envi("Procedure")
$ main = f$par(self,,,"DEVICE")+f$par(self,,,"DIRECTORY")
$ SCA:=$'main'IMGSCA.EXE 		! Image scanner
$ SAY:=write sys$output			! messages shorthand
$ ERR:=write sys$error			! error messages
$ log:="/NoLog" 			! Do not LOG deleted/purged files
$ Del*ete:=Del/Noconfirm		!   indirect files
$ !
$ IMG$SHAREABLE==1			! created image is shareable =1
$ IMG$COMPATIBLE==1			! created image is compatible with ref.
$ IMG$NEWMAJID==0			! new major ID (if patched) 
$ !
$ !	Argument processing
$ !
$ARGUMENTS:
$ image=f$parse(p1,".EXE;0",,,"SYNTAX_ONLY")	! process image name
$ image=f$search(image)				!
$ if image .eqs. "" then $ ERR "%IMGCHK-F-NOIMGE, Image ''P1' does not exist"
$ if image .eqs. "" then $ EXIT %X1000004
$ refimg=""					! assume no reference image
$ if p2 .eqs. "" .or. p2 .eqs. "NONE" then $ Goto OPTIONS
$ refimg=f$parse(p2,".EXE;0",,,"SYNTAX_ONLY")	! process reference image name
$ refimg=f$search(refimg)				!
$ if refimg .eqs. "" then $ ERR "%IMGCHK-F-NOREF, Reference ''P1' does not exist"
$ if refimg .eqs. "" then $ EXIT %X1000004
$ !	
$ !	Default options setup
$ !
$OPTIONS:
$ PATIMG="NO"				! Do not patch an incompatible image
$ !	
$ !	Process options, if any
$ x=p3+"XXXXXX"
$ if f$locate("P",x).lt.f$len(x) then $ PATIMG="YES"	! Patch image
$ !
$ !	SHAREABILITY CHECKING
$ !
$SHAREABILITY:
$ SCA 'image C nl:					! Check for NOSHR
$ IMG$SHAREABLE==$STATUS				! save status for user
$ stat = IMG$SHAREABLE					!
$ if .not. stat then $ ERR "%IMGCHK-E-NOSHRI, Image ''image' not SHAREABLE"
$ if refimg .eqs. "" then $ EXIT %X10000002		! Report non-share
$ !
$ !	COMPATIBILITY CHECKING
$ !
$COMPATIBILITY:
$ SCA 'image  S2 newimage.tmp				! Scan new image
$ if .not. $Status then $ Goto PROCERR
$ SCA 'refimg S2 refimage.tmp				! Scan reference image
$ if .not. $Status then $ Goto PROCERR
$ Diff /Out=nl:/Comment=COLON/Ignore=Comm newimage.tmp refimage.tmp
$ if $status .eq. %X6C8009 then $ Goto COMPENTRY	! No difference
$ ERR "%IMGCHK-E-INCOMP, Global data incompatible "
$ IMG$COMPATIBLE=0					! Tell  user bad news
$ diffil=f$parse(image,,,"name")
$ diffil=f$parse(diffil,".dif",,)
$ Diff /Out='diffil/Comment=COLON/Ignore=Comm newimage.tmp refimage.tmp
$ SAY "%IMGCHK-I-DIFFIL, Differences are in file ''diffil'"
$ Del'log newimage.tmp;*,refimage.tmp;*			! clean-up
$ if PATIMG then $ Goto PATCHIMG				!
$ EXIT %X10000002					! report incompat. img
$COMPENTRY:
$ ! Entry point testing not implemented as of yet
$ Del'log newimage.tmp;*,refimage.tmp;*			! Clean-up
$ EXIT %X10000001					! Compatible images
$ !
$ ! Patch the incompatible image to raise the imager major ID
$ !
$PATCHIMG:
$ if f$search("imagepat.tmp") .nes. "" then $ Del imagepat.tmp;*
$ assign/user nl: sys$output				! Suppress any messages
$ assign/user nl: sys$error
$ PATCH/Absolute/Jou=imagepat.tmp 'image		! Get the Major ID
set mode hex						! Set hexadecimal
exam 00024						! Exam IHD$L_IDENT
exit
$ if .not. $status then $ Goto PROCERR			! Error during patch
$ Open/Read/Err=PROCERR f imagepat.tmp			! read the patch jnl
$PATCHLOOP:						! to get the Major ID
$ READ/END=PROCERR f x					! value
$ if f$extract(0,9,x) .nes. "00000024:" then $ Goto PATCHLOOP
$ Close f
$ MAJID = %X'f$extract(11,2,x)				! Extract Major ID
$ SAY "%IMGCHK-I-OLDMID, Old image ''image' MAJOR ID = ''MAJID'"
$ MAJID=MAJID+1						! Create a new one
$ IMG$NEWMAJID==MAJID					! Save ID for user
$ Open/Write/Err=PROCERR f imagepat.tmp			! Create a PATCH
$ write f image						! command file
$ write f "set mode decimal"				! to set a new Major ID
$ write f "deposit/byte 39=''MAJID'"			! in the image header
$ write f "update"					!
$ close f
$ assign/user nl: sys$output				! Suppress any messages
$ assign/user nl: sys$error
$ PATCH/Absolute/Journal=NL:/NoNew @imagepat.tmp	! Set a new Major ID
$ if .not. $status then $ Goto PROCERR
$ Del'log imagepat.tmp;*				! Clean up
$ SAY "%IMGCHK-W-NEWMID, New image ''image' MAJOR ID = ''MAJID'"
$ EXIT %X10000002					! image incompatible
$ !
$ ! Inter-procedure errors catch-all
$ !
$PROCERR:
$ ERR "%IMGCHK-F-PROCER, Processing error in IMGCHK, abnormal termination"
$ EXIT %X10000004					! fatal exit
