	Subroutine IMGCOM(NAM,GEN,COM)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGCOM
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Create the "Global Data Size" definition module
C
C       CALLING SEQUENCE --
C		Call IMGCOM(NAM,GEN,COM)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C	
C	Ther GDS module declares all the prescribed global data sections
C	(Fortran COMMON) using explicitly given size. Thus, even if such
C	data are not used by particular image build, or current data size
C	is smaller, the build will be forced to contain explicitly given
C	global data size.
C	Intended to maintain image compatibility
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	include	'IMGPAR'
	include 'IMGDAT'
C
C ARGUMENTS --
	Character*(*)	NAM	! generic name (for module file, name etc)
	Record/SGENP/	GEN	! general parameters
	Record/SCOMM/	COM	! Global Data names structure
C
C LOCAL VARIABLES --
	Integer 	I	! Utility variable
	Integer		LUN	! Lun for fortran I/O
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
  10	Format (a)		! Output character string format
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Open our output file
C
	Call lib$get_lun(LUN)
	if (LUN.le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (unit=Lun,name=nam//'_GDS.MAR',
     1	      type='NEW',CARRIAGECONTROL='LIST', ERR=100)
	Goto 500
 100	Call IMGSIG('F-OPNERR, error opening global data module file')
	Close (Unit=Lun)
 	Call lib$free_lun(Lun)
C
C	Create the code header of the GLOBAL DATA definition module.
C	
 500	write(Lun,10)'	.TITLE	'//nam//'_COM GLOBAL DATA module'
	write(Lun,10)'	.IDENT	/'//GEN.BLDID//'/'
	write(Lun,10)';+'
	write(Lun,10)';	(C) Auto-trol Technology Corporation 1987'
	write(Lun,10)';'
	write(Lun,10)';	This module contains global data size definitions'
	write(Lun,10)';	for shareable image '//nam
	write(Lun,10)';	Created  '//GEN.DATE
	write(Lun,10)';	by       '//GEN.USER
	write(Lun,10)';	from     file '//GEN.CTLFI(:GEN.LCTLF)
	write(Lun,10)';	using    IMGGEN '//GEN.VERS
	write(Lun,10)';-'
C
C	Generate individual GLOBAL data entries, each represented by
C	a single PSECT statement and BLKB size definition.
C
C	COM.D(i).UTL defines data type:
C	 '7FFFFFFF'X = defined as GLOBAL in CTL file, no size given
C	  > 0        = defined as GLOBAL in CTL file, size given OR
C		       extracted size from "reference image"
C	  = 0	     = GLOBAL data extracted from shareable image
C	  < 0        = LOCAL data
C
C	Global data entries in "Global Data Size" definition module are
C	genereted for explicitly defined sizes, t.e. sizes either
C	explicitly given in a CTL file, or coming from a "reference image".
C
	Do i=1,COM.NUM
	   if (COM.D(i).UTL.gt.0 .and. COM.D(i).UTL.ne.'7FFFFFFF'X) then
	      write(Lun,10)'	.PSECT	'//
     $		        COM.BUF(COM.D(i).FIR:COM.D(i).LAS)//
     $			',PIC,OVR,REL,GBL,SHR,NOEXE,RD,WRT,LONG'
	      write(Lun,'(a,I8.8)')'	.BLKB	',COM.D(i).UTL
	   end if
	End Do
	write(Lun,10)'	.END'
	close(Lun)
	Call lib$free_lun(Lun)
	Return
	END
