     	Subroutine IMGCTL(FILE,GEN,FIL,MOD,CLU,ENT,COM,OPT,SHR,TYPE)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGCTL
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		Open and process the input CTL file.
C
C       CALLING SEQUENCE --
C     		Call IMGCTL(FILE,GEN,FIL,MOD,CLU,ENT,COM,OPT,SHR,TYPE)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	   This routine handles CTL file access including CTL
C	   files nesting. It pre-processes the input record
C	   skipping any comments.
C	   Compressed and collapsed, uppercase record is passed
C	   to the IMGPRS for final parsing.
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	INCLUDE		'IMGPAR'	! Parameters
	INCLUDE		'IMGDAT'	! Structures definitions
C
C ARGUMENTS --
	Character*(*)	FILE		! primary input control file
	RECORD/SGENP/	GEN		! General purpose parameters
	RECORD/SFILE/	FIL		! Image files
	RECORD/SMODU/	MOD		! Module names
	RECORD/SCLUS/	CLU		! Image clusters
	RECORD/SENTR/	ENT		! Image entry points
	RECORD/SCOMM/	COM		! Image commons
	RECORD/SOPTI/	OPT		! Image link options
	RECORD/SSHRI/	SHR		! Shareable image names
	Character*(*)	TYPE		! processing type (U=update)
C
C LOCAL VARIABLES --
	Logical		UPD		! update path (call) flag
	Integer*4	LVL		! nested file level (1=first file)
	Character*(pl)	FILES(mn)	! nested control file(s)
	Integer*4	LUNS(mn)	! and corresponding LUN(s)
	Logical*1	NOSIZE(mn)	! /NOSIZE flag for nested file level
C
	Character*(pl)	rec		! Input record (pathname length)
	Integer*4	ICLU		! Current CLUSTER index
	Integer*4	lrec		! record length
	Integer*4	i,j		! temporrary
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Checks for the proper execution type: INItial or UPDate
C
	UPD=.false.					! Assume not UPD
	If (TYPE(:1).eq.'U') UPD=.true.			! - update run
C
C	Set-up to start the first file processing
C
	NOSIZE(1)=.false.				! Valid sizes
	FILES(1)=FILE					! Copy filesp
	LVL=0						! No file open
	ICLU=0						! default cluster
C
C	Main control, opens (nested) files, reads records
C
1000	LVL=LVL+1
	Call lib$get_lun(LUNS(LVL))
	if (LUNS(LVL).le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (unit=LUNS(LVL),name=FILES(LVL),defaultfile='.CTL;0',
     1	      type='OLD',readonly, shared, ERR=1100)
	INQUIRE(UNIT=LUNS(LVL),name=REC)		! Get the actual
	lrec=index(REC,' ')-1				! file name and length
	If (.not.UPD) then
	   GEN.CTLFI=REC				! Save name for 
	   GEN.LCTLF=lrec				! generated headers
	else
	   GEN.CTLFI=GEN.CTLFI(:GEN.LCTLF)//' '//REC(:lrec)
	   GEN.LCTLF=GEN.LCTLF+lrec+1			! Update for headers
	end if
	Goto 1500
1100	Call IMGSIG('W-OPNERR, error opening CTL file '//FILES(LVL))
1200	Close (Unit=LUNS(LVL))
	Call lib$free_lun(LUNS(LVL))
	LVL=LVL-1
C
C	Get record, skip empty ones, remove comments
C
1500	if (LVL.lt.1) Return
	READ(LUNS(LVL),'(qa)',ERR=1200,END=1200) lrec,rec
	if (lrec.lt.1) Goto 1500				! Skip empty
	if (rec(1:1).eq.'!' .or. rec(1:1).eq.'#') Goto 1500	! Skip comments
	i=index(rec(1:lrec),'!')				! Remove any
	if (i.ne.0) lrec=i-1					! trailing 
	i=index(rec(1:lrec),'#')				! comments
	if (i.ne.0) lrec=i-1					!
	j=0
	do i=1,lrec						! remove any
	   if(rec(i:i).gt.' ') then				! blanks, tabs
	   j=j+1						! or special
	   rec(j:j)=rec(i:i)					! characters
	   end if
	end do
	lrec=j
	if (lrec.lt.2) Goto 1500				! Skip empty
C
C	Process nested (indirect) file reference
C	Supported format: @pathname/[no]SIZE	!# comment
C
	if (rec(1:1).eq.'@') then				! nested file
	   FILES (LVL+1)=rec(2:index(rec(1:lrec)//'/','/')-1)	! Extract filesp
	   NOSIZE(LVL+1)=(index(rec(1:lrec),'/NOSI').ne.0)	! set/NOSIZE key
	   Goto 1000						! Open new file
	end if 
C
C	Single control record processing
C
	Call STR$UPCASE(rec(:lrec),rec(:lrec))			! Fold up
     	Call IMGPRS (rec(:lrec),GEN,FIL,MOD,CLU,ENT,COM,OPT,SHR,
     $		ICLU,NOSIZE(LVL),UPD)
	GoTo 1500
	End
