C	IMGDAT.INC	IMGGEN Data Structures
C
C	NOTE: This definition file assumes all the IMGPAR Parameters
C	      have been allready defined by including IMGPAR.
C
C	Since the "name" (or "record") sizes stored vary significantly,
C	it would be very inefficient to use fixed-length storage.
C	Therefore, we use a DESCRIPTOR, which contains the first and 
C	last character subscripts for the "name" stored in a character
C	buffer. Descriptor is used in the main structure declaration.
C
C	Example of access to a "name" using this approach:
C	file-string=FIL.BUF(FIL.D(index).FIR:FIL.D(index).LST)
C       file-length=1+FIL.D(index).LAS-FIL.D(index).FIR
C
	STRUCTURE /DSC20/	! "name" descriptor, no utility variable
	  INTEGER*2 FIR		! "name" first character (up to 32k)
	  INTEGER*2 LAS		! "name" last character  (up to 32k)
	END STRUCTURE
C
C	For some items, we need a "utility" variable as well,
C	therefore we define several flavours of the descriptor.
C
	STRUCTURE /DSC24/	! "name" descriptor with Longword UTL
	  INTEGER*2 FIR		! "name" first character (up to 32k)
	  INTEGER*2 LAS		! "name" last character  (up to 32k)
	  INTEGER*4 UTL		! "name" utility variable, LONGWORD
	END STRUCTURE
C
	STRUCTURE /DSC22/	! "name" descriptor with a Word UTL
	  INTEGER*2 FIR		! "name" first character (up to 32k)
	  INTEGER*2 LAS		! "name" last character  (up to 32k)
	  INTEGER*2 UTL		! "name" utility variable, WORD
	END STRUCTURE
C
	STRUCTURE /DSC222/	! "name" descriptor with 2 util. values
	  INTEGER*2 FIR		! "name" first character (up to 32k)
	  INTEGER*2 LAS		! "name" last character  (up to 32k)
	  INTEGER*2 LEN		! "name" utility LEN variable, WORD
	  INTEGER*2 FIL		! "name" utility FIL variable, WORD
	END STRUCTURE
C
	STRUCTURE /SGENP/		! General (overall) parameters
	  INTEGER*2	LCTLF		! - control file name length
	  INTEGER*4 	TBSIZ		! - vector table size
	  INTEGER*2	LIMAG		! - dyn.load image name length
	  INTEGER*2     LERRO		! - dyn.load error handler name length
	  CHARACTER*(04)BLDID		! - build ident
	  CHARACTER*(18)DATE		! - current date
	  CHARACTER*(32)USER		! - user name
	  CHARACTER*(pl)CTLFI		! - control file pathname
	  CHARACTER*(pl)IMAGE		! - dyn.load image name
	  CHARACTER*(pl)ERROR		! - dyn.load error handler
	  CHARACTER*(04)VERS  		! - IMGGEN programm version
	  Integer*2	FILNUM		! - number of files in 1st CTL file
	END STRUCTURE
C
	STRUCTURE /SFILE/		! File names and cluster pointers
	  INTEGER*4 	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC22/    D(mfil)
	  CHARACTER*(bfil) BUF
	END STRUCTURE
C
	STRUCTURE /SMODU/		! Module names and file pointers
	  INTEGER*4 	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC222/    D(mmod)
	  CHARACTER*(bmod) BUF
	END STRUCTURE
C
	STRUCTURE /SCLUS/		! Cluster names
	  INTEGER*4	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC20/    D(mclu)
	  CHARACTER*(bclu) BUF
	END STRUCTURE
C
	STRUCTURE /SCOMM/		! Common names and sizes
	  INTEGER*4	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC24/    D(mcom)
	  CHARACTER*(bcom) BUF
	END STRUCTURE
C
	STRUCTURE /SENTR/		! Entry names
	  INTEGER*4	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC20/    D(ment)
	  CHARACTER*(bent) BUF
	END STRUCTURE
C
	STRUCTURE /SOPTI/		! Option lines
	  INTEGER*4	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC20/    D(mopt)
	  CHARACTER*(bopt) BUF
	END STRUCTURE
C
	STRUCTURE /SSHRI/		! Shareable images
	  INTEGER*4	   NUM
	  INTEGER*4	   FREE
	  RECORD/DSC20/    D(mshr)
	  CHARACTER*(bshr) BUF
	END STRUCTURE
