	PROGRAM IMGGEN
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/             	/STANDARD MODULE HEADER/
C
C       NAME -- IMGGEN
C
C       PURPOSE -- CREATE all files required for IMAGE build  from
C	           input control file(s)
C
C       RESTRICTIONS -- VMS/VAX specific support routine
C
C	CALLING SEQUENCE --
C	        $IMGGEN ctlfil updfil refimg bldid opt
C
C	INPUT --
C
C	OUTPUT --
C
C       ERRORS DETECTED -- Signalled on sys$output
C
C       EXTERNAL REFERENCES -- see external declaration
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  01/14/88,MXB,Fixed "T" option fix again
C	  06/18/87,MXB,Fixed "T" option = don't use files, clusters, but commons
C	  04/09/87,MXB,Added Analyze option (Don't scan /SHR images)
C	  09/05/86,MXB,Initial code
C
C  /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C  *****************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
C
	Include		'IMGPAR'
C
C   Command line processing data
C
	Character*256  	CMDLIN	! Command line with cmd. file names
	Character*(pl)	ARG(5)	! Parsed arguments, equivalenced to:
	Character*(pl)	CTLFIL	! - Control file pathname
	Character*(pl)	UPDFIL	! - Update file pathname
	Character*(pl)	REFIMG	! - Reference image pathname
	Character*(pl)	IDPARA	! - Build ID parameter
	Character*(pl)	OPTSTR	! - Options string
	Character*64	NAM	! Component name extracted form Control file

C	
	Integer	      	LCMD	! Command name
	Integer		LARG(5)! Argument lengths, equivalenced to:
	Integer	      	LCTL	! - Control file pathname length
	Integer		LUPD	! - Update  file pathname length
	Integer		LREF	! - reference image pathname
	Integer		LIDA	! - Bld ID argument
	Integer		LOPT	! - Options string length
	Integer		LNAM	! Name length
C
	Logical		OPTTEM
	Logical		OPTEXE
	Logical		OPTSHR
	Logical		OPTVEC
	Logical		OPTXFR
	Logical		OPTCOM
	Logical		OPTOPT
	Logical		OPTSSH			! Scan Shareable Images (NO=A)
C
	Character*1	CH			! Single utility character
	Integer		I,J,K,L			! Utility variables
	Integer		IARG			! Argument #
	integer*2 	itmlst(8)		! Item list, WORDS
	integer*4 	Litmlst(4)		! Item list, LONGWORDS
	equivalence 	(itmlst(1), litmlst(1)) 
C
	INCLUDE		'IMGDAT'		! Structures definitions
	RECORD/SGENP/	GEN
	RECORD/SFILE/	FIL
	RECORD/SMODU/	MOD
	RECORD/SCLUS/	CLU
	RECORD/SENTR/	ENT
	RECORD/SCOMM/	COM
	RECORD/SOPTI/	OPT
	RECORD/SSHRI/	SHR
C	
C
C EQUIVALENCES 
	EQUIVALENCE	(ARG(1),CTLFIL)
	EQUIVALENCE	(ARG(2),UPDFIL)
	EQUIVALENCE	(ARG(3),REFIMG)
	EQUIVALENCE	(ARG(4),IDPARA)
	EQUIVALENCE	(ARG(5),OPTSTR)
	EQUIVALENCE	(LARG(1),LCTL)
	EQUIVALENCE	(LARG(2),LUPD)
	EQUIVALENCE	(LARG(3),LREF)
	EQUIVALENCE	(LARG(4),LIDA)
	EQUIVALENCE	(LARG(5),LOPT)
C
C EXTERNALS --
C
	external LIB$GET_FOREIGN		! VMS GET command line
	external SYS$EXIT			! VMS exit
	integer	 sys$getjpiw			! System services called
	integer	 sys$getsyiw			!
	external jpi$_username
	external syi$_nodename
C
C DATA STATEMENTS --
C
C
C  /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C  *****************************************************************
C
C START OF EXECUTABLE CODE --
C
	GEN.VERS='0101'				! Set up program version
C
C	Get or inquire command line 
C
	Call LIB$GET_FOREIGN(CMDLIN,'IMGGEN>',LCMD)
	If (LCMD.eq.0) Call IMGSIG('F-NOCMD, no command line')
C
C	Simple command line parsing assumes the command has a format:
C
C	IMGGEN>  arg1  [arg2  arg3 arg4 arg5]
C
C	Any argument may be specified as NONE or ""
C	
	Do i=1,5
	   ARG(i)=' '				! Initialize all arguments
	End do
	IARG=0
	J=0					! Set the "out of name" flag
	Do I=1,LCMD+1				! Scan the command line
	   CH=CMDLIN(I:I)			! 
	   if (J.ne.0) then			! J nonzero = within argument
	      if (ch.le.' '.or.I.eq.LCMD+1)then ! This is argument terminator
	        if (IARG.eq.5) Call IMGSIG('F-TOOARG, Too many arguments')
	        IARG=IARG+1			! nex argument
	        ARG (IARG)=CMDLIN(J:I-1)	! save argument string
	        LARG(IARG)=I-J			! and length
	        J=0				! set out-of argument flag
	      end if				! 
	   else					! Out of argument
	      if (ch.gt.' ') J=I		! Non-blank = argument start
	   end if
	end do
	if (IARG.lt.1) Call IMGSIG('F-INSARG, Insufficient arguments')
	Do i=1,5
	if (ARG(i).eq.'NONE' .or. ARG(i).eq.'""') then
	    ARG(i)=' '				! Set argument blank, if
	    LARG(i)=0				! specified as NONE or ""
	end if
	end do
C
	if (LCTL.eq.0) Call IMGSIG('F-NOCTL, No input CTL file')
	if (LOPT.eq.0) then
	   Call IMGSIG('W-NOOPTI, No build options, S assumed ')
	   OPTSTR='S'
	   LOPT=1
	end if
	if (LIDA.eq.0) then
	   Call IMGSIG('W-NOBLDI, No build ID, XXXX assumed ')
	   GEN.BLDID='XXXX'
	   LIDA=4
	else
	   GEN.BLDID=IDPARA(:4)
	end if
C
C	Process the options specified:
C
	OPTVEC=.true.			! Build vector
	OPTOPT=.true.			! Build OPTION file
	OPTCOM=.true.			! Build COMMONS file
	OPTSSH=.true.			! Scan shareable image
	if (index(OPTSTR(:LOPT),'T') .ne. 0 ) OPTTEM=.true.
	if (index(OPTSTR(:LOPT),'E') .ne. 0 ) OPTEXE=.true.
	if (index(OPTSTR(:LOPT),'S') .ne. 0 ) OPTSHR=.true.
	if (index(OPTSTR(:LOPT),'N') .ne. 0 ) OPTVEC=.false.
	if (index(OPTSTR(:LOPT),'V') .ne. 0 ) OPTVEC=.true.
	if (index(OPTSTR(:LOPT),'X') .ne. 0 ) OPTXFR=.true.
	if (index(OPTSTR(:LOPT),'A') .ne. 0 ) OPTSSH=.false.
	if (OPTEXE.or.OPTXFR) then
	    OPTVEC=.false.
	    OPTCOM=.false.
	    OPTSHR=.false.
	    OPTTEM=.false.
	end if
	if (OPTEXE) OPTXFR=.false.
	if (OPTSHR) OPTTEM=.false.
	if (OPTXFR) OPTOPT=.false.
C
C	Initialize the process-wide data
C
	GEN.DATE(10:10)=' '
	Call DATE(GEN.DATE(1:9))
	Call TIME(GEN.DATE(11:18))
	GEN.CTLFI=CTLFIL(:LCTL)
	GEN.LCTLF=LCTL
	I=0					! Preset for Left Parenthesis
	LNAM=1					! Use for updated line begin
	Call IMGPLL(CTLFIL,LNAM,LCTL,i,j,k,l)	! Parse line, get "name"
	NAM=CTLFIL(k:l)				!
	LNAM=l-k+1				!
	GEN.TBSIZ=0				! Transfer Vector Table size 
	GEN.LIMAG=0				! Dyn.Load Image length
	GEN.LERRO=0				! Dyn.Load Errir handler
	FIL.NUM =0				
	FIL.FREE=1			
	MOD.NUM =0
	MOD.FREE=1
	CLU.NUM =0				! Initialize all data
	CLU.FREE=1				! structures to:
	ENT.NUM =0				! - no entries,
	ENT.FREE=1				! - first char. free
	COM.NUM =0
	COM.FREE=1
	OPT.NUM =0	
	OPT.FREE=1
	SHR.NUM =0
	SHR.FREE=1
C	
C	Use $GETSYIW, $GETJPI to built user identification in form:
C	node:: user
C
	itmlst(1)  = 15				! nodename buffer length
 	itmlst(2)  = %loc(syi$_nodename)	! item code = node name
	litmlst(2) = %loc(GEN.USER)		! nodename buffer addr
	litmlst(3) = %loc(i)			! resulting length addr
	litmlst(4) = 0				! end of list
	j = sys$getsyiw(,,,itmlst,,,)
	GEN.USER(i+1:i+2)='::'			! load delimiter
	itmlst(1)  = len(GEN.USER)-i-3		! username buffer length
 	itmlst(2)  = %loc(jpi$_username)	! item code = user name
	litmlst(2) = %loc(GEN.USER(i+3:))	! username buffer address
	litmlst(3) = %loc(k)			! resulting length addr
	litmlst(4) = 0				! four bytes for mode
	j = sys$getjpiw(,,,itmlst, ,,,,)
	GEN.USER(i+3+k:)=' '			! load trailing spaces
C
C	M A I N L I N E    P R O C E S S I N G
C
C	Process the main INPUT control file with intialization
C
	Call IMGCTL(CTLFIL(:LCTL),GEN,FIL,MOD,CLU,ENT,COM,OPT,SHR,'I')
	GEN.FILNUM = FIL.NUM		! Save number of files on CTL file
C
C	Process the UPDATE control file (if any)
C
	If (LUPD.gt.0) 
     1	   Call IMGCTL(UPDFIL(:LUPD),GEN,FIL,MOD,CLU,ENT,COM,OPT,SHR,'U')
C
C	Process SHAREABLE IMAGES (if any), and reference image (if any)
C	For shareable image ignore data sizes, for reference use size.
C	Option A (Analyze) supresses that to see common mismatches
C
	If ( OPTSSH .and. (.not. OPTXFR)) then	! Don't look at them for XFER
	   Do i=1,SHR.NUM
	     Call IMGSHR(COM,SHR.BUF(SHR.D(i).FIR:SHR.D(i).LAS),.false.)
	   End do
	   If (LREF.gt.0) Call IMGSHR(COM,REFIMG(:LREF),.true. )
	End if
C
C	Create the TRANSFER VECTOR module file
C
	If ( OPTVEC )			! Regular VECTOR required
     1	   Call IMGVEC(NAM(:LNAM),GEN,ENT,.false.)
	If ( OPTTEM )			! Dummy VECTOR required
     1	   Call IMGVEC(NAM(:LNAM),GEN,ENT,.true.)
C
C	Create the DYNAMIC TRANSFER module file
C
	If ( OPTXFR )			! Dummy VECTOR required
     1	   Call IMGXFR(NAM(:LNAM),GEN,ENT)
C
C	Create the GLOBAL DATA (common) definition file
C
	If ( OPTCOM )			! Common module required
     1	   Call IMGCOM(NAM(:LNAM),GEN,COM)
C
C	Create the LINKER option file
C
	If ( OPTOPT  ) then		! Linker Option file required
	   if (OPTTEM) then
	      GEN.FILNUM = 0		! No files in regular file
              FIL.NUM = 0		! No files in update file
	      CLU.NUM = 0		! No clusters in template
	   end if			
     	   Call IMGOPT(NAM(:LNAM),GEN,FIL,CLU,ENT,COM,OPT,OPTVEC,OPTCOM)
	end if
C
	Call sys$exit(%val(1))
	END
