	Subroutine IMGOPT(NAM,GEN,FIL,CLU,ENT,COM,OPT,OPTVEC,OPTCOM)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGOPT
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Generate the LINKER OPTIONS file
C
C       CALLING SEQUENCE --
C		Call IMGOPT(NAM,GEN,FIL,CLU,ENT,COM,OPT,OPTVEC,OPTCOM)
C
C       COMMON REFERENCES --
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C	   This module creates a LINKER options file according
C	   to build requirements collected in passed data structures.
C	   OPTIONS file contains:
C	   - file header
C	   - all the LINKERT options
C	   - all the files included in the DEFAULT CLUSTER
C	   - all the files included in explicit clusters
C	   - GLOBAL data PSECT definitions as NOSHR
C	   - GLOBAL data COLLECT statements for explicitly given GLOBALs
C	   - LOCAL  data PSECT definition as NOSHR,LCL
C	   - UNIVERSAL option for all the entry points
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  08/25/87,,,MXB,Fix cluster loading in case uof update file
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	include	'IMGPAR'
	include 'IMGDAT'
C
C ARGUMENTS --
	Character*(*)	NAM	! generic name (for module file, name etc)
	Record/SGENP/	GEN	! general parameters
	Record/SFILE/	FIL	! file names structure
	Record/SCLUS/	CLU	! cluster names structure
	Record/SCOMM/	COM	! common (global data) names structure
	Record/SOPTI/	OPT	! options structure
	Record/SENTR/	ENT	! entry names structure
	Logical		OPTVEC	! Transfer vector module used
	Logical		OPTCOM	! Forced common sizes module used
C
C LOCAL VARIABLES --
	Integer 	I,K	! Utility variables
	Integer		LUN	! Lun for fortran I/O
	Integer		LSAV	! Saved string length
 	Character*256	SSAV	! String save
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
  10	Format (a)		! Output character string format
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Open our output file
C
	Call lib$get_lun(LUN)
	if (LUN.le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (unit=Lun,name=nam//'_OPT.OPT',
     $	      type='NEW',CARRIAGECONTROL='LIST', ERR=100)
	Goto 500
 100	Call IMGSIG('F-OPNERR, error opening option file')
	Close (Unit=Lun)
 	Call lib$free_lun(Lun)
C
C	Create the header of the LINKER OPTION file
C	
 500	write(Lun,10)'! '//nam//'_OPT VMS LINKER Option file '
	write(Lun,10)'! '//nam//' build '//GEN.BLDID
	write(Lun,10)'! '
	write(Lun,10)'! (C) Auto-trol Technology Corporation 1987'
	write(Lun,10)'! '
	write(Lun,10)'! Created  '//GEN.DATE
	write(Lun,10)'! by       '//GEN.USER
	write(Lun,10)'! from     file '//GEN.CTLFI(:GEN.LCTLF)
	write(Lun,10)'! using    IMGGEN '//GEN.VERS
	write(Lun,10)'! '
C
C	Generate all the LINKER explicite OPTIONS
C
	Do i=1,OPT.NUM
	   write(Lun,10) OPT.BUF(OPT.D(i).FIR:OPT.D(i).LAS)
	End Do
C
C	If the TRANSFER VECTOR is used, force it into image:
	if (OPTVEC) then
	   write(Lun,10)'! '
     	   write(Lun,10)'CLUSTER=TRANSFER_VECTOR,,,'//nam//'_VEC.OBJ'
	end if
C
C	If any GLOBAL DATA are used, prescribe cluster for it:
C	NOTE, any GLOBAL DATA are forced there by COLLECT option
C	even if the MACRO common definition module is not used.
	if (OPTCOM) then
	   write(Lun,10)'! '
           write(Lun,10)'CLUSTER=GLOBAL_DATA,,,'//nam//'_GDS.OBJ'
	else if (COM.NUM .gt. 0) then
	   write(Lun,10)'! '
           write(Lun,10)'CLUSTER=GLOBAL_DATA'
	end if
C
C	Write out all the filespecifications for the DEFAULT_CLUSTER
C	NOTE, full pathnames assumed here (no continuation lines)
C	We also want the modules from the UPDATE file to be defined before
C	any files from the main CTL file.
C
	write(Lun,10)'! '
	write(Lun,10)'! Files, libraries, modules for DEFAULT_CLUSTER'
	Do i=GEN.FILNUM+1,FIL.NUM			! Update files
	   if (FIL.D(i).UTL .eq. 0 ) 
     $	       write(Lun,10)FIL.BUF(FIL.D(i).FIR:FIL.D(i).LAS)
	End Do
	Do i=1,GEN.FILNUM				! Regular files
	   if (FIL.D(i).UTL .eq. 0 ) 
     $	       write(Lun,10)FIL.BUF(FIL.D(i).FIR:FIL.D(i).LAS)
	End Do
C
C	Write out all the filespecifications in prescribed cluster order
C	We must use deffered write here, and append continuation sign (,-)
C	to any file that will be followed by another one (in that cluster)
C
	Do k=1,CLU.NUM					! For all CLUSTERS
	   write(Lun,10)'! '				! 
	   write(Lun,10) 'CLUSTER='//	 		! CLUSTER= optkon
     $           CLU.BUF(CLU.D(k).FIR:CLU.D(k).LAS)//',,,-'
           LSAV=0					! Saved file length
  	   Do i=GEN.FILNUM+1,FIL.NUM			! Files from UPD file
	      if (FIL.D(i).UTL .eq. k) then		! If matches the cluster
                 if (LSAV.ne.0) 			! Flush any saved file
     $		    write(Lun,10) SSAV(:LSAV)//',-'	!  with continuation
	         LSAV=FIL.D(i).LAS-FIL.D(i).FIR+1	! Save new string length
     		 SSAV=FIL.BUF(FIL.D(i).FIR:FIL.D(i).LAS)! Save new string
	      end if
	   End Do
  	   Do i=1,GEN.FILNUM				! Files from CTL file
	      if (FIL.D(i).UTL .eq. k) then		! If matches the cluster
                 if (LSAV.ne.0) 			! Flush any saved file
     $		    write(Lun,10) SSAV(:LSAV)//',-'	!  with continuation
	         LSAV=FIL.D(i).LAS-FIL.D(i).FIR+1	! Save new string length
     		 SSAV=FIL.BUF(FIL.D(i).FIR:FIL.D(i).LAS)! Save new string
	      end if
	   End Do
           if (LSAV.ne.0) 			        ! Flush saved filestring
     $	      write(Lun,10) SSAV(:LSAV)			!  without continuation
	End Do ! CLU.NUM
C
C	GLOBAL/LOCAL data redefinition. Declare data based on UTL value:
C
C	 '7FFFFFFF'X = defined as GLOBAL in CTL file, no size given
C	  > 0        = defined as GLOBAL in CTL file, size given OR
C		       size extracted from "reference image"
C	  = 0	     = GLOBAL data extracted from shareable image
C	  < 0        = LOCAL data
C
C	Data PSECTS with size > 0 COLLECT into GLOBAL_DATA cluster
C	(Either explicit size, or explicit GLOBAL statement in CTL)
C	All GLOBAL data define as NOSHR PSECT
C	ALL LOCAL  data define as NOSHR,LCL PSECT
C
C	Redefine PSECT attributes, either to NOSHR or to LOCAL
	If (COM.NUM.gt.0) write(Lun,10)'! '				! 
	Do i=1,COM.NUM
	 if (COM.D(i).UTL .ge. 0) then 
          write(Lun,10)
     $	  'PSECT_ATTR='//COM.BUF(COM.D(i).FIR:COM.D(i).LAS)//',NOSHR'
	 else !	if (COM.D(i).UTL .lt. 0) then
          write(Lun,10)
     $	  'PSECT_ATTR='//COM.BUF(COM.D(i).FIR:COM.D(i).LAS)//',NOSHR,LCL'
	 end if
	End Do
C
C	Collect all the explicitly defined GLOBAL data into cluster GLOBAL_DATA
	If (COM.NUM.gt.0) write(Lun,10)'! '				! 
	Do i=1,COM.NUM
	 if (COM.D(i).UTL.gt.0 ) then 
            write(Lun,10)'COLLECT='//
     $	    'GLOBAL_DATA,'//COM.BUF(COM.D(i).FIR:COM.D(i).LAS)//',NOSHR'
	 end if
	End Do
C
C	Generate UNIVERSAL=name for all defined entry points, skipping
C	any "obsolete" ones.
C
	write(Lun,10)'! '				! 
	Do i=1,ENT.NUM
	 if (ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS).ne.'OBSOLETE') then
	      write(Lun,10)
     $	           'UNIVERSAL='//ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS)
	 end if
	End Do
C
C	Finish UP
C
	write(Lun,10)'! '
	write(Lun,10)'! End of the OPTIONS file'
	close(Lun)
	Call lib$free_lun(Lun)
	Return
	END
