	Subroutine IMGPLL(line,ibeg,iend,ilpa,ityp,ifir,ilas)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGPLL
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Parse the VNS LINKER format line to extract module
C
C       CALLING SEQUENCE --
C	   	Call IMGPLL(LINE,IBEG,IEND,ILPA,ITYP,IFIR,ILAS)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	Parse "LINKER LINE" to find a "module" definition in
C	VAX LINKER file-specification format. The "ibeg" is
C	updated to point to next line element start (or past
C	line end) ==> Call while (ibeg.le.iend)
C	On the first call/line pre-set values: ibeg=1,ilpa=0
C	Errors reported calling IMGSIG, returning ityp=mt_non.
C
C	Handled specifier formats (module_type):
C	mt_non  - invalid module/pathname
C	mt_mul	- pathname/INC=(module,...,module)[,...]
C	mt_sha	- pathname/SHA[,...]
C	mt_lib	- pathname/LIB[,...]
C	mt_inc	- pathname/INC=module[,...]
C	mt_fil	- pathname[,...]
C	
C	NOTES --
C	(1) Input line is assumed to be UPPERCASE
C	(2) This routine handles multiple elements per line. 
C	    Values ilpa, ibeg are used as context holders in
C	    such case.
C	    However,care is needed here, since (later) element 
C	    removal may change "current" default filespecifier.
C	(3) Returned ibeg-2 should always point to last character 
C	    of previous element. This may be used to extract the
C	    line element (for ityp=mt_mul, save ibeg before first
C	    call, and repeat calls until ilpa=0).
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	Include		'IMGPAR/NoList'	! Get parametric values
C
C ARGUMENTS --
	Character*(*)	line	! INP Line segment to scan
	Integer*4	ibeg	! I/O Scanned substring begin
	Integer*4	iend	! INP scanned substring end
	Integer*4	ilpa	! I/O left parentehsis  position or ZERO
	Integer*4	ityp	! OUT module specification type
	Integer*4	ifir	! OUT first module name character
	Integer*4	ilas	! OUT last  module name character
C
C COMMON --
C
C LOCAL VARIABLES --
	Integer*4	irpa	! right parenthesis position 
	Integer*4	isep	! separator (comma) position or ZERO
	Integer*4	ioff	! scanned substring offset (ibeg-1)
	Integer*4	i,j	! utility variables
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
	ioff = ibeg - 1				! Commonly used starting offset
	isep=index (line(ibeg:iend),',')+ioff	! Look for comma
	if (isep.eq.ioff) isep=iend+1		! Not found =  put "comma"
						! after the end of string
C
C	FORM 1: pathname/INC=(module,module,module),
C						! 
	if (ilpa.eq.0) then			! Check possible parenthesis
           ilpa=index(line(ibeg:isep),'(')	! Look for left parenth.
	   if (ilpa.ne.0)ilpa=ilpa+ioff		! Convert to absolute position
	end if
	if (ilpa.ne.0) then			! Type=2, /INC=(M,M,M)
	   irpa=index(line(ibeg:iend),')')+ioff	! Look for closing parenthesis
	   if (irpa.eq.ioff) then		! Not found
	      Call IMGSIG('E-UNBALP, Unbalanced parenthesis: '//
     $			   line(1:iend))	! report error
	      ityp=mt_non			! Set invalid type
	      ibeg=isep+1			! point to next item
	      Return				! and give up
	   else
	      ityp=mt_mul			! Set type /Inc=(MOD,MOD)
	      ifir=ilpa+1
	      if (ilpa.lt.ibeg) ilpa = ibeg	! first module after parent.
	      ilas=irpa-1			! assume last module MOD)
	      if(ifir.gt.ilas) Goto 50		! Empty parenthesis !
	      i=index(line(ifir:ilas),',')+ifir	! look for comma (MOD,MOD,...   
	      if (i.gt.ifir) ilas=i-2		! found, end = (ifir-1)+i-1
	      ilpa=ilas+1			! and move our "parenthesis"
 50	      ibeg=ilas+2			! next string start
	      if (ibeg.lt.iend .and. line(ibeg:ibeg).eq.',') ibeg=ibeg+1
	      if (ibeg.ge.iend) ibeg=iend+2	! make sure comma assumed
	      if (ibeg.gt.irpa) ilpa=0		! no more within parenthesis
	      Goto 100				! check module name size
	   end if
	end if
C
C	FORM 2: pathname/SHA
C
	i=index(line(ibeg:isep),'/SH')+ioff	! Look for /SHared qualifier
	If (i.ne.ioff) then			! YES, found
	   ifir=ibeg				! For /Shareable return
	   ilas=i-1				! the whole pathname
	   ibeg=isep+1				! update next segment begin
	   ityp=mt_sha				! and set correct type
	   Goto 100				! check module name size
	end if
C	
C	FORM 3: pathname/LIB
C
	i=index(line(ibeg:isep),'/LI')+ioff	! Look for /LIbrary qualifier
	If (i.ne.ioff) then			! YES, found
	   ifir=ibeg				! For /Shareable return
	   ilas=i-1				! the whole pathname
	   ibeg=isep+1				! update next segment begin
	   ityp=mt_lib				! and set correct type
	   Goto 100				! check module name size
	end if
C
C	FORM 4: pathname/INC=module,
C
	i=index(line(ibeg:isep),'/IN')+ioff	! Look for /INclude qualifier
	If (i.ne.ioff) then			! YES, found
	   i=index(line(ibeg:isep),'=')		! Look for equal sign
	   if (i.eq.0) then
	      Call IMGSIG('E-MISEQL, Missing equal sign: '//
     $			   line(1:isep))	! report error
	      ityp=mt_non			! Set invalid type
	      ibeg=isep+1			! point to next item
	      Return				! and give up
	   end if
	   ifir=i+ioff+1			! First module name character
	   ilas=isep-1				! last module name character
	   ibeg=isep+1				! update next segment begin
	   ityp=mt_inc				! and set correct type
	   Goto 100				! check module name size
	end if
C
C	FORM 5: pathname[,pathname]
C 	Here we must have full module pathname:  node::dev:[dir]name.ext;ver
C	Locate the "name" position
C
	i=index(line(ibeg:isep),']')		! Look for directory end
	if(i.eq.0) then				! [dire] not found, 
	   i=index(line(ibeg:isep),'::')	! look for "node::"
	   if(i.eq.0) then			! node:: not found,
              i=index(line(ibeg:isep),':')	! try dev:
	   else					! node found, 
	      j=index(line(ibeg+i-1+2:isep),':')! check dev: folowing node::
	      if (j.ne.0)i=i-1+2+j		! found = update pointer
	   end if	          
	end if
	ifir=ibeg				! Assume we did not find any
	if(i.ne.0)ifir=ibeg+i			! we found - point to "name"
C						! Find name terminator (".",";")
	                   ilas=index(line(ifir:isep),'.')+ifir-1
	if(ilas.eq.ifir-1) ilas=index(line(ifir:isep),';')+ifir-1
	if(ilas.eq.ifir-1) ilas=isep		! none = use our separator
	ilas=ilas-1				! but last char = one before
	ibeg=isep+1				! update next segment begin
	ityp=mt_fil					! set correct type
C
100	if(ilas.lt.ifir) then
	   Call IMGSIG('E-MISEQL, Empty module name: '//
     $	                line(1:isep))		! report error
	   ityp=mt_non				! flag unknown types
	end if	    
C
	Return					! finally done
	End        
