	Subroutine IMGRMF(MOD,FIL,imod)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGRMF
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Remove Module File specification from list
C
C       CALLING SEQUENCE --
C		Call IMGRMF(MOD,FIL,imod)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	   Remove the file specification of the module
C	   specified by subscript imod from the file record
C	   (nullify file record if empty)
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	INCLUDE		'IMGPAR/NoList'	! Parameters
	INCLUDE		'IMGDAT/NoList'	! Structures definitions
C
C ARGUMENTS --
	RECORD/SMODU/	MOD		! Module names structure 
	RECORD/SFILE/	FIL		! Image files
	Integer*4	imod		! Module number 
C
C COMMON --
C
C LOCAL VARIABLES --
	Integer*4	ifil		! file record index
	Integer*4	ibeg		! file record first character
	Integer*4	ityp		! Module expression type
	Integer*4	ilpa		! left parenthesis posistion
	Integer*4	ifir		! module name first char
	Integer*4	ilas		! module name last char
	Integer*4	lrec		! working record length
	Character*(pl)	rec		! working record (pathname length)
	Integer*4	i		! utility variable
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Get the file record containing removed module
C
	ifil= MOD.D(imod).FIL
	rec = FIL.BUF(FIL.D(ifil).FIR:FIL.D(ifil).LAS)
	lrec= FIL.D(ifil).LAS - FIL.D(ifil).FIR + 1
C
	ibeg = 1			! Find first module within file record
	ilpa = 0
	Call IMGPLL(rec,ibeg,lrec,ilpa,ityp,ifir,ilas)

	If (ityp.ne.mt_mul) then	! For anything except /INC=(nam,nam)
	   FIL.D(ifil).UTL=-1		! Set undefined cluster, killing file

	else				! File is a set of library modules
	   Do while (rec(ifir:ilas).ne.	
     $	      MOD.BUF(MOD.D(imod).FIR:MOD.D(imod).LAS)) ! Find our module
	      if (ibeg.gt.lrec) then
	         Call IMGSIG('F-INTERR, Internal error in IMGRMF '//
     $		      rec(1:lrec)//' module '//
     $	      	      MOD.BUF(MOD.D(imod).FIR:MOD.D(imod).LAS) )
		 Return					! Not found=error
	      End if
	      Call IMGPLL(rec,ibeg,lrec,ilpa,ityp,ifir,ilas)
	   End do ! while
	   rec =rec(1:ifir-1)//rec(ilas+1:lrec)	! Remove "module" from record
	   lrec=lrec-(ilas-ifir+1)		! Update record lemgth
C
C	   Handle potential "empty expressions" created by module removal
C
	   i=index(rec(:lrec),',,')		! Do we have /INC=(MOD,,MOD)
	   if (i.ne.0) then			! YES
	      rec =rec(1:i-1)//rec(i+1:lrec)	! remove one comma
	      lrec=lrec-1			! update length
	   end if
	   i=index(rec(:lrec),'(,')		! Do we have /INC=(,MOD)
	   if (i.ne.0) then			! YES
	      rec =rec(1:i)//rec(i+2:lrec)	! remove comma
	      lrec=lrec-1			! update length
	   end if
	   i=index(rec(:lrec),',)')		! Do we have /INC=(MOD,)
	   if (i.ne.0) then			! YES
	      rec =rec(1:i-1)//rec(i+1:lrec)	! remove comma
	      lrec=lrec-1			! update length
	   end if
C
C	   Either cancel an empty file record, or write modified one back
C
	   i=index(rec(:lrec),'()')		! Do we have /INC=()
	   if (i.ne.0) then			! Yes = empty record
	      FIL.D(ifil).UTL=-1		! Set undefined cluster
	   else
	      FIL.BUF(FIL.D(ifil).FIR:FIL.D(ifil).LAS)=rec
	      FIL.D(ifil).LAS = FIL.D(ifil).FIR + lrec -1
	   end if
	end if
C
C	rec = FIL.BUF(FIL.D(ifil).FIR:FIL.D(ifil).LAS)
C	lrec= FIL.D(ifil).LAS - FIL.D(ifil).FIR + 1
C	ityp= FIL.D(ifil).UTL
C	write(*,*)'New file record >'//rec(:lrec)//'<'
C	write(*,*)'New cluster index',ityp
C
	Return
	End
