	Subroutine IMGSHR (COM,SHRNAM,SIZES)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGSHR
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Process SHAREABLE IMAGE file
C
C       CALLING SEQUENCE --
C		Call IMGSHR (COM,SHRNAM,SIZES)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C	Process shareable image file (look for global data, if any)
C	Any global data definiton found in SHAREABLE image is added
C	to our global dats (COM) structure (including it's size if
C	requested)
C	Errors are reported if:
C	- shareable image contains SPSECT with non-standard attributes
C	- shareable image SPSECT size does not match already defined 
C	  (shareable image definition used)
C	- user defined SPSEC as LOCAL
C	  (shareable image definition used)
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  06/18/87,,,MXB,Corrected PSECT attribute handling, use GBL sects only
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
C
	INCLUDE		'IMGPAR/NoList'	! Parameters
	INCLUDE		'IMGDAT/NoList'	! Structures definitions
	INCLUDE		'IMGGPS/Nolist'	! GSD PSECT bit definitions
C
C ARGUMENTS --
C
	RECORD/SCOMM/	COM		! Global/Local dtat structure
	Character*(*)	SHRNAM		! Shareable image file pathname
	LOGICAL*1	SIZES		! Include sizes
C
C PARAMETER CONSTANTS --
C
C COMMON -- 
	INCLUDE		'IMGCOM/NoList'	! Common to IMGOPN
C
C LOCAL VARIABLES --
C
	Integer*4	LUN		! VMS LUN to opened file
	Integer*4	ADR(2)		! File VM address range
	Integer*4	GSTREC		! GST records count
	Integer*4	GSTCTX(5)	! GST position contex (REC,SUBREC)
	Character*32	SYM		! GST symbol or PSECT name
	Integer*4	LSYM		! GST symbol actual length
	Integer*4	TYP		! GST record type
	Integer*4	SIZ		! GST symbol size (PSECT only)
	Integer*4	VAL		! GST symbol value
	Integer*4	ATR		! GST symbol attributes
	Integer*4	COMSIZ		! Temp., PSECT size from COM.D(i).UTL
C
	Integer		I		! Utility variables
C
C EQUIVALENCES -- none
C
C EXTERNALS --
C
	EXTERNAL SYS$CRMPSC			! VMS cretae and map section
	EXTERNAL SYS$DELTVA			! VMS delete temp. virtual mem
	EXTERNAL SYS$DASSGN			! VMS deassign channel
	EXTERNAL SEC$M_EXPREG			! Expand region flag
	EXTERNAL IMGOPN				! User OPEN routine
	EXTERNAL IMGSIG				! Local error signalling routine,	
	Integer  SYS$CRMPSC			!
	Integer	 IMGOPN				! 
	Logical	 IMGGSR				! GET next GST sub-record
C
C DATA STATEMENTS --
C
C  /End DECLARATIONS/			    /STANDARD MODULE HEADER/
C  *****************************************************************
C
C START OF EXECUTABLE CODE --
C
C	O P E N  the shareable image file
C
300	Call lib$get_lun(LUN)
	if (LUN.le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (UNIT=LUN,name=SHRNAM,READONLY,SHARED,
     1		DEFAULTFILE='.EXE;0',
     1		USEROPEN=IMGOPN,		! User open to get Channel
     1		STATUS='OLD',ERR=310)		! for map-section
	Goto 400
310	Call IMGSIG('E-OPNSHR, Error opening shr.image '//SHRNAM )
	Return					! We can't do more
C
C	LOAD the shareable image file Here we MAP the entire file
C	into virtual address space.
C
400	ADR(1)=1024				! Request P0 space use
	ADR(2)=1024
	i=SYS$CRMPSC(adr,adr,,%val(%loc(SEC$M_EXPREG)),,,,
     1	            %val(CHAN),,,,)
	if (.not.i) then
	   call sys$dassgn(%val(chan))
	   close (unit=LUN)
	   write(SYM,'(Z8.8)')i
	   Call IMGSIG('E-ERRFIL, error mapping file '//SHRNAM//
     $	        ' status X'//SYM(:8) )
	   Return
	End if
C
C	Here we determine the position and size of the GST table in the
C	image:
500	Call IMGGST(ADR,GSTCTX)
	If (GSTCTX(2).eq.0) then
	   Call IMGSIG (
     $	    'E-NOTGST, image does not contain GST '//SHRNAM )
	   Return
	End if
C
C	Now we will process individual GST records trying to process
C	those of interest to us:
C
	Do while (IMGGSR (GSTCTX,TYP,%ref(SYM),SIZ,VAL,ATR) ) ! While next rec
	   lsym=index(SYM,' ')-1			! Get GST symbol length
C	   TYP: 2=EPT, 0=PSE, 12=SSE, 3=MOD		!
	   if (TYP.eq.12) then				! GST is SPSECT
	     if (iand(ATR,GPS$M_GBL) .ne. 0) then	! Global section
	      If (.not.SIZES) SIZ=0			! Sizes not requested
	      Do i=1,COM.NUM				! Scan defined commons
	         if (lsym-1.eq.(COM.D(i).LAS-COM.D(i).FIR) ) then
	            if (SYM(:LSYM) .eq.
     $	            COM.BUF(COM.D(i).FIR:COM.D(i).LAS) ) then
	               COMSIZ = COM.D(i).UTL		! Get defined size
		       if (COMSIZ .lt. 0 ) then		! Section was LOCAL !?
		          Call IMGSIG('E-GBLDAT, Data section '//SYM(:lsym)//
     $		          ' is GLOBAL in '//SHRNAM )	! Warn user
	                  COM.D(i).UTL = 0		! Make section GLOBAL
                       else if ( COMSIZ .eq.0  ) then 	! Sect. allready GLOBAL
	                  COM.D(i).UTL = SIZ		! set size from image
	               else ! COMSIZ .gt. 0		! Already known size
		          if( COMSIZ .ne. SIZ ) then
		            Call IMGSIG('E-GBLDAT, Data section '//
     $		            SYM(:lsym)//' size different in '//SHRNAM)
	                  End if
	                  COM.D(i).UTL = SIZ		! set size from image
	               End if
		       Goto 800				! Exit loop
	            End if  ! string matches
	         End if	 ! length matches        
	      End Do ! i=1,COM.NUM
C	      Section was not found in our tables, add it NOW
C	      Add a new COMMON record to our structure (GLOBAL names list):
	      If (COM.NUM.eq.mcom) 
     $		 Call IMGSIG('F-MANYGN, GBL DATA  names count overflow')
	      If (COM.FREE+lsym .gt. bcom) 
     $	         Call IMGSIG('F-LONGGD, GBL DATA names buffer overflow')
	      COM.NUM=COM.NUM+1
	      COM.BUF(COM.FREE:COM.FREE+lsym-1)=SYM(:lsym)
	      COM.D(COM.NUM).UTL=SIZ			! Save common size
	      COM.D(COM.NUM).FIR=COM.FREE
	      COM.D(COM.NUM).LAS=COM.FREE+lsym-1
	      COM.FREE          =COM.FREE+lsym
C
	      End if ! (ATR.eq.'019D'X) 
	   End if ! (TYP.eq.12) 
800	   Continue
	End do ! while any more names in GST
C
C	Finish all
	call sys$deltva(adr,,)
	call sys$dassgn(%val(chan))
	close (unit=LUN)
	Return
	End	
