	Subroutine IMGVEC(NAM,GEN,ENT,DUMMY)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGVEC
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		Create the shareable image trensfer VECTOR module
C
C       CALLING SEQUENCE --
C		Call IMGVEC(NAM,GEN,ENT,DUMMY)
C
C       COMMON REFERENCES --
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	include	'IMGPAR'
	include 'IMGDAT'
C
C ARGUMENTS --
	Character*(*)	NAM	! generic name (for module file, name etc)
	Record/SGENP/	GEN	! general parameters
	Record/SENTR/	ENT	! entry names structure
	Logical		DUMMY	! create dummy (stub) vector flag (Dummy=true)
C
C COMMON --
C
C LOCAL VARIABLES --
	Integer 	I	! Utility variable
	Integer		LUN	! Lun for fortran I/O
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
  10	Format (a)		! Output character string format
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Open our output file
C
	Call lib$get_lun(LUN)
	if (LUN.le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (unit=Lun,name=nam//'_VEC.MAR',
     1	      type='NEW',CARRIAGECONTROL='LIST', ERR=100)
	Goto 500
 100	Call IMGSIG('F-OPNERR, error opening vector module file')
	Close (Unit=Lun)
 	Call lib$free_lun(Lun)
C
C	Create the code header of the TRANSFER vector module.
C	
 500	write(Lun,10)'	.TITLE	'//nam//'_VEC Transfer vector module'
	write(Lun,10)'	.IDENT	/'//GEN.BLDID//'/'
	write(Lun,10)';+'
	write(Lun,10)';	(C) Auto-trol Technology Corporation 1987'
	write(Lun,10)';'
	write(Lun,10)';	This module contains the shareable image '//nam
        write(Lun,10)';	transfer vector table '
	write(Lun,10)';	Created  '//GEN.DATE
	write(Lun,10)';	by       '//GEN.USER
	write(Lun,10)';	from     file '//GEN.CTLFI(:GEN.LCTLF)
	write(Lun,10)';	using    IMGGEN '//GEN.VERS
	write(Lun,10)';-'
	write(Lun,10)'	.PSECT ...TRV...,EXE,NOWRT,PIC,SHR,LONG,GBL'
	write(Lun,10)';'
	write(Lun,10)' 	.MACRO	TVECT,entry,seq		; Transfer vector'
	write(Lun,10)'	.iif ne,TVT_SEQ-SEQ,.ERROR TVT_SEQ'//
     1	             '  ; Break in entries sequence at entry'
	write(Lun,10)'	TVT_SEQ=TVT_SEQ+1		;'
	write(Lun,10)' 	.TRANSFER	entry		; handles VMS'
	write(Lun,10)' 	.MASK		entry		; procedures'
	write(Lun,10)' 	JMP		entry+2		; with MASK'
	write(Lun,10)'	.ENDM	TVECT			'
	write(Lun,10)'	.MACRO	DUMMY,entry,seq		; Dummy entry'
	write(Lun,10)'	.iif ne,TVT_SEQ-SEQ,.ERROR TVT_SEQ'//
     1	             '  ; Break in entries sequence at entry'
	write(Lun,10)'	TVT_SEQ=TVT_SEQ+1		;'
	write(Lun,10)'entry::				; Global entry point'
	write(Lun,10)'	.REPEAT 8			; Replace the real'
	write(Lun,10)'	RET				; transfer vector'
	write(Lun,10)'	.ENDR				; with RETurns'
	write(Lun,10)'	.ENDM	DUMMY			;'
	write(Lun,10)';'
	write(Lun,10)'TVT_BEG=.				; Vector table begin'
	write(Lun,10)'TVT_SEQ=1				; Init the sequence #'
C
C	Generate individual entries. 
C	For the "obsolete" entry generate the dummy entry OBSOLETE_nnn
C	For the DUMMY (stub) module generate the DUMMY transfer vector
C
	Do i=1,ENT.NUM
	 if (ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS).eq.'OBSOLETE') then
	      write(Lun,'(a,i4.4,a,i4.4)')
     1	           '	DUMMY	OBSOLETE_',i,',',i
	 else
	   if (DUMMY) then
	      write(Lun,'(a,i4.4)')
     1		   '	DUMMY	'//ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS)
     1	                         //',',i	
	   else  ! not Dummy
	      write(Lun,'(a,i4.4)')
     1	           '	TVECT	'//ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS)
     1	                         //',',i	
	   end if !Dummy
	 end if
	End Do
C
C	If the table size has been defined, add the required macro code
C	to fill the rest of the transfer vector table
C
	if (GEN.TBSIZ.ne.0) then
	 write(Lun,10)
     1   	     'TVT_SIZ =	.-TVT_BEG		; Current table size'
	 write(Lun,'(a,I8,a)')
     1	             'TVT_MAX =	',GEN.TBSIZ,'		; Required table size'
	 write(Lun,10)'	.if lt 	TVT_MAX-TVT_SIZ		; Check for errors'
	 write(Lun,10)'	.ERROR 	1 			; Vector table overflow'
	 write(Lun,10)'	.endc				;'
	 write(Lun,10)'	.REPEAT	TVT_MAX-TVT_SIZ		; Load rest of table'
	 write(Lun,10)'	RET				; with RETurns'
	 write(Lun,10)'	.ENDR				; '
	end if
	write(Lun,10)'	.END'
	close(Lun)
	Call lib$free_lun(Lun)
	Return
	END
