	Subroutine IMGXFR(NAM,GEN,ENT)
C	###############################################################
C	# (C) Copyright 1985 Auto-trol Technology Corporation         #
C	#                                                             #
C	# This program is the sole property of Auto-trol Technology   #
C	# Corporation and is considered a trade secret and/or a       #
C	# proprietary product of Auto-trol Technology Corporation.    #
C	# Use or disclosure of this program by other than Auto-trol   #
C	# Technology Corporation and its assigned licensees and       #
C	# customers is strictly forbidden by law.                     #
C	#                                                             #
C	# Use, duplication or disclosure by the Government is subject #
C	# to restrictions as set forth in subdivision (b)(3)(ii) of   #
C	# the Rights in Technical Data and Computer Software clause   #
C	# at 252.227.7013.                                            #
C	###############################################################
C
C      /BEGIN MODULE HEADER/        		/STANDARD MODULE HEADER/
C
C       NAME -- IMGXFR
C
C       PURPOSE -- VAX IMAGE BUILD TOOLS
C		   Create the Dynamic Transfer Vector module
C
C       CALLING SEQUENCE --
C		Call IMGXFR(NAM,GEN,ENT)
C
C       COMMON REFERENCES -- none
C
C       ERRORS DETECTED --
C              Handled by a call to IMGMSG, terminating by severity "F"
C
C       EXTERNAL REFERENCES --
C
C       INTERNAL DESCRIPTION AND DESIGN CONSIDERATIONS --
C	
C	   Routine creates the MACRO source for the Dynamic Image
C	   Load transfer vector module. The format of XFR entries
C	   is closely related to the AUOSI SIMGLD routine, which
C	   is called by any entry during the first load.
C	   Routine generates "dynamic entry" for all the entries
C	   specified by the caller (in the CTL file).
C
C       NOTES --
C
C       HISTORY --
C         MM/DD/YY,SDRC,functional spec number,initials,comments
C	  02/24/87,,,MXB,Initial coding
C
C /END MODULE HEADER/        		    /STANDARD MODULE HEADER/
C ******************************************************************
	IMPLICIT NONE			! Force all declared
C
C PARAMETER CONSTANTS --
	include	'IMGPAR'
	include 'IMGDAT'
C
C ARGUMENTS --
	Character*(*)	NAM	! generic name (for module file, name etc)
	Record/SGENP/	GEN	! general parameters
	Record/SENTR/	ENT	! entry names structure
C
C COMMON --
C
C LOCAL VARIABLES --
	Integer 	I	! Utility variable
	Integer		LUN	! Lun for fortran I/O
C
C EQUIVALENCES --
C
C EXTERNALS --
C
C DATA STATEMENTS --
C
  10	Format (a)		! Output character string format
C
C /END DECLARATIONS/			    /STANDARD MODULE HEADER/
C ******************************************************************
C
C START OF EXECUTABLE CODE --
C
C	Start with basic data validity checks:
C
	if (GEN.LIMAG.eq.0) Call IMGSIG('F-EMPIMG, Empty image name')
	if (ENT.NUM  .eq.0) Call IMGSIG('F-NOENTR, No entries to image')
C
C	Open our output file
C
	Call lib$get_lun(LUN)
	if (LUN.le.0) Call IMGSIG('F-NOLUN, no LUN available')
	Open (unit=Lun,name=nam//'_XFR.MAR',
     1	      type='NEW',CARRIAGECONTROL='LIST', ERR=100)
	Goto 500
 100	Call IMGSIG('F-OPNERR, error opening dyn.transfer module file')
	Close (Unit=Lun)
 	Call lib$free_lun(Lun)
C
C	Create the code header of the TRANSFER vector module.
C	
 500	write(Lun,10)'	.TITLE	'//nam//'_XFR Dynamic Transfer Module'
	write(Lun,10)'	.IDENT	/'//GEN.BLDID//'/'
	write(Lun,10)';+'
	write(Lun,10)';	(C) Auto-trol Technology Corporation 1987'
	write(Lun,10)';'
	write(Lun,10)';	This module contains the Dynamic Transfer Vector'
        write(Lun,10)';	for calls to image '//GEN.IMAGE(:GEN.LIMAG)
	write(Lun,10)';'
	write(Lun,10)';	Created  '//GEN.DATE
	write(Lun,10)';	by       '//GEN.USER
	write(Lun,10)';	from     file '//GEN.CTLFI(:GEN.LCTLF)
	write(Lun,10)';	using    IMGGEN '//GEN.VERS
	write(Lun,10)';-'
	write(Lun,10)';'
	write(Lun,10)'	.MACRO	DYNXFER,modnam,?l1,?l2,?l3'
	write(Lun,10)'	.ALIGN	LONG		; Longword aligned'
	write(Lun,10)'	.ENTRY	modnam,^M<R2,R3>; Entry mask to replace'
	write(Lun,10)'	JSB	G^SIMGLD+2	; JSB to replace by JMP'
	write(Lun,10)'l1:	.WORD	USRERR-l1+8	; Offset to ERR adr'
	write(Lun,10)'	.BYTE	l3-l2		; Entry name length'
	write(Lun,10)'l2:	.ASCII	/modnam/	; Module name'
	write(Lun,10)'l3:'
	write(Lun,10)'	.ENDM'
	write(Lun,10)';'
	write(Lun,10)';	Our transfer vectors use a very specific Psect:'
	write(Lun,10)';	Non shareable, writeable, PIC instructions'
	write(Lun,10)';'
	write(Lun,10)'	.PSECT	$AAAXFR,PIC,CON,REL,LCL,NOSHR,EXE,RD,WRT,LONG'
	write(Lun,10)';'
	write(Lun,10)';	The IMGNAM must be at offset USRERR+4 for SIMGLD '
	if (GEN.LERRO.ne.0) then
     	  write(Lun,10)'USRERR:	.ADDRESS '//GEN.ERROR(:GEN.LERRO)//
     $	           '	; User error routine'
	else
     	  write(Lun,10)'USRERR:	.LONG	0'
	end if
	write(Lun,10)'IMGNAM:	.ASCID	%'//GEN.IMAGE(:GEN.LIMAG)//'%'//
     $	           '	; Shareable image log. name'
	write(Lun,10)';'
C
C	Generate individual entries, skipping "obsolete" ones
C
	Do i=1,ENT.NUM
	 if (ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS).ne.'OBSOLETE') then
	      write(Lun,10)
     $	           '	DYNXFER	'//ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS)//
     $	           '	; Entry '//ENT.BUF(ENT.D(i).FIR:ENT.D(i).LAS)
	 end if
	End Do
C
	write(Lun,10)';'
	write(Lun,10)'	.END'
	close(Lun)
	Call lib$free_lun(Lun)
	Return
	END
